/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gzipfilter.selector;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PatternMatcher {
    private final Map patternCache = Collections.synchronizedMap(new HashMap());

    public boolean matches(String contentType, String mimeTypesToGzip) {
        String[] mimeTypes = StringUtils.split(mimeTypesToGzip, ",");
        for (int i = 0; i < mimeTypes.length; ++i) {
            String mimeType = mimeTypes[i].trim();
            Pattern p = (Pattern)this.patternCache.get(mimeType);
            if (p == null) {
                p = Pattern.compile(mimeType);
                this.patternCache.put(mimeType, p);
            }
            if (!p.matcher(contentType).matches()) continue;
            return true;
        }
        return false;
    }
}

