/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.tags.Resources;
import org.apache.commons.jelly.tags.sql.ResultImpl;
import org.apache.commons.jelly.tags.sql.SqlTagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryTag
extends SqlTagSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jelly$tags$sql$QueryTag == null ? (class$org$apache$commons$jelly$tags$sql$QueryTag = QueryTag.class$("org.apache.commons.jelly.tags.sql.QueryTag")) : class$org$apache$commons$jelly$tags$sql$QueryTag));
    protected int maxRows = -1;
    protected boolean maxRowsSpecified;
    protected int startRow;
    private Connection conn;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$sql$QueryTag;

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        this.maxRowsSpecified = true;
    }

    /*
     * Loose catch block
     */
    public void doTag(XMLOutput output) throws JellyTagException {
        block32: {
            SQLException e222;
            Statement statement;
            ResultSet rs;
            String sqlStatement;
            block29: {
                Object obj;
                if (!this.maxRowsSpecified && (obj = this.context.getVariable("org.apache.commons.jelly.sql.maxRows")) != null) {
                    if (obj instanceof Integer) {
                        this.maxRows = (Integer)obj;
                    } else if (obj instanceof String) {
                        try {
                            this.maxRows = Integer.parseInt((String)obj);
                        }
                        catch (NumberFormatException nfe) {
                            throw new JellyTagException(Resources.getMessage((String)"SQL_MAXROWS_PARSE_ERROR", (Object)((String)obj)), (Throwable)nfe);
                        }
                    } else {
                        throw new JellyTagException(Resources.getMessage((String)"SQL_MAXROWS_INVALID"));
                    }
                }
                ResultImpl result = null;
                sqlStatement = null;
                log.debug((Object)"About to lookup connection");
                rs = null;
                statement = null;
                this.conn = this.getConnection();
                sqlStatement = this.sql != null ? this.sql : this.getBodyText();
                if (sqlStatement == null || sqlStatement.trim().length() == 0) {
                    throw new JellyTagException(Resources.getMessage((String)"SQL_NO_STATEMENT"));
                }
                if (this.startRow < 0 || this.maxRows < -1) {
                    throw new JellyTagException(Resources.getMessage((String)"PARAM_BAD_VALUE"));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("About to execute query: " + sqlStatement));
                }
                if (this.hasParameters()) {
                    PreparedStatement ps = this.conn.prepareStatement(sqlStatement);
                    statement = ps;
                    this.setParameters(ps);
                    rs = ps.executeQuery();
                } else {
                    statement = this.conn.createStatement();
                    rs = statement.executeQuery(sqlStatement);
                }
                result = new ResultImpl(rs, this.startRow, this.maxRows);
                this.context.setVariable(this.var, (Object)result);
                ResultSet tempRs = rs;
                rs = null;
                tempRs.close();
                Statement tempStatement = statement;
                statement = null;
                tempStatement.close();
                Object var9_10 = null;
                if (rs == null) break block29;
                try {
                    rs.close();
                }
                catch (SQLException e222) {
                    log.error((Object)("Caught exception while closing result set: " + e222), (Throwable)e222);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e222) {
                    log.error((Object)("Caught exception while closing statement: " + e222), (Throwable)e222);
                }
            }
            if (this.conn == null || this.isPartOfTransaction) break block32;
            try {
                this.conn.close();
            }
            catch (SQLException e222) {
                log.error((Object)("Caught exception while closing connection: " + e222), (Throwable)e222);
            }
            this.conn = null;
            {
                break block32;
                catch (SQLException e3) {
                    throw new JellyTagException(sqlStatement + ": " + e3.getMessage(), (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e222) {
                        log.error((Object)("Caught exception while closing result set: " + e222), (Throwable)e222);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e222) {
                        log.error((Object)("Caught exception while closing statement: " + e222), (Throwable)e222);
                    }
                }
                if (this.conn != null && !this.isPartOfTransaction) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException e222) {
                        log.error((Object)("Caught exception while closing connection: " + e222), (Throwable)e222);
                    }
                    this.conn = null;
                }
                this.clearParameters();
                throw throwable;
            }
        }
        this.clearParameters();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

