/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.util;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutStorageException;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.rpc.exception.RemoteException;
import com.atlassian.jira.rpc.exception.RemoteValidationException;
import com.atlassian.jira.rpc.soap.beans.AbstractRemoteEntity;
import com.atlassian.jira.rpc.soap.beans.RemoteAttachment;
import com.atlassian.jira.rpc.soap.beans.RemoteComment;
import com.atlassian.jira.rpc.soap.beans.RemoteComponent;
import com.atlassian.jira.rpc.soap.beans.RemoteCustomFieldValue;
import com.atlassian.jira.rpc.soap.beans.RemoteFilter;
import com.atlassian.jira.rpc.soap.beans.RemoteIssueType;
import com.atlassian.jira.rpc.soap.beans.RemotePriority;
import com.atlassian.jira.rpc.soap.beans.RemoteProject;
import com.atlassian.jira.rpc.soap.beans.RemoteResolution;
import com.atlassian.jira.rpc.soap.beans.RemoteStatus;
import com.atlassian.jira.rpc.soap.beans.RemoteVersion;
import com.atlassian.jira.util.ErrorCollection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

public class SoapUtils {
    public static RemoteProject[] getProjects(Collection projects, ApplicationProperties applicationProperties) {
        RemoteProject[] result = new RemoteProject[projects.size()];
        int count = 0;
        for (GenericValue project : projects) {
            RemoteProject remoteProject = new RemoteProject(project, applicationProperties);
            result[count++] = remoteProject;
        }
        return result;
    }

    public static RemoteVersion[] getVersions(Collection versions) {
        RemoteVersion[] result = new RemoteVersion[versions.size()];
        int count = 0;
        for (Object o : versions) {
            GenericValue gv = o instanceof Version ? ((Version)o).getGenericValue() : (GenericValue)o;
            result[count++] = new RemoteVersion(gv);
        }
        return result;
    }

    public static RemoteVersion[] convertVersionsToRemoteObject(Collection versions) {
        RemoteVersion[] result = new RemoteVersion[versions.size()];
        int count = 0;
        for (Version version : versions) {
            result[count++] = new RemoteVersion(version.getId().toString(), version.getName(), version.isReleased(), version.isArchived(), version.getSequence(), version.getReleaseDate());
        }
        return result;
    }

    public static RemoteComponent[] getComponents(Collection components) {
        RemoteComponent[] result = new RemoteComponent[components.size()];
        int count = 0;
        for (GenericValue component : components) {
            result[count++] = new RemoteComponent(component);
        }
        return result;
    }

    public static RemoteComponent[] convertComponentsToRemoteObject(Collection components) {
        RemoteComponent[] result = new RemoteComponent[components.size()];
        int count = 0;
        for (ProjectComponent component : components) {
            result[count++] = new RemoteComponent(component.getId().toString(), component.getName());
        }
        return result;
    }

    public static RemoteIssueType[] getIssueTypes(Collection issueTypes) {
        RemoteIssueType[] result = new RemoteIssueType[issueTypes.size()];
        SubTaskManager subTaskManager = ComponentManager.getInstance().getSubTaskManager();
        int count = 0;
        for (GenericValue issueType : issueTypes) {
            result[count++] = new RemoteIssueType(issueType, subTaskManager.isSubTaskIssueType(issueType));
        }
        return result;
    }

    public static RemoteIssueType[] getIssueTypeObjects(Collection issueTypeObjects) {
        RemoteIssueType[] result = new RemoteIssueType[issueTypeObjects.size()];
        int count = 0;
        for (IssueType issueType : issueTypeObjects) {
            result[count++] = new RemoteIssueType(issueType.getGenericValue(), issueType.isSubTask());
        }
        return result;
    }

    public static RemoteStatus[] getStatuses(Collection statuses) {
        RemoteStatus[] result = new RemoteStatus[statuses.size()];
        int count = 0;
        for (GenericValue status : statuses) {
            result[count++] = new RemoteStatus(status);
        }
        return result;
    }

    public static RemoteResolution[] getResolutions(Collection resolutions) {
        RemoteResolution[] result = new RemoteResolution[resolutions.size()];
        int count = 0;
        for (GenericValue resolution : resolutions) {
            result[count++] = new RemoteResolution(resolution);
        }
        return result;
    }

    public static RemotePriority[] getPriorities(Collection priorities) {
        RemotePriority[] result = new RemotePriority[priorities.size()];
        int count = 0;
        for (GenericValue priority : priorities) {
            result[count++] = new RemotePriority(priority);
        }
        return result;
    }

    public static RemoteFilter[] getFilters(Collection searchRequests) {
        RemoteFilter[] result = new RemoteFilter[searchRequests.size()];
        int count = 0;
        for (SearchRequest searchRequest : searchRequests) {
            result[count++] = new RemoteFilter(searchRequest);
        }
        return result;
    }

    public static RemoteComment[] getComments(List comments) {
        RemoteComment[] result = new RemoteComment[comments.size()];
        int count = 0;
        for (Comment comment : comments) {
            result[count++] = new RemoteComment(comment);
        }
        return result;
    }

    public static RemoteAttachment[] getAttachments(List attachments) {
        RemoteAttachment[] result = new RemoteAttachment[attachments.size()];
        int count = 0;
        for (Attachment attachment : attachments) {
            result[count++] = new RemoteAttachment(attachment);
        }
        return result;
    }

    public static RemoteCustomFieldValue[] getCustomFieldValues(List customFields, Issue issue) {
        ArrayList<RemoteCustomFieldValue> remoteCustomFieldValues = new ArrayList<RemoteCustomFieldValue>();
        for (CustomField customField : customFields) {
            String[] values;
            CustomFieldType customFieldType = customField.getCustomFieldType();
            Object cfTransferObjectValue = customField.getValue(issue);
            if (cfTransferObjectValue instanceof CustomFieldParams) {
                CustomFieldParams customFieldParams = (CustomFieldParams)cfTransferObjectValue;
                if (customFieldParams.isEmpty()) continue;
                Set keyValues = customFieldParams.getKeysAndValues().entrySet();
                for (Map.Entry entry : keyValues) {
                    String key = (String)entry.getKey();
                    String[] valuesForLevel = SoapUtils.transformToStringArray((Collection)entry.getValue(), customFieldType);
                    if (key == null || "".equals(key)) {
                        remoteCustomFieldValues.add(new RemoteCustomFieldValue(customField.getId(), null, valuesForLevel));
                        continue;
                    }
                    remoteCustomFieldValues.add(new RemoteCustomFieldValue(customField.getId(), key, valuesForLevel));
                }
                continue;
            }
            if (cfTransferObjectValue instanceof Collection) {
                values = SoapUtils.transformToStringArray((Collection)cfTransferObjectValue, customFieldType);
                remoteCustomFieldValues.add(new RemoteCustomFieldValue(customField.getId(), null, values));
                continue;
            }
            if (cfTransferObjectValue == null) continue;
            values = new String[]{customFieldType.getStringFromSingularObject(cfTransferObjectValue)};
            remoteCustomFieldValues.add(new RemoteCustomFieldValue(customField.getId(), null, values));
        }
        RemoteCustomFieldValue[] result = new RemoteCustomFieldValue[remoteCustomFieldValues.size()];
        int count = 0;
        Iterator iterator = remoteCustomFieldValues.iterator();
        while (iterator.hasNext()) {
            result[count++] = (RemoteCustomFieldValue)iterator.next();
        }
        return result;
    }

    private static String[] transformToStringArray(Collection values, CustomFieldType customFieldType) {
        String[] returnValues = new String[values.size()];
        int i = 0;
        for (Object singularObject : values) {
            returnValues[i] = customFieldType.getStringFromSingularObject(singularObject);
            ++i;
        }
        return returnValues;
    }

    public static String[] getRemoteEntityIdsAsString(AbstractRemoteEntity[] entities) {
        String[] entityIds = new String[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            AbstractRemoteEntity entity = entities[i];
            entityIds[i] = entity.getId();
        }
        return entityIds;
    }

    public static List getRemoteEntityIds(AbstractRemoteEntity[] entities) {
        ArrayList<Long> versionIds = new ArrayList<Long>(entities.length);
        for (int i = 0; i < entities.length; ++i) {
            AbstractRemoteEntity entity = entities[i];
            versionIds.add(new Long(entity.getId()));
        }
        return versionIds;
    }

    public static Timestamp toTimeStamp(Date date) {
        return date == null ? null : new Timestamp(date.getTime());
    }

    public static boolean isVisible(GenericValue issue, String fieldname) throws FieldLayoutStorageException {
        FieldLayout fieldLayout = ComponentManager.getInstance().getFieldLayoutManager().getFieldLayout(issue);
        return !fieldLayout.getFieldLayoutItem(ComponentManager.getInstance().getFieldManager().getOrderableField(fieldname)).isHidden();
    }

    public static Long toLong(String longStr) throws RemoteValidationException {
        if (longStr == null) {
            return null;
        }
        return SoapUtils.toLongRequired(longStr);
    }

    public static Long toLongRequired(String longStr) throws RemoteValidationException {
        try {
            return new Long(longStr);
        }
        catch (NumberFormatException nfe) {
            throw new RemoteValidationException(nfe);
        }
    }

    public static void checkServiceContext(JiraServiceContext serviceContext) throws RemoteException {
        ErrorCollection errorCollection = serviceContext.getErrorCollection();
        if (errorCollection.hasAnyErrors()) {
            if (errorCollection.getErrorMessages().isEmpty()) {
                Map errors = errorCollection.getErrors();
                throw new RemoteException((String)errors.values().iterator().next());
            }
            throw new RemoteException((String)errorCollection.getErrorMessages().iterator().next());
        }
    }
}

