/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.service;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rpc.exception.RemoteException;
import com.atlassian.jira.rpc.exception.RemoteValidationException;
import com.atlassian.jira.rpc.soap.beans.RemoteProject;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRole;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRoleActors;
import com.atlassian.jira.rpc.soap.beans.RemoteRoleActor;
import com.atlassian.jira.rpc.soap.beans.RemoteRoleActors;
import com.atlassian.jira.rpc.soap.beans.RemoteScheme;
import com.atlassian.jira.rpc.soap.beans.RemoteUser;
import com.atlassian.jira.rpc.soap.service.ProjectRoleService;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.opensymphony.user.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;

public class ProjectRoleServiceImpl
implements ProjectRoleService {
    private com.atlassian.jira.bc.projectroles.ProjectRoleService projectRoleService;
    private ProjectManager projectManager;
    private ProjectFactory projectFactory;

    public ProjectRoleServiceImpl(com.atlassian.jira.bc.projectroles.ProjectRoleService projectRoleService, ProjectManager projectManager, ProjectFactory projectFactory) {
        this.projectRoleService = projectRoleService;
        this.projectManager = projectManager;
        this.projectFactory = projectFactory;
    }

    public RemoteProjectRole[] getProjectRoles(User currentUser) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ArrayList<RemoteProjectRole> remoteRoles = new ArrayList<RemoteProjectRole>();
        Collection realRoles = this.projectRoleService.getProjectRoles(currentUser, (ErrorCollection)errorCollection);
        this.checkAndThrowErrors("Error getting project role", (ErrorCollection)errorCollection);
        for (ProjectRole projectRole : realRoles) {
            remoteRoles.add(new RemoteProjectRole(projectRole.getId(), projectRole.getName(), projectRole.getDescription()));
        }
        return remoteRoles.toArray(new RemoteProjectRole[remoteRoles.size()]);
    }

    public RemoteProjectRole getProjectRole(User currentUser, Long id) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole realRole = this.projectRoleService.getProjectRole(currentUser, id, (ErrorCollection)errorCollection);
        this.checkAndThrowErrors("Error getting project role", (ErrorCollection)errorCollection);
        return new RemoteProjectRole(realRole.getId(), realRole.getName(), realRole.getDescription());
    }

    public RemoteProjectRole createProjectRole(User currentUser, RemoteProjectRole projectRole) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole realRole = this.getProjectRoleFromRemoteProjectRole(projectRole);
        realRole = this.projectRoleService.createProjectRole(currentUser, realRole, (ErrorCollection)errorCollection);
        this.checkAndThrowErrors("Error creating project role", (ErrorCollection)errorCollection);
        return new RemoteProjectRole(realRole.getId(), realRole.getName(), realRole.getDescription());
    }

    public boolean isProjectRoleNameUnique(User currentUser, String name) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        boolean isUnique = this.projectRoleService.isProjectRoleNameUnique(currentUser, name, (ErrorCollection)errorCollection);
        this.checkAndThrowErrors("Error checking unique role name", (ErrorCollection)errorCollection);
        return isUnique;
    }

    public void deleteProjectRole(User currentUser, RemoteProjectRole projectRole, boolean confirm) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole realRole = this.getProjectRoleFromRemoteProjectRole(projectRole);
        if (!confirm) {
            this.checkIfRoleHasAssociations(currentUser, realRole, errorCollection, projectRole);
        }
        this.projectRoleService.deleteProjectRole(currentUser, realRole, (ErrorCollection)errorCollection);
        this.checkAndThrowErrors("Error deleting project role", (ErrorCollection)errorCollection);
    }

    private void checkIfRoleHasAssociations(User currentUser, ProjectRole realRole, SimpleErrorCollection errorCollection, RemoteProjectRole projectRole) throws RemoteException {
        ArrayList associatedSchemes = new ArrayList();
        associatedSchemes.addAll(this.projectRoleService.getAssociatedNotificationSchemes(currentUser, realRole, (ErrorCollection)errorCollection));
        associatedSchemes.addAll(this.projectRoleService.getAssociatedPermissionSchemes(currentUser, realRole, (ErrorCollection)errorCollection));
        if (!associatedSchemes.isEmpty()) {
            StringBuffer message = new StringBuffer("Project Role: ");
            message.append(projectRole.getName());
            message.append(" is associated with the following scheme(s): ");
            Iterator iterator = associatedSchemes.iterator();
            while (iterator.hasNext()) {
                GenericValue scheme = (GenericValue)iterator.next();
                message.append(scheme.getString("name"));
                if (!iterator.hasNext()) continue;
                message.append(", ");
            }
            message.append(". To force deletion of this role make the confirm parameter true.");
            throw new RemoteException(message.toString());
        }
    }

    public void addActorsToProjectRole(User currentUser, String[] actors, RemoteProjectRole projectRole, RemoteProject project, String actorType) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Project realProject = this.getProjectFromRemoteProject(project);
        ProjectRole realRole = this.getProjectRoleFromRemoteProjectRole(projectRole);
        this.projectRoleService.addActorsToProjectRole(currentUser, Arrays.asList(actors), realRole, realProject, actorType, (ErrorCollection)errorCollection);
        this.checkAndThrowErrors("Error adding actors to project role", (ErrorCollection)errorCollection);
    }

    public void removeActorsFromProjectRole(User currentUser, String[] actors, RemoteProjectRole projectRole, RemoteProject project, String actorType) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Project realProject = this.getProjectFromRemoteProject(project);
        ProjectRole realRole = this.getProjectRoleFromRemoteProjectRole(projectRole);
        this.projectRoleService.removeActorsFromProjectRole(currentUser, Arrays.asList(actors), realRole, realProject, actorType, (ErrorCollection)errorCollection);
        this.checkAndThrowErrors("Error removing actors from project role", (ErrorCollection)errorCollection);
    }

    public void updateProjectRole(User currentUser, RemoteProjectRole projectRole) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole realRole = this.getProjectRoleFromRemoteProjectRole(projectRole);
        this.projectRoleService.updateProjectRole(currentUser, realRole, (ErrorCollection)errorCollection);
        this.checkAndThrowErrors("Error updating project role", (ErrorCollection)errorCollection);
    }

    public RemoteProjectRoleActors getProjectRoleActors(User currentUser, RemoteProjectRole projectRole, RemoteProject project) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole realRole = this.getProjectRoleFromRemoteProjectRole(projectRole);
        Project realProject = this.getProjectFromRemoteProject(project);
        ProjectRoleActors projectRoleActors = this.projectRoleService.getProjectRoleActors(currentUser, realRole, realProject, (ErrorCollection)errorCollection);
        this.checkAndThrowErrors("Error getting project role actors", (ErrorCollection)errorCollection);
        return this.convertProjectRoleActorsToRemote(projectRoleActors, projectRole, project);
    }

    public RemoteRoleActors getDefaultRoleActors(User currentUser, RemoteProjectRole projectRole) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole realRole = this.getProjectRoleFromRemoteProjectRole(projectRole);
        DefaultRoleActors projectRoleActors = this.projectRoleService.getDefaultRoleActors(currentUser, realRole, (ErrorCollection)errorCollection);
        this.checkAndThrowErrors("Error getting default role actors", (ErrorCollection)errorCollection);
        return this.convertRoleActorsToRemote(projectRoleActors, projectRole);
    }

    public void addDefaultActorsToProjectRole(User currentUser, String[] actorNames, RemoteProjectRole projectRole, String type) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole realRole = this.getProjectRoleFromRemoteProjectRole(projectRole);
        this.projectRoleService.addDefaultActorsToProjectRole(currentUser, Arrays.asList(actorNames), realRole, type, (ErrorCollection)errorCollection);
        this.checkAndThrowErrors("Error adding default actors to project role", (ErrorCollection)errorCollection);
    }

    public void removeDefaultActorsFromProjectRole(User currentUser, String[] actors, RemoteProjectRole projectRole, String actorType) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole realRole = this.getProjectRoleFromRemoteProjectRole(projectRole);
        this.projectRoleService.removeDefaultActorsFromProjectRole(currentUser, Arrays.asList(actors), realRole, actorType, (ErrorCollection)errorCollection);
        this.checkAndThrowErrors("Error removing default actors from project role", (ErrorCollection)errorCollection);
    }

    public void removeAllRoleActorsByNameAndType(User currentUser, String name, String type) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        this.projectRoleService.removeAllRoleActorsByNameAndType(currentUser, name, type, (ErrorCollection)errorCollection);
        this.checkAndThrowErrors("Error removing role actors by name and type", (ErrorCollection)errorCollection);
    }

    public void removeAllRoleActorsByProject(User currentUser, RemoteProject project) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Project realProject = this.getProjectFromRemoteProject(project);
        this.projectRoleService.removeAllRoleActorsByProject(currentUser, realProject, (ErrorCollection)errorCollection);
        this.checkAndThrowErrors("Error removing role actors by project", (ErrorCollection)errorCollection);
    }

    public RemoteScheme[] getAssociatedNotificationSchemes(User currentUser, RemoteProjectRole projectRole) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole realRole = this.getProjectRoleFromRemoteProjectRole(projectRole);
        Collection notificationSchemes = this.projectRoleService.getAssociatedNotificationSchemes(currentUser, realRole, (ErrorCollection)errorCollection);
        return this.convertSchemesToRemote(notificationSchemes, "notification");
    }

    private RemoteScheme[] convertSchemesToRemote(Collection notificationSchemes, String type) {
        ArrayList<RemoteScheme> remoteSchemes = new ArrayList<RemoteScheme>();
        for (GenericValue scheme : notificationSchemes) {
            remoteSchemes.add(new RemoteScheme(scheme, type));
        }
        return remoteSchemes.toArray(new RemoteScheme[remoteSchemes.size()]);
    }

    public RemoteScheme[] getAssociatedPermissionSchemes(User currentUser, RemoteProjectRole projectRole) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole realRole = this.getProjectRoleFromRemoteProjectRole(projectRole);
        Collection permissionSchemes = this.projectRoleService.getAssociatedPermissionSchemes(currentUser, realRole, (ErrorCollection)errorCollection);
        return this.convertSchemesToRemote(permissionSchemes, "permission");
    }

    private RemoteProjectRoleActors convertProjectRoleActorsToRemote(ProjectRoleActors projectRoleActors, RemoteProjectRole projectRole, RemoteProject project) {
        RemoteRoleActor[] remoteRoleActorsArr = this.populateRemoteRoleActors((DefaultRoleActors)projectRoleActors, projectRole);
        return new RemoteProjectRoleActors(project, projectRole, remoteRoleActorsArr);
    }

    private RemoteRoleActors convertRoleActorsToRemote(DefaultRoleActors defaultRoleActors, RemoteProjectRole projectRole) {
        RemoteRoleActor[] remoteRoleActorsArr = this.populateRemoteRoleActors(defaultRoleActors, projectRole);
        return new RemoteRoleActors(projectRole, remoteRoleActorsArr);
    }

    private RemoteRoleActor[] populateRemoteRoleActors(DefaultRoleActors projectRoleActors, RemoteProjectRole projectRole) {
        ArrayList<RemoteRoleActor> remoteRoleActors = new ArrayList<RemoteRoleActor>();
        for (RoleActor roleActor : projectRoleActors.getRoleActors()) {
            remoteRoleActors.add(new RemoteRoleActor(projectRole, roleActor.getDescriptor(), roleActor.getType(), roleActor.getParameter(), this.convertRealUsersToRemoteUsers(roleActor.getUsers())));
        }
        return remoteRoleActors.toArray(new RemoteRoleActor[remoteRoleActors.size()]);
    }

    private RemoteUser[] convertRealUsersToRemoteUsers(Set users) {
        ArrayList<RemoteUser> remoteUsers = new ArrayList<RemoteUser>();
        for (User user : users) {
            remoteUsers.add(new RemoteUser(user));
        }
        return remoteUsers.toArray(new RemoteUser[remoteUsers.size()]);
    }

    private ProjectRole getProjectRoleFromRemoteProjectRole(RemoteProjectRole projectRole) throws RemoteException {
        if (projectRole == null) {
            throw new RemoteException("RemoteProjectRole can not be null");
        }
        return new ProjectRoleImpl(projectRole.getId(), projectRole.getName(), projectRole.getDescription());
    }

    private Project getProjectFromRemoteProject(RemoteProject project) throws RemoteException {
        if (project == null) {
            throw new RemoteException("RemoteProject can not be null");
        }
        try {
            GenericValue projectGV = this.projectManager.getProject(new Long(project.getId()));
            return this.projectFactory.getProject(projectGV);
        }
        catch (Exception e) {
            throw new RemoteValidationException("Could not resolve a project for the RemoteProject with id: " + project.getId());
        }
    }

    private void checkAndThrowErrors(String from, ErrorCollection errorCollection) throws RemoteException {
        if (errorCollection.hasAnyErrors()) {
            throw new RemoteValidationException(from, errorCollection);
        }
    }
}

