/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.service;

import com.atlassian.core.util.LocaleUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.JiraException;
import com.atlassian.jira.action.issue.IssueDeleteInterface;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.IssueUtilsBean;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.OperationContextImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rpc.exception.RemoteException;
import com.atlassian.jira.rpc.exception.RemotePermissionException;
import com.atlassian.jira.rpc.exception.RemoteValidationException;
import com.atlassian.jira.rpc.soap.beans.RemoteAttachment;
import com.atlassian.jira.rpc.soap.beans.RemoteComment;
import com.atlassian.jira.rpc.soap.beans.RemoteCustomFieldValue;
import com.atlassian.jira.rpc.soap.beans.RemoteField;
import com.atlassian.jira.rpc.soap.beans.RemoteFieldValue;
import com.atlassian.jira.rpc.soap.beans.RemoteIssue;
import com.atlassian.jira.rpc.soap.beans.RemoteNamedObject;
import com.atlassian.jira.rpc.soap.beans.RemoteSecurityLevel;
import com.atlassian.jira.rpc.soap.beans.RemoteWorklog;
import com.atlassian.jira.rpc.soap.service.IssueService;
import com.atlassian.jira.rpc.soap.service.RemoteWorklogImpl;
import com.atlassian.jira.rpc.soap.util.PluginSoapAttachmentHelper;
import com.atlassian.jira.rpc.soap.util.SoapUtils;
import com.atlassian.jira.rpc.soap.util.SoapUtilsBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.preferences.JiraUserPreferences;
import com.atlassian.jira.util.BuildUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.atlassian.jira.workflow.WorkflowTransitionUtilImpl;
import com.opensymphony.user.User;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class IssueServiceImpl
implements IssueService {
    private PermissionManager permissionManager;
    private ProjectManager projectManager;
    private IssueManager issueManager;
    private AttachmentManager attachmentManager;
    private LocaleUtils localeUtils;
    private ApplicationProperties applicationProperties;
    private final IssueFactory issueFactory;
    private final CommentService commentService;
    private final ProjectRoleService projectRoleService;
    private final IssueUpdater issueUpdater;
    private final AttachmentService attachmentService;
    private final JiraDurationUtils jiraDurationUtils;
    private CustomFieldManager customFieldManager;
    private PluginSoapAttachmentHelper attachmentHelper;
    private IssueDeleteInterface issueDelete;
    private final IssueCreationHelperBean issueCreationHelperBean;
    private final OutlookDateManager outlookDateManager;
    private final IssueUtilsBean issueUtilsBean;
    private final JiraAuthenticationContext authenticationContext;
    private final SoapUtilsBean soapUtilsBean;
    private final ConstantsManager constantsManager;
    private final WorklogService worklogService;
    private static final Category log = Category.getInstance(IssueServiceImpl.class);
    public static final String GENERIC_CONTENT_TYPE = "application/octet-stream";

    public IssueServiceImpl(PermissionManager permissionManager, ProjectManager projectManager, IssueManager issueManager, AttachmentManager attachmentManager, CustomFieldManager customFieldManager, IssueDeleteInterface issueDelete, IssueCreationHelperBean issueCreationHelperBean, OutlookDateManager outlookDateManager, IssueUtilsBean issueUtilsBean, JiraAuthenticationContext authenticationContext, SoapUtilsBean soapUtilsBean, ConstantsManager constantsManager, LocaleUtils localeUtils, ApplicationProperties applicationProperties, IssueFactory issueFactory, CommentService commentService, ProjectRoleService projectRoleService, IssueUpdater issueUpdater, AttachmentService attachmentService, WorklogService worklogService, JiraDurationUtils jiraDurationUtils) {
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.issueManager = issueManager;
        this.attachmentManager = attachmentManager;
        this.customFieldManager = customFieldManager;
        this.localeUtils = localeUtils;
        this.applicationProperties = applicationProperties;
        this.issueFactory = issueFactory;
        this.commentService = commentService;
        this.projectRoleService = projectRoleService;
        this.issueUpdater = issueUpdater;
        this.attachmentService = attachmentService;
        this.jiraDurationUtils = jiraDurationUtils;
        this.attachmentHelper = PluginSoapAttachmentHelper.getInstance();
        this.issueCreationHelperBean = issueCreationHelperBean;
        this.outlookDateManager = outlookDateManager;
        this.issueUtilsBean = issueUtilsBean;
        this.issueDelete = issueDelete;
        this.authenticationContext = authenticationContext;
        this.soapUtilsBean = soapUtilsBean;
        this.constantsManager = constantsManager;
        this.worklogService = worklogService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteIssue getIssue(User user, String issueKey) throws RemoteException, RemotePermissionException {
        User oldUser = this.setRemoteUserInJira(user);
        try {
            RemoteIssue remoteIssue = new RemoteIssue((Issue)this.retrieveIssue(issueKey, user), this.customFieldManager, this.attachmentManager, this.soapUtilsBean);
            return remoteIssue;
        }
        finally {
            this.setRemoteUserInJira(oldUser);
        }
    }

    public RemoteIssue createIssue(User user, RemoteIssue rIssue) throws RemotePermissionException, RemoteValidationException, RemoteException {
        return this.createIssueWithSecurityLevel(user, rIssue, null);
    }

    public RemoteIssue createIssueWithSecurityLevel(User user, RemoteIssue rIssue, Long securityLevelId) throws RemotePermissionException, RemoteValidationException, RemoteException {
        if (securityLevelId != null) {
            if (BuildUtils.isEnterprise()) {
                if (!this.permissionManager.hasPermission(26, this.projectManager.getProjectObjByKey(rIssue.getProject()), user)) {
                    throw new RemotePermissionException("This user does not have the 'set issue security' permission.");
                }
            } else {
                throw new RemotePermissionException("This is Enterprise edition feature only!");
            }
        }
        User oldUser = this.setRemoteUserInJira(user);
        try {
            GenericValue project = this.validateRpcOnlyFields(rIssue, user);
            Map actionParams = this.makeActionParams(project, rIssue, user, securityLevelId);
            MutableIssue issue = this.issueFactory.getIssue();
            issue.setProject(project);
            issue.setIssueTypeId(rIssue.getType());
            HashMap fieldsValueHolder = new HashMap();
            SimpleErrorCollection errors = new SimpleErrorCollection();
            FieldScreenRenderer renderer = this.issueCreationHelperBean.createFieldScreenRenderer(user, (Issue)issue);
            OperationContextImpl operationContext = new OperationContextImpl((IssueOperation)IssueOperations.CREATE_ISSUE_OPERATION, fieldsValueHolder);
            try {
                this.issueCreationHelperBean.validateLicense((ErrorCollection)errors, this.getI18nHelper());
                this.issueCreationHelperBean.validateProject((Issue)issue, (OperationContext)operationContext, actionParams, (ErrorCollection)errors, this.getI18nHelper());
                this.issueCreationHelperBean.validateIssueType((Issue)issue, (OperationContext)operationContext, actionParams, (ErrorCollection)errors, this.getI18nHelper());
                this.issueCreationHelperBean.validateCreateIssueFields((Issue)issue, project, rIssue.getType(), (OperationContext)operationContext, actionParams, user, renderer, (ErrorCollection)errors, this.getI18nHelper());
                this.issueCreationHelperBean.updateFieldValuesHolderWithDefaults((Issue)issue, project, rIssue.getType(), actionParams, operationContext.getFieldValuesHolder(), user, renderer);
            }
            catch (Exception e) {
                throw new RemoteValidationException("Validation failed", e);
            }
            if (errors.hasAnyErrors()) {
                throw new RemoteValidationException(errors.getErrors() + " : " + errors.getErrorMessages().toString());
            }
            this.issueCreationHelperBean.updateIssueFromFieldValuesHolder(renderer, user, project, rIssue.getType(), issue, fieldsValueHolder);
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("issue", issue);
            fields.put("pkey", issue.getProjectObject().getKey());
            GenericValue issueGv = this.issueManager.createIssue(user, fields);
            if (rIssue.getAttachmentNames() != null) {
                this.addAttachmentToIssueFromMimeAttachments(user, rIssue.getAttachmentNames(), issueGv);
            }
            RemoteIssue remoteIssue = new RemoteIssue((Issue)issue, this.customFieldManager, this.attachmentManager, this.soapUtilsBean);
            return remoteIssue;
        }
        catch (DataAccessException e) {
            throw new RemoteException("Error creating issue: " + (Object)((Object)e), e);
        }
        catch (CreateException e) {
            throw new RemoteException("Error creating issue: " + (Object)((Object)e), e);
        }
        finally {
            this.setRemoteUserInJira(oldUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteIssue updateIssue(User user, String issueKey, Map actionParams) throws RemoteException {
        MutableIssue issueObject = this.retrieveIssue(issueKey, user);
        User oldUser = this.setRemoteUserInJira(user);
        try {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            HashMap fieldValuesHolder = new HashMap();
            OperationContextImpl operationContext = new OperationContextImpl((IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION, fieldValuesHolder);
            this.soapUtilsBean.validate((Issue)issueObject, (OperationContext)operationContext, actionParams, user, (ErrorCollection)errors, this.getI18nHelper());
            if (errors.hasAnyErrors()) {
                throw new RemoteValidationException("Fields not valid for issue: \n" + errors);
            }
            this.soapUtilsBean.updateIssue(issueObject, (OperationContext)operationContext, user, (ErrorCollection)errors, this.getI18nHelper());
            RemoteIssue remoteIssue = new RemoteIssue((Issue)issueObject, this.customFieldManager, this.attachmentManager, this.soapUtilsBean);
            return remoteIssue;
        }
        finally {
            this.setRemoteUserInJira(oldUser);
        }
    }

    User setRemoteUserInJira(User user) {
        return this.soapUtilsBean.setRemoteUserInJira(user);
    }

    public RemoteIssue updateIssue(User user, String issueKey, RemoteFieldValue[] actionParams) throws RemoteException {
        return this.updateIssue(user, issueKey, this.soapUtilsBean.mapFieldValueToMap(actionParams));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteField[] getFieldsForEdit(User user, String issueKey) throws RemoteException {
        User oldUser = this.setRemoteUserInJira(user);
        try {
            MutableIssue issueObject = this.retrieveIssue(issueKey, user);
            if (!this.permissionManager.hasPermission(12, (Issue)issueObject, user)) {
                throw new RemotePermissionException("You do not have edit permission for this issue.");
            }
            RemoteField[] remoteFieldArray = this.soapUtilsBean.getFieldsForEdit(user, (Issue)issueObject);
            return remoteFieldArray;
        }
        finally {
            this.setRemoteUserInJira(oldUser);
        }
    }

    private GenericValue validateRpcOnlyFields(RemoteIssue rIssue, User user) throws RemotePermissionException, RemoteValidationException {
        GenericValue project = this.projectManager.getProjectByKey(rIssue.getProject());
        if (project == null || !this.permissionManager.hasPermission(11, project, user)) {
            throw new RemotePermissionException("The project specified does not exist or you don't have permission to create issues in it.");
        }
        if (StringUtils.isNotEmpty((String)rIssue.getId())) {
            throw new RemoteValidationException("You cannot specify an issue ID when creating an issue.");
        }
        if (StringUtils.isNotEmpty((String)rIssue.getKey())) {
            throw new RemoteValidationException("You cannot specify an issue key when creating an issue.");
        }
        if (StringUtils.isEmpty((String)rIssue.getType())) {
            throw new RemoteValidationException("No issue type specified.");
        }
        if (this.constantsManager.getIssueType(rIssue.getType()) == null) {
            throw new RemoteValidationException("Invalid issue type specified: " + rIssue.getType());
        }
        if (StringUtils.isEmpty((String)rIssue.getSummary())) {
            throw new RemoteValidationException("You must specify a summary when creating an issue.");
        }
        return project;
    }

    private Map makeActionParams(GenericValue project, RemoteIssue rIssue, User user, Long securityLevelId) throws RemoteValidationException {
        RemoteCustomFieldValue[] remoteCustomFieldValues;
        HashMap<String, String[]> actionParams = new HashMap<String, String[]>();
        actionParams.put("pid", new String[]{project.getLong("id").toString()});
        actionParams.put("issuetype", new String[]{rIssue.getType()});
        actionParams.put("summary", new String[]{rIssue.getSummary()});
        if (StringUtils.isNotEmpty((String)rIssue.getReporter())) {
            actionParams.put("reporter", new String[]{rIssue.getReporter()});
        } else {
            actionParams.put("reporter", new String[]{user.getName()});
        }
        actionParams.put("assignee", new String[]{rIssue.getAssignee()});
        actionParams.put("description", new String[]{rIssue.getDescription()});
        actionParams.put("environment", new String[]{rIssue.getEnvironment()});
        actionParams.put("status", new String[]{rIssue.getStatus()});
        actionParams.put("priority", new String[]{rIssue.getPriority()});
        actionParams.put("resolution", new String[]{rIssue.getResolution()});
        if (securityLevelId != null) {
            actionParams.put("security", new String[]{securityLevelId.toString()});
        }
        if (this.outlookDateManager != null) {
            JiraUserPreferences userPreferences = new JiraUserPreferences(user);
            String locale = userPreferences.getString("jira.user.locale");
            Locale userLocale = TextUtils.stringSet((String)locale) ? this.localeUtils.getLocale(locale) : this.applicationProperties.getDefaultLocale();
            OutlookDate outlookDate = this.outlookDateManager.getOutlookDate(userLocale);
            if (rIssue.getDuedate() != null) {
                actionParams.put("duedate", new String[]{outlookDate.formatDatePicker(rIssue.getDuedate())});
            }
        }
        if (rIssue.getFixVersions() != null) {
            actionParams.put("fixVersions", SoapUtils.getRemoteEntityIdsAsString(rIssue.getFixVersions()));
        }
        if (rIssue.getAffectsVersions() != null) {
            actionParams.put("versions", SoapUtils.getRemoteEntityIdsAsString(rIssue.getAffectsVersions()));
        }
        if (rIssue.getComponents() != null) {
            actionParams.put("components", SoapUtils.getRemoteEntityIdsAsString(rIssue.getComponents()));
        }
        if ((remoteCustomFieldValues = rIssue.getCustomFieldValues()) != null && remoteCustomFieldValues.length > 0) {
            for (int i = 0; i < remoteCustomFieldValues.length; ++i) {
                RemoteCustomFieldValue remoteCustomFieldValue = remoteCustomFieldValues[i];
                String customfieldId = remoteCustomFieldValue.getCustomfieldId();
                String key = remoteCustomFieldValue.getKey();
                CustomField customField = this.customFieldManager.getCustomFieldObject(customfieldId);
                if (customField == null) {
                    throw new RemoteValidationException("Custom field ID '" + remoteCustomFieldValue.getCustomfieldId() + "' is invalid.");
                }
                String fullCfKey = customfieldId + (StringUtils.isEmpty((String)key) ? "" : ":" + remoteCustomFieldValue.getKey());
                actionParams.put(fullCfKey, remoteCustomFieldValue.getValues());
            }
        }
        return actionParams;
    }

    public void deleteIssue(User user, String issueKey) throws RemoteException, RemotePermissionException {
        GenericValue project = this.projectManager.getProjectByKey(this.getIssue(user, issueKey).getProject());
        if (project == null || !this.permissionManager.hasPermission(16, project, user)) {
            throw new RemotePermissionException("The project specified does not exist or you don't have permission to delete issues in it.");
        }
        try {
            GenericValue issue = this.retrieveIssue(issueKey, user).getGenericValue();
            this.issueDelete.setIssue(issue);
            this.issueDelete.setRemoteUser(user);
            String aResult = this.issueDelete.execute();
            if ("error".equalsIgnoreCase(aResult)) {
                throw new RemoveException("Delete action executed with errors");
            }
        }
        catch (Exception e) {
            throw new RemoteException("Unable to delete issue, cause: " + e.getMessage(), e);
        }
    }

    public RemoteComment[] getComments(User user, String issueKey) throws RemoteException, RemotePermissionException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        MutableIssue issue = this.retrieveIssue(issueKey, user);
        RemoteComment[] comments = SoapUtils.getComments(this.commentService.getCommentsForUser(user, (Issue)issue, (ErrorCollection)errorCollection));
        this.checkAndThrowRemoteException((ErrorCollection)errorCollection);
        return comments;
    }

    public void addComment(User user, String issueKey, RemoteComment remoteComment) throws RemoteException, RemotePermissionException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole projectRole = null;
        String roleLevel = remoteComment.getRoleLevel();
        if (StringUtils.isNotBlank((String)roleLevel) && (projectRole = this.projectRoleService.getProjectRoleByName(user, roleLevel, (ErrorCollection)errorCollection)) == null) {
            throw new RemoteException("Project role: " + roleLevel + " does not exist");
        }
        this.commentService.create(user, (Issue)this.retrieveIssue(issueKey, user), remoteComment.getBody(), remoteComment.getGroupLevel(), projectRole == null ? null : projectRole.getId(), remoteComment.getCreated(), true, (ErrorCollection)errorCollection);
        this.checkAndThrowRemoteException((ErrorCollection)errorCollection);
    }

    public boolean hasPermissionToEditComment(User user, RemoteComment remoteComment) throws RemoteException {
        if (remoteComment == null) {
            throw new RemoteException(this.getI18nHelper().getText("comment.service.error.update.null.comment"));
        }
        if (remoteComment.getId() == null) {
            throw new RemoteException(this.getI18nHelper().getText("comment.service.error.update.null.comment.id"));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Long commentId = remoteComment.getId() == null ? null : new Long(remoteComment.getId());
        MutableComment comment = this.commentService.getMutableComment(user, commentId, (ErrorCollection)errorCollection);
        this.checkAndThrowRemoteException((ErrorCollection)errorCollection);
        boolean hasPermissionToEdit = this.commentService.hasPermissionToEdit(user, (Comment)comment, (ErrorCollection)errorCollection);
        return !errorCollection.hasAnyErrors() && hasPermissionToEdit;
    }

    public RemoteComment editComment(User user, RemoteComment remoteComment) throws RemoteException {
        if (remoteComment == null) {
            throw new RemoteException(this.getI18nHelper().getText("comment.service.error.update.null.comment"));
        }
        if (remoteComment.getId() == null) {
            throw new RemoteException(this.getI18nHelper().getText("comment.service.error.update.null.comment.id"));
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRole projectRole = null;
        String roleLevel = remoteComment.getRoleLevel();
        if (StringUtils.isNotBlank((String)roleLevel) && (projectRole = this.projectRoleService.getProjectRoleByName(user, roleLevel, (ErrorCollection)errorCollection)) == null) {
            throw new RemoteException("Project role: " + roleLevel + " does not exist");
        }
        Long commentId = remoteComment.getId() == null ? null : new Long(remoteComment.getId());
        Long projectRoleId = projectRole == null ? null : projectRole.getId();
        this.commentService.validateCommentUpdate(user, commentId, remoteComment.getBody(), remoteComment.getGroupLevel(), projectRoleId, (ErrorCollection)errorCollection);
        this.checkAndThrowRemoteException((ErrorCollection)errorCollection);
        MutableComment mutableComment = this.commentService.getMutableComment(user, commentId, (ErrorCollection)errorCollection);
        this.checkAndThrowRemoteException((ErrorCollection)errorCollection);
        Issue issue = mutableComment.getIssue();
        if (issue == null) {
            throw new RemoteException("No issue found for comment with id: " + commentId);
        }
        mutableComment.setBody(remoteComment.getBody());
        mutableComment.setGroupLevel(remoteComment.getGroupLevel());
        mutableComment.setRoleLevelId(projectRoleId);
        this.commentService.update(user, mutableComment, true, (ErrorCollection)errorCollection);
        this.checkAndThrowRemoteException((ErrorCollection)errorCollection);
        return new RemoteComment((Comment)mutableComment);
    }

    public RemoteComment getComment(User user, Long commentId) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Comment comment = this.commentService.getCommentById(user, commentId, (ErrorCollection)errorCollection);
        this.checkAndThrowRemoteException((ErrorCollection)errorCollection);
        return new RemoteComment(comment);
    }

    private void checkAndThrowValidationException(ErrorCollection errorCollection) throws RemoteValidationException {
        if (errorCollection.hasAnyErrors()) {
            throw new RemoteValidationException(errorCollection.toString());
        }
    }

    private void checkAndThrowRemoteException(ErrorCollection errorCollection) throws RemoteException {
        if (errorCollection.hasAnyErrors()) {
            throw new RemoteException(errorCollection.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteNamedObject[] getAvailableActions(User user, String issueKey) throws RemoteException {
        this.retrieveIssue(issueKey, user);
        User oldUser = this.setRemoteUserInJira(user);
        try {
            RemoteNamedObject[] actions = null;
            try {
                Map map = this.issueUtilsBean.loadAvailableActions((Issue)this.retrieveIssue(issueKey, user));
                if (map != null && !map.isEmpty()) {
                    actions = new RemoteNamedObject[map.size()];
                    Set entries = map.entrySet();
                    int i = 0;
                    for (Map.Entry entry : entries) {
                        Integer actionId = (Integer)entry.getKey();
                        ActionDescriptor action = (ActionDescriptor)entry.getValue();
                        actions[i] = new RemoteNamedObject(actionId.toString(), action.getName());
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                log.warn((Object)"Error loading available actions", (Throwable)e);
            }
            RemoteNamedObject[] remoteNamedObjectArray = actions;
            return remoteNamedObjectArray;
        }
        finally {
            this.setRemoteUserInJira(oldUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteField[] getFieldsForAction(User user, String issueKey, String actionIdString) throws RemoteException {
        User oldUser = this.setRemoteUserInJira(user);
        try {
            MutableIssue issue = this.retrieveIssue(issueKey, user);
            WorkflowTransitionUtil workflowTransitionUtil = this.getWorkflowTransitionUtil(issue, actionIdString);
            ArrayList<OrderableField> fields = new ArrayList<OrderableField>();
            if (workflowTransitionUtil.hasScreen()) {
                for (FieldScreenRenderTab fieldScreenRenderTab : workflowTransitionUtil.getFieldScreenRenderer().getFieldScreenRenderTabs()) {
                    for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                        if (!fieldScreenRenderLayoutItem.isShow((Issue)issue)) continue;
                        OrderableField field = fieldScreenRenderLayoutItem.getOrderableField();
                        fields.add(field);
                    }
                }
            }
            RemoteField[] remoteFieldArray = this.soapUtilsBean.convertFieldsToRemoteFields(fields);
            return remoteFieldArray;
        }
        finally {
            this.setRemoteUserInJira(oldUser);
        }
    }

    public RemoteIssue progressWorkflowAction(User user, String issueKey, String actionIdString, RemoteFieldValue[] actionParams) throws RemoteException {
        return this.progressWorkflowAction(user, issueKey, actionIdString, this.soapUtilsBean.mapFieldValueToMap(actionParams));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteIssue getIssueById(User user, String issueId) throws RemoteException, RemotePermissionException {
        User oldUser = this.setRemoteUserInJira(user);
        try {
            RemoteIssue remoteIssue = new RemoteIssue((Issue)this.retrieveIssue(new Long(issueId), user), this.customFieldManager, this.attachmentManager, this.soapUtilsBean);
            return remoteIssue;
        }
        finally {
            this.setRemoteUserInJira(oldUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteIssue progressWorkflowAction(User user, String issueKey, String actionIdString, Map actionParams) throws RemoteException {
        User oldUser = this.setRemoteUserInJira(user);
        try {
            ErrorCollection errors;
            MutableIssue issue = this.retrieveIssue(issueKey, user);
            WorkflowTransitionUtil workflowTransitionUtil = this.getWorkflowTransitionUtil(issue, actionIdString);
            HashMap workflowTransitionParams = new HashMap();
            if (workflowTransitionUtil.hasScreen()) {
                if (actionParams == null) {
                    actionParams = Collections.EMPTY_MAP;
                }
                for (FieldScreenRenderTab fieldScreenRenderTab : workflowTransitionUtil.getFieldScreenRenderer().getFieldScreenRenderTabs()) {
                    for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                        if (!fieldScreenRenderLayoutItem.isShow((Issue)issue)) continue;
                        OrderableField orderableField = fieldScreenRenderLayoutItem.getOrderableField();
                        orderableField.populateFromIssue(workflowTransitionParams, (Issue)issue);
                        if (!actionParams.containsKey(orderableField.getId())) continue;
                        orderableField.populateFromParams(workflowTransitionParams, actionParams);
                    }
                }
                workflowTransitionUtil.setParams(workflowTransitionParams);
                errors = workflowTransitionUtil.validate();
                if (errors.hasAnyErrors()) {
                    throw new RemoteValidationException("Fields not valid for workflow action " + workflowTransitionUtil.getActionDescriptor().getName() + ": \n" + errors);
                }
            }
            if ((errors = workflowTransitionUtil.progress()).hasAnyErrors()) {
                throw new RemoteException("Error occurred when running workflow action " + workflowTransitionUtil.getActionDescriptor().getName() + ": \n" + errors);
            }
            RemoteIssue remoteIssue = this.getIssue(user, issueKey);
            return remoteIssue;
        }
        finally {
            this.setRemoteUserInJira(oldUser);
        }
    }

    public boolean addAttachmentsToIssue(User user, String issueKey, String[] fileNames, byte[][] attachments) throws RemoteException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)errorCollection);
        MutableIssue issue = this.retrieveIssue(issueKey, user);
        if (!this.attachmentService.canCreateAttachments((JiraServiceContext)serviceContext, (Issue)issue)) {
            if (errorCollection.hasAnyErrors()) {
                throw new RemoteValidationException("Can not create attachments.", (ErrorCollection)errorCollection);
            }
            throw new RemotePermissionException("You do not have permission to create attachments, or attachments are not enabled in JIRA.");
        }
        if (attachments != null && fileNames != null) {
            if (attachments.length != fileNames.length) {
                throw new RemoteValidationException("Number of attachments (" + attachments.length + ") must match " + "the number of names (" + fileNames.length + ") passed.");
            }
            ArrayList<ChangeItemBean> changeItemBeans = new ArrayList<ChangeItemBean>();
            for (int i = 0; i < attachments.length; ++i) {
                byte[] attachment = attachments[i];
                String fileName = fileNames[i];
                try {
                    File tempFile = this.attachmentHelper.byteArrayToTempFile(attachment);
                    changeItemBeans.add(this.attachmentManager.createAttachment(tempFile, fileName, GENERIC_CONTENT_TYPE, user, issue.getGenericValue()));
                    continue;
                }
                catch (GenericEntityException e) {
                    String errorMsg = "Unable to persist file: " + fileName;
                    log.warn((Object)errorMsg, (Throwable)e);
                    throw new RemoteException(errorMsg, e);
                }
                catch (AttachmentException e) {
                    String errorMsg = "Unable to attach file '" + fileName + "' through the SOAP interface";
                    log.warn((Object)errorMsg, (Throwable)e);
                    throw new RemoteException(errorMsg, e);
                }
            }
            if (!changeItemBeans.isEmpty()) {
                try {
                    IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issue.getGenericValue(), issue.getGenericValue(), EventType.ISSUE_UPDATED_ID, user);
                    issueUpdateBean.setChangeItems(changeItemBeans);
                    issueUpdateBean.setDispatchEvent(true);
                    issueUpdateBean.setParams(EasyMap.build((Object)"eventsource", (Object)"action"));
                    this.issueUpdater.doUpdate(issueUpdateBean, true);
                }
                catch (JiraException e) {
                    log.warn((Object)"Unable to update issues change history for attached file(s)");
                    throw new RemoteException("Unable to add change item for attached file.", e);
                }
            }
        } else {
            throw new RemoteException("Attachments / attachment names not specified");
        }
        return true;
    }

    public RemoteAttachment[] getAttachmentsFromIssue(User user, String issueKey) throws RemoteException {
        MutableIssue issue = this.retrieveIssue(issueKey, user);
        return SoapUtils.getAttachments(this.attachmentManager.getAttachments((Issue)issue));
    }

    private boolean addAttachmentToIssueFromMimeAttachments(User user, String[] fileNames, GenericValue issueToAttach) throws RemoteException, RemotePermissionException {
        try {
            File[] files = this.attachmentHelper.saveFile(fileNames);
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                this.attachmentManager.createAttachment(file, file.getName(), GENERIC_CONTENT_TYPE, user, issueToAttach);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to attach files through the SOAP interface", (Throwable)e);
            throw new RemoteException("Unable to attach files.", e);
        }
        return true;
    }

    private MutableIssue retrieveIssue(String issueKey, User user) throws RemotePermissionException, RemoteException {
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        if (issue == null || !this.permissionManager.hasPermission(10, issue.getGenericValue(), user)) {
            throw new RemotePermissionException("This issue does not exist or you don't have permission to view it.");
        }
        return issue;
    }

    private MutableIssue retrieveIssue(Long issueId, User user) throws RemotePermissionException, RemoteException {
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue == null || !this.permissionManager.hasPermission(10, issue.getGenericValue(), user)) {
            throw new RemotePermissionException("This issue does not exist or you don't have permission to view it.");
        }
        return issue;
    }

    I18nHelper getI18nHelper() {
        return this.authenticationContext.getI18nBean();
    }

    private WorkflowTransitionUtil getWorkflowTransitionUtil(MutableIssue issue, String actionIdString) throws RemoteException {
        try {
            int actionId = Integer.parseInt(actionIdString);
            WorkflowTransitionUtil workflowTransitionUtil = (WorkflowTransitionUtil)JiraUtils.loadComponent(WorkflowTransitionUtilImpl.class);
            workflowTransitionUtil.setIssue(issue);
            workflowTransitionUtil.setAction(actionId);
            workflowTransitionUtil.getActionDescriptor();
            return workflowTransitionUtil;
        }
        catch (NumberFormatException e) {
            throw new RemoteException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RemoteException(e);
        }
    }

    public RemoteWorklog addWorklogWithNewRemainingEstimate(User user, String issueKey, RemoteWorklog remoteWorklog, String newRemainingEstimate) throws RemoteException, RemotePermissionException, RemoteValidationException {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection());
        Issue issue = this.getIssueFromKey(issueKey);
        String timeSpent = remoteWorklog.getTimeSpent();
        Date startDate = remoteWorklog.getStartDate();
        String comment = remoteWorklog.getComment();
        String groupLevel = remoteWorklog.getGroupLevel();
        String roleLevelId = remoteWorklog.getRoleLevelId();
        WorklogService.WorklogNewEstimateResult result = this.worklogService.validateCreateWithNewEstimate((JiraServiceContext)serviceContext, issue, timeSpent, startDate, comment, groupLevel, roleLevelId, newRemainingEstimate);
        this.checkAndThrowValidationException(serviceContext.getErrorCollection());
        if (result == null) {
            throw new RemoteValidationException(this.getI18nHelper().getText("error.unexpected.condition", "WorklogService.validateCreateWithNewEstimate"));
        }
        Worklog createdWorklog = this.worklogService.createWithNewRemainingEstimate((JiraServiceContext)serviceContext, result, true);
        this.checkAndThrowRemoteException(serviceContext.getErrorCollection());
        return RemoteWorklogImpl.copyToRemoteWorkLog(createdWorklog, this.jiraDurationUtils);
    }

    public RemoteWorklog addWorklogAndAutoAdjustRemainingEstimate(User user, String issueKey, RemoteWorklog remoteWorklog) throws RemoteException, RemotePermissionException, RemoteValidationException {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection());
        Issue issue = this.getIssueFromKey(issueKey);
        String timeSpent = remoteWorklog.getTimeSpent();
        Date startDate = remoteWorklog.getStartDate();
        String comment = remoteWorklog.getComment();
        String groupLevel = remoteWorklog.getGroupLevel();
        String roleLevelId = remoteWorklog.getRoleLevelId();
        Worklog worklog = this.worklogService.validateCreate((JiraServiceContext)serviceContext, issue, timeSpent, startDate, comment, groupLevel, roleLevelId);
        this.checkAndThrowValidationException(serviceContext.getErrorCollection());
        if (worklog == null) {
            throw new RemoteValidationException(this.getI18nHelper().getText("error.unexpected.condition", "WorklogService.validateCreate"));
        }
        Worklog createdWorklog = this.worklogService.createAndAutoAdjustRemainingEstimate((JiraServiceContext)serviceContext, worklog, true);
        this.checkAndThrowRemoteException(serviceContext.getErrorCollection());
        return RemoteWorklogImpl.copyToRemoteWorkLog(createdWorklog, this.jiraDurationUtils);
    }

    public RemoteWorklog addWorklogAndRetainRemainingEstimate(User user, String issueKey, RemoteWorklog remoteWorklog) throws RemoteException, RemotePermissionException, RemoteValidationException {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection());
        Issue issue = this.getIssueFromKey(issueKey);
        String timeSpent = remoteWorklog.getTimeSpent();
        Date startDate = remoteWorklog.getStartDate();
        String comment = remoteWorklog.getComment();
        String groupLevel = remoteWorklog.getGroupLevel();
        String roleLevelId = remoteWorklog.getRoleLevelId();
        Worklog worklog = this.worklogService.validateCreate((JiraServiceContext)serviceContext, issue, timeSpent, startDate, comment, groupLevel, roleLevelId);
        this.checkAndThrowValidationException(serviceContext.getErrorCollection());
        if (worklog == null) {
            throw new RemoteValidationException(this.getI18nHelper().getText("error.unexpected.condition", "WorklogService.validateCreate"));
        }
        Worklog createdWorklog = this.worklogService.createAndRetainRemainingEstimate((JiraServiceContext)serviceContext, worklog, true);
        this.checkAndThrowRemoteException(serviceContext.getErrorCollection());
        return RemoteWorklogImpl.copyToRemoteWorkLog(createdWorklog, this.jiraDurationUtils);
    }

    public void deleteWorklogAndAutoAdjustRemainingEstimate(User user, String remoteWorklogId) throws RemoteException, RemotePermissionException, RemoteValidationException {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection());
        Long id = SoapUtils.toLongRequired(remoteWorklogId);
        Worklog worklog = this.worklogService.validateDelete((JiraServiceContext)serviceContext, id);
        this.checkAndThrowValidationException(serviceContext.getErrorCollection());
        if (worklog == null) {
            throw new RemoteValidationException(this.getI18nHelper().getText("error.unexpected.condition", "WorklogService.validateDelete"));
        }
        this.worklogService.deleteAndAutoAdjustRemainingEstimate((JiraServiceContext)serviceContext, worklog, true);
        this.checkAndThrowRemoteException(serviceContext.getErrorCollection());
    }

    public void deleteWorklogAndRetainRemainingEstimate(User user, String remoteWorklogId) throws RemoteException, RemotePermissionException, RemoteValidationException {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection());
        Long id = SoapUtils.toLongRequired(remoteWorklogId);
        Worklog worklog = this.worklogService.validateDelete((JiraServiceContext)serviceContext, id);
        this.checkAndThrowValidationException(serviceContext.getErrorCollection());
        if (worklog == null) {
            throw new RemoteValidationException(this.getI18nHelper().getText("error.unexpected.condition", "WorklogService.validateDelete"));
        }
        this.worklogService.deleteAndRetainRemainingEstimate((JiraServiceContext)serviceContext, worklog, true);
        this.checkAndThrowRemoteException(serviceContext.getErrorCollection());
    }

    public void deleteWorklogWithNewRemainingEstimate(User user, String remoteWorklogId, String newRemainingEstimate) throws RemoteException, RemotePermissionException, RemoteValidationException {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection());
        Long id = SoapUtils.toLongRequired(remoteWorklogId);
        WorklogService.WorklogNewEstimateResult wner = this.worklogService.validateDeleteWithNewEstimate((JiraServiceContext)serviceContext, id, newRemainingEstimate);
        this.checkAndThrowValidationException(serviceContext.getErrorCollection());
        if (wner == null) {
            throw new RemoteValidationException(this.getI18nHelper().getText("error.unexpected.condition", "WorklogService.validateDeleteWithNewEstimate"));
        }
        this.worklogService.deleteWithNewRemainingEstimate((JiraServiceContext)serviceContext, wner, true);
        this.checkAndThrowRemoteException(serviceContext.getErrorCollection());
    }

    public void updateWorklogAndAutoAdjustRemainingEstimate(User user, RemoteWorklog remoteWorklog) throws RemoteException, RemotePermissionException, RemoteValidationException {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection());
        Long id = SoapUtils.toLongRequired(remoteWorklog.getId());
        String timeSpent = remoteWorklog.getTimeSpent();
        Date startDate = remoteWorklog.getStartDate();
        String comment = remoteWorklog.getComment();
        String groupLevel = remoteWorklog.getGroupLevel();
        String roleLevelId = remoteWorklog.getRoleLevelId();
        Worklog worklog = this.worklogService.validateUpdate((JiraServiceContext)serviceContext, id, timeSpent, startDate, comment, groupLevel, roleLevelId);
        this.checkAndThrowValidationException(serviceContext.getErrorCollection());
        if (worklog == null) {
            throw new RemoteValidationException(this.getI18nHelper().getText("error.unexpected.condition", "WorklogService.validateUpdate"));
        }
        this.worklogService.updateAndAutoAdjustRemainingEstimate((JiraServiceContext)serviceContext, worklog, true);
        this.checkAndThrowRemoteException(serviceContext.getErrorCollection());
    }

    public void updateWorklogAndRetainRemainingEstimate(User user, RemoteWorklog remoteWorklog) throws RemoteException, RemotePermissionException, RemoteValidationException {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection());
        Long id = SoapUtils.toLongRequired(remoteWorklog.getId());
        String timeSpent = remoteWorklog.getTimeSpent();
        Date startDate = remoteWorklog.getStartDate();
        String comment = remoteWorklog.getComment();
        String groupLevel = remoteWorklog.getGroupLevel();
        String roleLevelId = remoteWorklog.getRoleLevelId();
        Worklog worklog = this.worklogService.validateUpdate((JiraServiceContext)serviceContext, id, timeSpent, startDate, comment, groupLevel, roleLevelId);
        this.checkAndThrowValidationException(serviceContext.getErrorCollection());
        if (worklog == null) {
            throw new RemoteValidationException(this.getI18nHelper().getText("error.unexpected.condition", "WorklogService.validateUpdate"));
        }
        this.worklogService.updateAndRetainRemainingEstimate((JiraServiceContext)serviceContext, worklog, true);
        this.checkAndThrowRemoteException(serviceContext.getErrorCollection());
    }

    public void updateWorklogWithNewRemainingEstimate(User user, RemoteWorklog remoteWorklog, String newRemainingEstimate) throws RemoteException, RemotePermissionException, RemoteValidationException {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection());
        Long id = SoapUtils.toLongRequired(remoteWorklog.getId());
        String timeSpent = remoteWorklog.getTimeSpent();
        Date startDate = remoteWorklog.getStartDate();
        String comment = remoteWorklog.getComment();
        String groupLevel = remoteWorklog.getGroupLevel();
        String roleLevelId = remoteWorklog.getRoleLevelId();
        WorklogService.WorklogNewEstimateResult wne = this.worklogService.validateUpdateWithNewEstimate((JiraServiceContext)serviceContext, id, timeSpent, startDate, comment, groupLevel, roleLevelId, newRemainingEstimate);
        this.checkAndThrowValidationException(serviceContext.getErrorCollection());
        if (wne == null) {
            throw new RemoteValidationException(this.getI18nHelper().getText("error.unexpected.condition", "WorklogService.validateUpdateWithNewEstimate"));
        }
        this.worklogService.updateWithNewRemainingEstimate((JiraServiceContext)serviceContext, wne, true);
        this.checkAndThrowRemoteException(serviceContext.getErrorCollection());
    }

    public RemoteWorklog[] getWorklogs(User user, String issueKey) throws RemoteException, RemotePermissionException, RemoteValidationException {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection());
        Issue issue = this.getIssueFromKey(issueKey);
        List workLogs = this.worklogService.getByIssueVisibleToUser((JiraServiceContext)serviceContext, issue);
        RemoteWorklog[] remoteWorkLogs = new RemoteWorklog[workLogs.size()];
        int i = 0;
        for (Worklog worklog : workLogs) {
            remoteWorkLogs[i++] = RemoteWorklogImpl.copyToRemoteWorkLog(worklog, this.jiraDurationUtils);
        }
        return remoteWorkLogs;
    }

    public boolean hasPermissionToCreateWorklog(User user, String issueKey) throws RemoteException, RemoteValidationException {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection());
        Issue issue = this.getIssueFromKey(issueKey);
        return this.worklogService.hasPermissionToCreate((JiraServiceContext)serviceContext, issue);
    }

    public boolean hasPermissionToDeleteWorklog(User user, String worklogId) throws RemoteException, RemoteValidationException {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection());
        Long id = SoapUtils.toLongRequired(worklogId);
        Worklog worklog = this.worklogService.getById((JiraServiceContext)serviceContext, id);
        this.checkAndThrowValidationException(serviceContext.getErrorCollection());
        return worklog != null && this.worklogService.hasPermissionToDelete((JiraServiceContext)serviceContext, worklog);
    }

    public boolean hasPermissionToUpdateWorklog(User user, String worklogId) throws RemoteException, RemoteValidationException {
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user, (ErrorCollection)new SimpleErrorCollection());
        Long id = SoapUtils.toLongRequired(worklogId);
        Worklog worklog = this.worklogService.getById((JiraServiceContext)serviceContext, id);
        this.checkAndThrowValidationException(serviceContext.getErrorCollection());
        return worklog != null && this.worklogService.hasPermissionToUpdate((JiraServiceContext)serviceContext, worklog);
    }

    String formatTimeDuration(long timeSpentInSeconds) {
        return this.jiraDurationUtils.getFormattedDuration(new Long(timeSpentInSeconds));
    }

    Issue getIssueFromKey(String issueKey) throws RemoteException {
        MutableIssue issue;
        try {
            issue = this.issueManager.getIssueObject(issueKey);
            if (issue == null) {
                throw new RemoteValidationException(this.getI18nHelper().getText("issue.does.not.exist.desc", issueKey));
            }
        }
        catch (DataAccessException dae) {
            throw new RemoteException(dae);
        }
        catch (RuntimeException rt) {
            throw new RemoteException(rt);
        }
        return issue;
    }

    public RemoteSecurityLevel getSecurityLevel(User user, String issueKey) throws RemoteException, RemotePermissionException {
        if (!BuildUtils.isEnterprise()) {
            throw new RemotePermissionException("This is Enterprise edition feature only!");
        }
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        if (issue == null) {
            throw new RemotePermissionException("This issue does not exist.");
        }
        if (!this.permissionManager.hasPermission(10, issue.getGenericValue(), user)) {
            return null;
        }
        GenericValue securityLevelGV = issue.getSecurityLevel();
        return securityLevelGV == null ? null : new RemoteSecurityLevel(securityLevelGV);
    }

    public Date getResolutionDateByKey(User user, String issueKey) throws RemoteException {
        MutableIssue issue = this.retrieveIssue(issueKey, user);
        return issue.getResolutionDate();
    }

    public Date getResolutionDateById(User user, Long issueId) throws RemoteException {
        MutableIssue issue = this.retrieveIssue(issueId, user);
        return issue.getResolutionDate();
    }
}

