/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.beans;

import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutStorageException;
import com.atlassian.jira.rpc.exception.RemoteException;
import com.atlassian.jira.rpc.soap.beans.AbstractRemoteEntity;
import com.atlassian.jira.rpc.soap.beans.RemoteComponent;
import com.atlassian.jira.rpc.soap.beans.RemoteCustomFieldValue;
import com.atlassian.jira.rpc.soap.beans.RemoteVersion;
import com.atlassian.jira.rpc.soap.util.SoapUtils;
import com.atlassian.jira.rpc.soap.util.SoapUtilsBean;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class RemoteIssue
extends AbstractRemoteEntity {
    private String key;
    private String summary;
    private String reporter;
    private String assignee;
    private String description;
    private String environment;
    private String project;
    private String type;
    private String status;
    private String priority;
    private String resolution;
    private Date created;
    private Date updated;
    private Date duedate;
    private Long votes;
    private RemoteComponent[] components;
    private RemoteVersion[] affectsVersions;
    private RemoteVersion[] fixVersions;
    private RemoteCustomFieldValue[] customFieldValues;
    private String[] attachmentNames;

    public RemoteIssue() {
    }

    public RemoteIssue(Issue issue, CustomFieldManager customFieldManager, AttachmentManager attachmentManager, SoapUtilsBean soapUtils) throws RemoteException {
        super(issue.getId().toString());
        try {
            this.key = issue.getKey();
            this.project = this.key.substring(0, this.key.lastIndexOf("-"));
            if (soapUtils.isVisible(issue, "summary")) {
                this.summary = issue.getSummary();
            }
            if (soapUtils.isVisible(issue, "description")) {
                this.description = issue.getDescription();
            }
            if (soapUtils.isVisible(issue, "environment")) {
                this.environment = issue.getEnvironment();
            }
            if (soapUtils.isVisible(issue, "reporter")) {
                try {
                    this.reporter = issue.getReporter() != null ? issue.getReporter().getName() : null;
                }
                catch (Exception ex) {
                    this.reporter = issue.getReporterId();
                }
            }
            if (soapUtils.isVisible(issue, "assignee")) {
                try {
                    this.assignee = issue.getAssignee() != null ? issue.getAssignee().getName() : null;
                }
                catch (Exception ex) {
                    this.assignee = issue.getAssigneeId();
                }
            }
            this.votes = issue.getVotes();
            if (soapUtils.isVisible(issue, "issuetype")) {
                this.type = this.getId((IssueConstant)issue.getIssueTypeObject());
            }
            this.status = issue.getStatusObject().getId();
            if (soapUtils.isVisible(issue, "priority")) {
                this.priority = this.getId((IssueConstant)issue.getPriorityObject());
            }
            this.resolution = this.getId((IssueConstant)issue.getResolutionObject());
            this.created = issue.getCreated();
            this.updated = issue.getUpdated();
            this.duedate = issue.getDueDate();
            this.affectsVersions = SoapUtils.getVersions(issue.getAffectedVersions());
            this.fixVersions = SoapUtils.getVersions(issue.getFixVersions());
            this.components = SoapUtils.getComponents(issue.getComponents());
            List customFields = customFieldManager.getCustomFieldObjects(issue.getProject().getLong("id"), issue.getIssueTypeObject().getId());
            if (customFields != null) {
                this.customFieldValues = SoapUtils.getCustomFieldValues(customFields, issue);
            }
            List attachments = attachmentManager.getAttachments(issue);
            this.attachmentNames = new String[attachments.size()];
            int i = 0;
            for (Attachment attachment : attachments) {
                this.attachmentNames[i] = attachment.getFilename();
                ++i;
            }
        }
        catch (FieldLayoutStorageException e) {
            throw new RemoteException("Error creating issue: " + (Object)((Object)e), e);
        }
    }

    private String getId(IssueConstant issueConstant) {
        return issueConstant != null ? issueConstant.getId() : null;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getDuedate() {
        return this.duedate;
    }

    public void setDuedate(Date duedate) {
        this.duedate = duedate;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getKey() {
        return this.key;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public Long getVotes() {
        return this.votes;
    }

    public RemoteVersion[] getAffectsVersions() {
        return this.affectsVersions;
    }

    public void setAffectsVersions(RemoteVersion[] affectsVersions) {
        this.affectsVersions = affectsVersions;
    }

    public RemoteComponent[] getComponents() {
        return this.components;
    }

    public void setComponents(RemoteComponent[] components) {
        this.components = components;
    }

    public RemoteVersion[] getFixVersions() {
        return this.fixVersions;
    }

    public void setFixVersions(RemoteVersion[] fixVersions) {
        this.fixVersions = fixVersions;
    }

    public RemoteCustomFieldValue[] getCustomFieldValues() {
        return this.customFieldValues;
    }

    public void setCustomFieldValues(RemoteCustomFieldValue[] customFieldValues) {
        this.customFieldValues = customFieldValues;
    }

    public String[] getAttachmentNames() {
        return this.attachmentNames;
    }

    public void setAttachmentNames(String[] attachmentNames) {
        this.attachmentNames = attachmentNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteIssue)) {
            return false;
        }
        RemoteIssue remoteIssue = (RemoteIssue)o;
        if (!Arrays.equals(this.affectsVersions, remoteIssue.affectsVersions)) {
            return false;
        }
        if (this.assignee != null ? !this.assignee.equals(remoteIssue.assignee) : remoteIssue.assignee != null) {
            return false;
        }
        if (!Arrays.equals(this.components, remoteIssue.components)) {
            return false;
        }
        if (this.created != null ? !this.created.equals(remoteIssue.created) : remoteIssue.created != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(remoteIssue.description) : remoteIssue.description != null) {
            return false;
        }
        if (this.duedate != null ? !this.duedate.equals(remoteIssue.duedate) : remoteIssue.duedate != null) {
            return false;
        }
        if (this.environment != null ? !this.environment.equals(remoteIssue.environment) : remoteIssue.environment != null) {
            return false;
        }
        if (!Arrays.equals(this.fixVersions, remoteIssue.fixVersions)) {
            return false;
        }
        if (!Arrays.equals(this.customFieldValues, remoteIssue.customFieldValues)) {
            return false;
        }
        if (!Arrays.equals(this.attachmentNames, remoteIssue.attachmentNames)) {
            return false;
        }
        if (this.key != null ? !this.key.equals(remoteIssue.key) : remoteIssue.key != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(remoteIssue.priority) : remoteIssue.priority != null) {
            return false;
        }
        if (this.project != null ? !this.project.equals(remoteIssue.project) : remoteIssue.project != null) {
            return false;
        }
        if (this.reporter != null ? !this.reporter.equals(remoteIssue.reporter) : remoteIssue.reporter != null) {
            return false;
        }
        if (this.resolution != null ? !this.resolution.equals(remoteIssue.resolution) : remoteIssue.resolution != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(remoteIssue.status) : remoteIssue.status != null) {
            return false;
        }
        if (this.summary != null ? !this.summary.equals(remoteIssue.summary) : remoteIssue.summary != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(remoteIssue.type) : remoteIssue.type != null) {
            return false;
        }
        if (this.updated != null ? !this.updated.equals(remoteIssue.updated) : remoteIssue.updated != null) {
            return false;
        }
        return !(this.votes != null ? !this.votes.equals(remoteIssue.votes) : remoteIssue.votes != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 29 * result + (this.summary != null ? this.summary.hashCode() : 0);
        result = 29 * result + (this.reporter != null ? this.reporter.hashCode() : 0);
        result = 29 * result + (this.assignee != null ? this.assignee.hashCode() : 0);
        result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 29 * result + (this.environment != null ? this.environment.hashCode() : 0);
        result = 29 * result + (this.project != null ? this.project.hashCode() : 0);
        result = 29 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 29 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 29 * result + (this.priority != null ? this.priority.hashCode() : 0);
        result = 29 * result + (this.resolution != null ? this.resolution.hashCode() : 0);
        result = 29 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 29 * result + (this.updated != null ? this.updated.hashCode() : 0);
        result = 29 * result + (this.duedate != null ? this.duedate.hashCode() : 0);
        result = 29 * result + (this.votes != null ? this.votes.hashCode() : 0);
        return result;
    }
}

