/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap;

import com.atlassian.jira.rpc.auth.TokenManager;
import com.atlassian.jira.rpc.exception.RemoteAuthenticationException;
import com.atlassian.jira.rpc.exception.RemoteException;
import com.atlassian.jira.rpc.exception.RemotePermissionException;
import com.atlassian.jira.rpc.soap.JiraSoapService;
import com.atlassian.jira.rpc.soap.beans.RemoteAttachment;
import com.atlassian.jira.rpc.soap.beans.RemoteAvatar;
import com.atlassian.jira.rpc.soap.beans.RemoteComment;
import com.atlassian.jira.rpc.soap.beans.RemoteComponent;
import com.atlassian.jira.rpc.soap.beans.RemoteConfiguration;
import com.atlassian.jira.rpc.soap.beans.RemoteEntity;
import com.atlassian.jira.rpc.soap.beans.RemoteField;
import com.atlassian.jira.rpc.soap.beans.RemoteFieldValue;
import com.atlassian.jira.rpc.soap.beans.RemoteFilter;
import com.atlassian.jira.rpc.soap.beans.RemoteGroup;
import com.atlassian.jira.rpc.soap.beans.RemoteIssue;
import com.atlassian.jira.rpc.soap.beans.RemoteIssueType;
import com.atlassian.jira.rpc.soap.beans.RemoteNamedObject;
import com.atlassian.jira.rpc.soap.beans.RemotePermission;
import com.atlassian.jira.rpc.soap.beans.RemotePermissionScheme;
import com.atlassian.jira.rpc.soap.beans.RemotePriority;
import com.atlassian.jira.rpc.soap.beans.RemoteProject;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRole;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRoleActors;
import com.atlassian.jira.rpc.soap.beans.RemoteResolution;
import com.atlassian.jira.rpc.soap.beans.RemoteRoleActors;
import com.atlassian.jira.rpc.soap.beans.RemoteScheme;
import com.atlassian.jira.rpc.soap.beans.RemoteSecurityLevel;
import com.atlassian.jira.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.jira.rpc.soap.beans.RemoteStatus;
import com.atlassian.jira.rpc.soap.beans.RemoteUser;
import com.atlassian.jira.rpc.soap.beans.RemoteVersion;
import com.atlassian.jira.rpc.soap.beans.RemoteWorklog;
import com.atlassian.jira.rpc.soap.service.AdminService;
import com.atlassian.jira.rpc.soap.service.IssueConstantsService;
import com.atlassian.jira.rpc.soap.service.IssueService;
import com.atlassian.jira.rpc.soap.service.ProjectRoleService;
import com.atlassian.jira.rpc.soap.service.ProjectService;
import com.atlassian.jira.rpc.soap.service.SchemeService;
import com.atlassian.jira.rpc.soap.service.SearchService;
import com.atlassian.jira.rpc.soap.service.UserService;
import com.atlassian.jira.soap.axis.JiraSoapTokenResolver;
import com.opensymphony.user.User;
import java.util.Date;
import org.apache.axis.encoding.Base64;

public class JiraSoapServiceImpl
implements JiraSoapService,
JiraSoapTokenResolver {
    private TokenManager tokenManager;
    private final ProjectService projectService;
    private final IssueService issueService;
    private final UserService userService;
    private final SchemeService schemeService;
    private final AdminService adminService;
    private final SearchService searchService;
    private final ProjectRoleService projectRoleService;
    private final IssueConstantsService issueConstantsService;

    public JiraSoapServiceImpl(TokenManager tokenManager, ProjectService projectService, IssueService issueService, UserService userService, SchemeService schemeService, AdminService adminService, SearchService searchService, ProjectRoleService projectRoleService, IssueConstantsService issueConstantsService) {
        this.tokenManager = tokenManager;
        this.projectService = projectService;
        this.issueService = issueService;
        this.schemeService = schemeService;
        this.userService = userService;
        this.adminService = adminService;
        this.searchService = searchService;
        this.projectRoleService = projectRoleService;
        this.issueConstantsService = issueConstantsService;
    }

    public void setTokenManager(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public String resolveTokenToUserName(String token) {
        try {
            User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
            return user == null ? null : user.getName();
        }
        catch (RemoteAuthenticationException e) {
            return null;
        }
        catch (RemotePermissionException e) {
            return null;
        }
    }

    public int getTokenParameterIndex(String operationName) {
        if ("login".equals(operationName)) {
            return -1;
        }
        return 0;
    }

    public String login(String username, String password) throws RemoteException {
        return this.tokenManager.login(username, password);
    }

    public boolean logout(String token) {
        return this.tokenManager.logout(token);
    }

    public RemoteServerInfo getServerInfo(String token) {
        return new RemoteServerInfo();
    }

    public RemoteProject[] getProjectsNoSchemes(String token) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.projectService.getProjects(user, false);
    }

    public RemoteProject getProjectById(String token, Long projectId) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.projectService.getProjectById(user, projectId);
    }

    public RemoteProject getProjectWithSchemesById(String token, Long projectId) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.projectService.getProjectWithSchemesById(user, projectId);
    }

    public RemoteProject getProjectByKey(String token, String projectKey) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.projectService.getProjectByKey(user, projectKey);
    }

    public RemoteVersion addVersion(String token, String projectKey, RemoteVersion remoteVersion) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.projectService.createVersion(user, projectKey, remoteVersion);
    }

    public RemoteVersion[] getVersions(String token, String projectKey) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.projectService.getVersions(user, projectKey);
    }

    public RemoteComponent[] getComponents(String token, String projectKey) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.projectService.getComponents(user, projectKey);
    }

    public RemoteIssueType[] getIssueTypesForProject(String token, String projectId) throws RemotePermissionException, RemoteAuthenticationException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueConstantsService.getIssueTypesForProject(user, projectId);
    }

    public RemoteIssueType[] getSubTaskIssueTypesForProject(String token, String projectId) throws RemotePermissionException, RemoteAuthenticationException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueConstantsService.getSubTaskIssueTypesForProject(user, projectId);
    }

    public RemoteIssueType[] getIssueTypes(String token) throws RemotePermissionException, RemoteAuthenticationException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueConstantsService.getIssueTypes(user);
    }

    public RemoteIssueType[] getSubTaskIssueTypes(String token) throws RemotePermissionException, RemoteAuthenticationException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueConstantsService.getSubTaskIssueTypes(user);
    }

    public RemotePriority[] getPriorities(String token) throws RemotePermissionException, RemoteAuthenticationException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueConstantsService.getPriorities(user);
    }

    public RemoteStatus[] getStatuses(String token) throws RemotePermissionException, RemoteAuthenticationException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueConstantsService.getStatuses(user);
    }

    public RemoteResolution[] getResolutions(String token) throws RemotePermissionException, RemoteAuthenticationException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueConstantsService.getResolutions(user);
    }

    public RemoteGroup getGroup(String token, String groupName) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.userService.getGroup(user, groupName);
    }

    public RemoteGroup createGroup(String token, String groupName, RemoteUser firstUser) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.userService.createGroup(user, groupName, firstUser);
    }

    public void addUserToGroup(String token, RemoteGroup group, RemoteUser ruser) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        this.userService.addUserToGroup(user, group, ruser);
    }

    public void removeUserFromGroup(String token, RemoteGroup group, RemoteUser ruser) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        this.userService.removeUserFromGroup(user, group, ruser);
    }

    public RemoteGroup updateGroup(String token, RemoteGroup group) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.userService.updateGroup(user, group);
    }

    public void deleteGroup(String token, String groupName, String swapGroupName) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        this.userService.deleteGroup(user, groupName, swapGroupName);
    }

    public RemoteUser getUser(String token, String username) throws RemotePermissionException, RemoteAuthenticationException {
        this.tokenManager.retrieveUser(token);
        return this.userService.getUser(username);
    }

    public RemoteUser createUser(String token, String username, String password, String fullName, String email) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.userService.createUser(user, username, password, fullName, email);
    }

    public void deleteUser(String token, String username) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        this.userService.deleteUser(user, username);
    }

    public RemoteFilter[] getSavedFilters(String token) throws RemoteException {
        return this.getFavouriteFilters(token);
    }

    public RemoteFilter[] getFavouriteFilters(String token) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.userService.getFavouriteFilters(user);
    }

    public RemoteNamedObject[] getAvailableActions(String token, String issueKey) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.issueService.getAvailableActions(user, issueKey);
    }

    public RemoteField[] getFieldsForAction(String token, String issueKey, String actionIdString) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.issueService.getFieldsForAction(user, issueKey, actionIdString);
    }

    public RemoteIssue progressWorkflowAction(String token, String issueKey, String actionIdString, RemoteFieldValue[] actionParams) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.issueService.progressWorkflowAction(user, issueKey, actionIdString, actionParams);
    }

    public RemoteIssue getIssue(String token, String issueKey) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.issueService.getIssue(user, issueKey);
    }

    public Date getResolutionDateByKey(String token, String issueKey) throws RemotePermissionException, RemoteAuthenticationException, RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.issueService.getResolutionDateByKey(user, issueKey);
    }

    public Date getResolutionDateById(String token, Long issueId) throws RemotePermissionException, RemoteAuthenticationException, RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.issueService.getResolutionDateById(user, issueId);
    }

    public RemoteIssue createIssue(String token, RemoteIssue rIssue) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        try {
            return this.issueService.createIssue(user, rIssue);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public RemoteIssue createIssueWithSecurityLevel(String token, RemoteIssue rIssue, Long securityLevelId) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        try {
            return this.issueService.createIssueWithSecurityLevel(user, rIssue, securityLevelId);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public boolean addAttachmentsToIssue(String token, String issueKey, String[] fileNames, byte[][] attachments) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.issueService.addAttachmentsToIssue(user, issueKey, fileNames, attachments);
    }

    public boolean addBase64EncodedAttachmentsToIssue(String token, String issueKey, String[] fileNames, String[] base64EncodedAttachmentData) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        Object dataBytes = null;
        if (base64EncodedAttachmentData != null) {
            dataBytes = new byte[base64EncodedAttachmentData.length][];
            for (int i = 0; i < base64EncodedAttachmentData.length; ++i) {
                dataBytes[i] = Base64.decode((String)base64EncodedAttachmentData[i]);
            }
        }
        return this.issueService.addAttachmentsToIssue(user, issueKey, fileNames, (byte[][])dataBytes);
    }

    public RemoteAttachment[] getAttachmentsFromIssue(String token, String issueKey) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.issueService.getAttachmentsFromIssue(user, issueKey);
    }

    public RemoteIssue updateIssue(String token, String issueKey, RemoteFieldValue[] actionParams) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.issueService.updateIssue(user, issueKey, actionParams);
    }

    public void deleteIssue(String token, String issueKey) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        this.issueService.deleteIssue(user, issueKey);
    }

    public RemoteField[] getFieldsForEdit(String token, String issueKey) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.issueService.getFieldsForEdit(user, issueKey);
    }

    public RemoteProject createProject(String token, String key, String name, String description, String url, String lead, RemotePermissionScheme permissionScheme, RemoteScheme notificationScheme, RemoteScheme issueSecurityScheme) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.projectService.createProject(user, key, name, description, url, lead, permissionScheme, notificationScheme, issueSecurityScheme);
    }

    public RemoteProject createProjectFromObject(String token, RemoteProject rproject) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.projectService.createProject(user, rproject);
    }

    public RemoteProject updateProject(String token, RemoteProject rProject) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.projectService.updateProject(user, rProject);
    }

    public void deleteProject(String token, String projectKey) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        this.projectService.deleteProject(user, projectKey);
    }

    public RemoteComment getComment(String token, Long id) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.issueService.getComment(user, id);
    }

    public RemoteComment[] getComments(String token, String issueKey) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.issueService.getComments(user, issueKey);
    }

    public void addComment(String token, String issueKey, RemoteComment remoteComment) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        this.issueService.addComment(user, issueKey, remoteComment);
    }

    public boolean hasPermissionToEditComment(String token, RemoteComment remoteComment) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.issueService.hasPermissionToEditComment(user, remoteComment);
    }

    public RemoteComment editComment(String token, RemoteComment remoteComment) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.issueService.editComment(user, remoteComment);
    }

    public RemoteScheme[] getNotificationSchemes(String token) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.schemeService.getNotificationSchemes(user);
    }

    public RemotePermissionScheme[] getPermissionSchemes(String token) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.schemeService.getPermissionSchemes(user);
    }

    public RemoteScheme[] getSecuritySchemes(String token) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.schemeService.getIssueSecuritySchemes(user);
    }

    public RemotePermission[] getAllPermissions(String token) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.schemeService.getAllPermissions(user);
    }

    public RemotePermissionScheme createPermissionScheme(String token, String name, String description) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.schemeService.createPermissionScheme(user, name, description);
    }

    public RemotePermissionScheme addPermissionTo(String token, RemotePermissionScheme permissionScheme, RemotePermission permission, RemoteEntity remoteEntity) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.schemeService.addPermissionTo(user, permissionScheme, permission, remoteEntity);
    }

    public RemotePermissionScheme deletePermissionFrom(String token, RemotePermissionScheme permissionSchemeName, RemotePermission permission, RemoteEntity remoteEntity) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.schemeService.deletePermissionFrom(user, permissionSchemeName, permission, remoteEntity);
    }

    public void deletePermissionScheme(String token, String permissionSchemeName) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        this.schemeService.deletePermissionScheme(user, permissionSchemeName);
    }

    public RemoteField[] getCustomFields(String token) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.adminService.getCustomFields(user);
    }

    public void refreshCustomFields(String token) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        this.adminService.refreshCustomFields(user);
    }

    public RemoteIssue[] getIssuesFromFilter(String token, String filterId) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.searchService.getIssues(user, filterId);
    }

    public RemoteIssue[] getIssuesFromFilterWithLimit(String token, String filterId, int offSet, int maxNumResults) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.searchService.getIssues(user, filterId, offSet, maxNumResults);
    }

    public RemoteIssue[] getIssuesFromTextSearch(String token, String searchTerms) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.searchService.getIssuesFromTextSearch(user, searchTerms);
    }

    public RemoteIssue[] getIssuesFromTextSearchWithLimit(String token, String searchTerms, int offSet, int maxNumResults) throws RemoteException {
        User user = this.tokenManager.retrieveUser(token);
        return this.searchService.getIssuesFromTextSearch(user, searchTerms, offSet, maxNumResults);
    }

    public RemoteIssue[] getIssuesFromTextSearchWithProject(String token, String[] projectKeys, String searchTerms, int maxNumResults) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.searchService.getIssuesFromTextSearchWithProject(user, projectKeys, searchTerms, maxNumResults);
    }

    public RemoteIssue[] getIssuesFromJqlSearch(String token, String jqlSearch, int maxNumResults) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.searchService.getIssuesFromJqlSearch(user, jqlSearch, maxNumResults);
    }

    public long getIssueCountForFilter(String token, String filterId) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.searchService.getIssueCountForFilter(user, filterId);
    }

    public RemoteIssue getIssueById(String token, String issueId) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueService.getIssueById(user, issueId);
    }

    public RemoteConfiguration getConfiguration(String token) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.adminService.getConfiguration(user);
    }

    public RemoteProjectRole[] getProjectRoles(String token) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.projectRoleService.getProjectRoles(user);
    }

    public RemoteProjectRole getProjectRole(String token, Long id) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.projectRoleService.getProjectRole(user, id);
    }

    public RemoteProjectRole createProjectRole(String token, RemoteProjectRole projectRole) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.projectRoleService.createProjectRole(user, projectRole);
    }

    public boolean isProjectRoleNameUnique(String token, String name) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.projectRoleService.isProjectRoleNameUnique(user, name);
    }

    public void deleteProjectRole(String token, RemoteProjectRole projectRole, boolean confirm) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.projectRoleService.deleteProjectRole(user, projectRole, confirm);
    }

    public void addActorsToProjectRole(String token, String[] actors, RemoteProjectRole projectRole, RemoteProject project, String actorType) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.projectRoleService.addActorsToProjectRole(user, actors, projectRole, project, actorType);
    }

    public void removeActorsFromProjectRole(String token, String[] actors, RemoteProjectRole projectRole, RemoteProject project, String actorType) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.projectRoleService.removeActorsFromProjectRole(user, actors, projectRole, project, actorType);
    }

    public void updateProjectRole(String token, RemoteProjectRole projectRole) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.projectRoleService.updateProjectRole(user, projectRole);
    }

    public RemoteProjectRoleActors getProjectRoleActors(String token, RemoteProjectRole projectRole, RemoteProject project) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.projectRoleService.getProjectRoleActors(user, projectRole, project);
    }

    public RemoteRoleActors getDefaultRoleActors(String token, RemoteProjectRole projectRole) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.projectRoleService.getDefaultRoleActors(user, projectRole);
    }

    public void addDefaultActorsToProjectRole(String token, String[] actorNames, RemoteProjectRole projectRole, String type) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.projectRoleService.addDefaultActorsToProjectRole(user, actorNames, projectRole, type);
    }

    public void removeDefaultActorsFromProjectRole(String token, String[] actors, RemoteProjectRole projectRole, String actorType) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.projectRoleService.removeDefaultActorsFromProjectRole(user, actors, projectRole, actorType);
    }

    public void removeAllRoleActorsByNameAndType(String token, String name, String type) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.projectRoleService.removeAllRoleActorsByNameAndType(user, name, type);
    }

    public void removeAllRoleActorsByProject(String token, RemoteProject project) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.projectRoleService.removeAllRoleActorsByProject(user, project);
    }

    public RemoteScheme[] getAssociatedNotificationSchemes(String token, RemoteProjectRole projectRole) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.projectRoleService.getAssociatedNotificationSchemes(user, projectRole);
    }

    public RemoteScheme[] getAssociatedPermissionSchemes(String token, RemoteProjectRole projectRole) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.projectRoleService.getAssociatedPermissionSchemes(user, projectRole);
    }

    public void releaseVersion(String token, String projectKey, RemoteVersion remoteVersion) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.projectService.releaseVersion(user, projectKey, remoteVersion);
    }

    public void archiveVersion(String token, String projectKey, String versionName, boolean archive) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.projectService.archiveVersion(user, projectKey, versionName, archive);
    }

    public RemoteWorklog addWorklogAndAutoAdjustRemainingEstimate(String token, String issueKey, RemoteWorklog remoteWorklog) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueService.addWorklogAndAutoAdjustRemainingEstimate(user, issueKey, remoteWorklog);
    }

    public RemoteWorklog addWorklogAndRetainRemainingEstimate(String token, String issueKey, RemoteWorklog remoteWorklog) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueService.addWorklogAndRetainRemainingEstimate(user, issueKey, remoteWorklog);
    }

    public RemoteWorklog addWorklogWithNewRemainingEstimate(String token, String issueKey, RemoteWorklog remoteWorklog, String newRemainingEstimate) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueService.addWorklogWithNewRemainingEstimate(user, issueKey, remoteWorklog, newRemainingEstimate);
    }

    public RemoteWorklog[] getWorklogs(String token, String issueKey) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueService.getWorklogs(user, issueKey);
    }

    public void deleteWorklogAndAutoAdjustRemainingEstimate(String token, String worklogId) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.issueService.deleteWorklogAndAutoAdjustRemainingEstimate(user, worklogId);
    }

    public void deleteWorklogAndRetainRemainingEstimate(String token, String worklogId) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.issueService.deleteWorklogAndRetainRemainingEstimate(user, worklogId);
    }

    public void deleteWorklogWithNewRemainingEstimate(String token, String worklogId, String newRemainingEstimate) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.issueService.deleteWorklogWithNewRemainingEstimate(user, worklogId, newRemainingEstimate);
    }

    public void updateWorklogAndAutoAdjustRemainingEstimate(String token, RemoteWorklog remoteWorklog) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.issueService.updateWorklogAndAutoAdjustRemainingEstimate(user, remoteWorklog);
    }

    public void updateWorklogAndRetainRemainingEstimate(String token, RemoteWorklog remoteWorklog) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.issueService.updateWorklogAndRetainRemainingEstimate(user, remoteWorklog);
    }

    public void updateWorklogWithNewRemainingEstimate(String token, RemoteWorklog remoteWorklog, String newRemainingEstimate) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.issueService.updateWorklogWithNewRemainingEstimate(user, remoteWorklog, newRemainingEstimate);
    }

    public boolean hasPermissionToCreateWorklog(String token, String issueKey) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueService.hasPermissionToCreateWorklog(user, issueKey);
    }

    public boolean hasPermissionToDeleteWorklog(String token, String worklogId) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueService.hasPermissionToDeleteWorklog(user, worklogId);
    }

    public boolean hasPermissionToUpdateWorklog(String token, String worklogId) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueService.hasPermissionToUpdateWorklog(user, worklogId);
    }

    public RemoteSecurityLevel getSecurityLevel(String token, String issueKey) throws RemoteException, RemotePermissionException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.issueService.getSecurityLevel(user, issueKey);
    }

    public RemoteSecurityLevel[] getSecurityLevels(String token, String projectKey) throws RemoteException, RemotePermissionException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.projectService.getSecurityLevels(user, projectKey);
    }

    public RemoteAvatar[] getProjectAvatars(String token, String projectKey, boolean includeSystemAvatars) throws RemoteException, RemotePermissionException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.projectService.getProjectAvatars(user, projectKey, includeSystemAvatars, "large");
    }

    public void setNewProjectAvatar(String token, String projectKey, String contentType, String base64ImageData) throws RemoteException, RemotePermissionException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.projectService.setProjectAvatar(user, projectKey, contentType, base64ImageData);
    }

    public void setProjectAvatar(String token, String projectKey, Long avatarId) throws RemoteException, RemotePermissionException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.projectService.setProjectAvatar(user, projectKey, avatarId);
    }

    public RemoteAvatar getProjectAvatar(String token, String projectKey) throws RemoteException, RemotePermissionException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        return this.projectService.getProjectAvatar(user, projectKey, "large");
    }

    public void deleteProjectAvatar(String token, long avatarId) throws RemoteException {
        User user = this.tokenManager.retrieveUserNoPermissionCheck(token);
        this.projectService.deleteProjectAvatar(user, avatarId);
    }
}

