/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.auth;

import java.util.HashMap;
import java.util.Map;

public class TokenMap
extends HashMap {
    private long tokenTimeout;
    Map tokenTimeouts;

    public TokenMap(long tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
        this.tokenTimeouts = new HashMap();
    }

    public Object put(Object key, Object value) {
        this.tokenTimeouts.put(key, this.nextExpiryTime());
        return super.put(key, value);
    }

    public Object get(Object key) {
        if (!super.containsKey(key)) {
            return null;
        }
        Long expiryTime = (Long)this.tokenTimeouts.get(key);
        if (expiryTime == null) {
            this.tokenTimeouts.remove(key);
            super.remove(key);
            return null;
        }
        if (expiryTime < System.currentTimeMillis()) {
            this.tokenTimeouts.remove(key);
            super.remove(key);
            return null;
        }
        this.tokenTimeouts.put(key, this.nextExpiryTime());
        return super.get(key);
    }

    private Long nextExpiryTime() {
        return new Long(System.currentTimeMillis() + this.tokenTimeout);
    }

    public Object remove(Object key) {
        this.tokenTimeouts.remove(key);
        return super.remove(key);
    }

    public void clear() {
        this.tokenTimeouts.clear();
        super.clear();
    }

    public Object clone() {
        throw new UnsupportedOperationException("Not written yet.");
    }
}

