/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.auth;

import com.atlassian.core.user.UserUtils;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.RandomGenerator;
import com.atlassian.jira.rpc.auth.TokenManager;
import com.atlassian.jira.rpc.auth.TokenMap;
import com.atlassian.jira.rpc.exception.RemoteAuthenticationException;
import com.atlassian.jira.rpc.exception.RemoteException;
import com.atlassian.jira.rpc.exception.RemotePermissionException;
import com.atlassian.jira.security.PermissionManager;
import com.opensymphony.user.EntityNotFoundException;
import com.opensymphony.user.User;
import com.opensymphony.util.TextUtils;
import java.util.Map;

public class TokenManagerImpl
implements TokenManager {
    public static long DEFAULT_TIMEOUT = 30L * DateUtils.MINUTE_MILLIS;
    final Map tokens;
    private PermissionManager permissionManager;

    public TokenManagerImpl(PermissionManager permissionManager) {
        this(DEFAULT_TIMEOUT, permissionManager);
    }

    public TokenManagerImpl(long timeout, PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
        this.tokens = new TokenMap(timeout);
    }

    public String login(String username, String password) throws RemoteException {
        try {
            boolean authenticated;
            User user = UserUtils.getUser((String)username);
            if (user != null && (authenticated = user.authenticate(password))) {
                return this.createToken(user);
            }
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
        throw new RemoteAuthenticationException("Invalid username or password.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logout(String token) {
        Map map = this.tokens;
        synchronized (map) {
            return this.tokens.remove(token) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createToken(User user) throws RemoteException {
        String token;
        Map map = this.tokens;
        synchronized (map) {
            token = RandomGenerator.randomString((int)10);
            int count = 0;
            while (this.tokens.containsKey(token) && count++ < 10) {
                token = RandomGenerator.randomString((int)10);
            }
            if (count >= 10) {
                throw new RemoteException("Error generating authentication token after 10 attempts?");
            }
            this.tokens.put(token, user);
        }
        return token;
    }

    public User retrieveUser(String token) throws RemoteAuthenticationException, RemotePermissionException {
        User user = (User)this.tokens.get(token);
        if (user == null) {
            throw new RemoteAuthenticationException("User not authenticated yet, or session timed out.");
        }
        if (!this.permissionManager.hasPermission(1, user)) {
            throw new RemotePermissionException("No permission to perform operation.");
        }
        return user;
    }

    public User retrieveUserNoPermissionCheck(String token) throws RemoteAuthenticationException, RemotePermissionException {
        if (!TextUtils.stringSet((String)token)) {
            return null;
        }
        User user = (User)this.tokens.get(token);
        if (user == null) {
            throw new RemoteAuthenticationException("User not authenticated yet, or session timed out.");
        }
        return user;
    }
}

