/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldTypeReader;
import org.ofbiz.core.entity.model.ModelIndex;
import org.ofbiz.core.entity.model.ModelKeyMap;
import org.ofbiz.core.entity.model.ModelReader;
import org.ofbiz.core.entity.model.ModelRelation;
import org.ofbiz.core.entity.model.ModelUtil;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilTimer;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ModelEntity
implements Comparable {
    public static final String module = ModelEntity.class.getName();
    public static final String STAMP_FIELD = "lastUpdatedStamp";
    protected ModelReader modelReader = null;
    protected String entityName = "";
    protected String tableName = "";
    protected String packageName = "";
    protected String dependentOn = "";
    protected String title = "";
    protected String description = "";
    protected String copyright = "";
    protected String author = "";
    protected String version = "";
    protected List fields = new ArrayList();
    protected Map fieldsMap = new HashMap();
    protected List pks = new ArrayList();
    protected List nopks = new ArrayList();
    protected List relations = new ArrayList();
    protected List indexes = new ArrayList();
    protected boolean doLock = false;
    protected boolean neverCache = false;

    public ModelEntity() {
    }

    public ModelEntity(ModelReader reader, Element entityElement, Element docElement, UtilTimer utilTimer, Hashtable docElementValues) {
        ModelField field;
        this.modelReader = reader;
        if (utilTimer != null) {
            utilTimer.timerString("  createModelEntity: before general/basic info");
        }
        this.populateBasicInfo(entityElement, docElement, docElementValues);
        if (utilTimer != null) {
            utilTimer.timerString("  createModelEntity: before fields");
        }
        NodeList fieldList = entityElement.getElementsByTagName("field");
        for (int i = 0; i < fieldList.getLength(); ++i) {
            ModelField field2 = reader.createModelField((Element)fieldList.item(i), docElement, docElementValues);
            if (field2 == null) continue;
            this.fields.add(field2);
            this.fieldsMap.put(field2.name, field2);
        }
        if (utilTimer != null) {
            utilTimer.timerString("  createModelEntity: before prim-keys");
        }
        NodeList pkList = entityElement.getElementsByTagName("prim-key");
        for (int i = 0; i < pkList.getLength(); ++i) {
            field = reader.findModelField(this, ((Element)pkList.item(i)).getAttribute("field"));
            if (field != null) {
                this.pks.add(field);
                field.isPk = true;
                continue;
            }
            Debug.logError((String)("[ModelReader.createModelEntity] ERROR: Could not find field \"" + ((Element)pkList.item(i)).getAttribute("field") + "\" specified in a prim-key"), (String)module);
        }
        this.nopks = new ArrayList();
        for (int ind = 0; ind < this.fields.size(); ++ind) {
            field = (ModelField)this.fields.get(ind);
            if (field.isPk) continue;
            this.nopks.add(field);
        }
        if (utilTimer != null) {
            utilTimer.timerString("  createModelEntity: before relations");
        }
        this.populateRelated(reader, entityElement);
        this.populateIndexes(entityElement);
    }

    public ModelEntity(String tableName, List colList, ModelFieldTypeReader modelFieldTypeReader) {
        this.tableName = tableName.toUpperCase();
        this.entityName = ModelUtil.dbNameToClassName(this.tableName);
        for (DatabaseUtil.ColumnCheckInfo ccInfo : colList) {
            ModelField newField = new ModelField(ccInfo, modelFieldTypeReader);
            this.fields.add(newField);
            this.fieldsMap.put(newField.name, newField);
        }
        this.updatePkLists();
    }

    protected void populateBasicInfo(Element entityElement, Element docElement, Hashtable docElementValues) {
        this.entityName = UtilXml.checkEmpty((String)entityElement.getAttribute("entity-name"));
        this.tableName = UtilXml.checkEmpty((String)entityElement.getAttribute("table-name"), (String)ModelUtil.javaNameToDbName(this.entityName));
        this.packageName = UtilXml.checkEmpty((String)entityElement.getAttribute("package-name"));
        this.dependentOn = UtilXml.checkEmpty((String)entityElement.getAttribute("dependent-on"));
        this.doLock = UtilXml.checkBoolean((String)entityElement.getAttribute("enable-lock"), (boolean)false);
        this.neverCache = UtilXml.checkBoolean((String)entityElement.getAttribute("never-cache"), (boolean)false);
        if (docElementValues == null) {
            this.title = UtilXml.checkEmpty((String)entityElement.getAttribute("title"), (String)UtilXml.childElementValue((Element)docElement, (String)"title"), (String)"None");
            this.description = UtilXml.checkEmpty((String)UtilXml.childElementValue((Element)entityElement, (String)"description"), (String)UtilXml.childElementValue((Element)docElement, (String)"description"), (String)"None");
            this.copyright = UtilXml.checkEmpty((String)entityElement.getAttribute("copyright"), (String)UtilXml.childElementValue((Element)docElement, (String)"copyright"), (String)"Copyright (c) 2001 The Open For Business Project - www.ofbiz.org");
            this.author = UtilXml.checkEmpty((String)entityElement.getAttribute("author"), (String)UtilXml.childElementValue((Element)docElement, (String)"author"), (String)"None");
            this.version = UtilXml.checkEmpty((String)entityElement.getAttribute("version"), (String)UtilXml.childElementValue((Element)docElement, (String)"version"), (String)"1.0");
        } else {
            if (!docElementValues.containsKey("title")) {
                docElementValues.put("title", UtilXml.childElementValue((Element)docElement, (String)"title"));
            }
            if (!docElementValues.containsKey("description")) {
                docElementValues.put("description", UtilXml.childElementValue((Element)docElement, (String)"description"));
            }
            if (!docElementValues.containsKey("copyright")) {
                docElementValues.put("copyright", UtilXml.childElementValue((Element)docElement, (String)"copyright"));
            }
            if (!docElementValues.containsKey("author")) {
                docElementValues.put("author", UtilXml.childElementValue((Element)docElement, (String)"author"));
            }
            if (!docElementValues.containsKey("version")) {
                docElementValues.put("version", UtilXml.childElementValue((Element)docElement, (String)"version"));
            }
            this.title = UtilXml.checkEmpty((String)entityElement.getAttribute("title"), (String)((String)docElementValues.get("title")), (String)"None");
            this.description = UtilXml.checkEmpty((String)UtilXml.childElementValue((Element)entityElement, (String)"description"), (String)((String)docElementValues.get("description")), (String)"None");
            this.copyright = UtilXml.checkEmpty((String)entityElement.getAttribute("copyright"), (String)((String)docElementValues.get("copyright")), (String)"Copyright (c) 2001 The Open For Business Project - www.ofbiz.org");
            this.author = UtilXml.checkEmpty((String)entityElement.getAttribute("author"), (String)((String)docElementValues.get("author")), (String)"None");
            this.version = UtilXml.checkEmpty((String)entityElement.getAttribute("version"), (String)((String)docElementValues.get("version")), (String)"1.0");
        }
    }

    protected void populateRelated(ModelReader reader, Element entityElement) {
        NodeList relationList = entityElement.getElementsByTagName("relation");
        for (int i = 0; i < relationList.getLength(); ++i) {
            ModelRelation relation;
            Element relationElement = (Element)relationList.item(i);
            if (relationElement.getParentNode() != entityElement || (relation = reader.createRelation(this, relationElement)) == null) continue;
            this.relations.add(relation);
        }
    }

    protected void populateIndexes(Element entityElement) {
        NodeList indexList = entityElement.getElementsByTagName("index");
        for (int i = 0; i < indexList.getLength(); ++i) {
            Element indexElement = (Element)indexList.item(i);
            if (indexElement.getParentNode() != entityElement) continue;
            ModelIndex index = new ModelIndex(this, indexElement);
            this.indexes.add(index);
        }
    }

    public ModelReader getModelReader() {
        return this.modelReader;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getPlainTableName() {
        return this.tableName;
    }

    public String getTableName(String helperName) {
        return this.getTableName(EntityConfigUtil.getDatasourceInfo(helperName));
    }

    public String getTableName(EntityConfigUtil.DatasourceInfo datasourceInfo) {
        if (datasourceInfo != null && datasourceInfo.getSchemaName() != null && datasourceInfo.getSchemaName().length() > 0) {
            return datasourceInfo.getSchemaName() + "." + this.tableName;
        }
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getDependentOn() {
        return this.dependentOn;
    }

    public void setDependentOn(String dependentOn) {
        this.dependentOn = dependentOn;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean getNeverCache() {
        return this.neverCache;
    }

    public void setNeverCache(boolean neverCache) {
        this.neverCache = neverCache;
    }

    public boolean getDoLock() {
        return this.doLock;
    }

    public void setDoLock(boolean doLock) {
        this.doLock = doLock;
    }

    public boolean lock() {
        if (this.doLock && this.isField(STAMP_FIELD)) {
            return true;
        }
        this.doLock = false;
        return false;
    }

    public void updatePkLists() {
        this.pks = new ArrayList();
        this.nopks = new ArrayList();
        for (int i = 0; i < this.fields.size(); ++i) {
            ModelField field = (ModelField)this.fields.get(i);
            if (field.isPk) {
                this.pks.add(field);
                continue;
            }
            this.nopks.add(field);
        }
    }

    public boolean isField(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            ModelField field = (ModelField)this.fields.get(i);
            if (!field.name.equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public boolean areFields(Collection fieldNames) {
        if (fieldNames == null) {
            return false;
        }
        for (String fieldName : fieldNames) {
            if (this.isField(fieldName)) continue;
            return false;
        }
        return true;
    }

    public int getPksSize() {
        return this.pks.size();
    }

    public ModelField getPk(int index) {
        return (ModelField)this.pks.get(index);
    }

    public Iterator getPksIterator() {
        return this.pks.iterator();
    }

    public List getPksCopy() {
        return new ArrayList(this.pks);
    }

    public int getNopksSize() {
        return this.nopks.size();
    }

    public ModelField getNopk(int index) {
        return (ModelField)this.nopks.get(index);
    }

    public Iterator getNopksIterator() {
        return this.nopks.iterator();
    }

    public List getNopksCopy() {
        return new ArrayList(this.nopks);
    }

    public int getFieldsSize() {
        return this.fields.size();
    }

    public ModelField getField(int index) {
        return (ModelField)this.fields.get(index);
    }

    public Iterator getFieldsIterator() {
        return this.fields.iterator();
    }

    public List getFieldsCopy() {
        return new ArrayList(this.fields);
    }

    public ModelField getField(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        if (this.fieldsMap == null) {
            this.fieldsMap = new HashMap(this.fields.size());
            for (int i = 0; i < this.fields.size(); ++i) {
                ModelField field = (ModelField)this.fields.get(i);
                this.fieldsMap.put(field.name, field);
            }
        }
        return (ModelField)this.fieldsMap.get(fieldName);
    }

    public void addField(ModelField field) {
        if (field == null) {
            return;
        }
        this.fields.add(field);
        this.fieldsMap.put(field.name, field);
        if (field.isPk) {
            this.pks.add(field);
        } else {
            this.nopks.add(field);
        }
    }

    public ModelField removeField(int index) {
        ModelField field = null;
        field = (ModelField)this.fields.remove(index);
        if (field == null) {
            return null;
        }
        this.fieldsMap.remove(field.name);
        if (field.isPk) {
            this.pks.remove(field);
        } else {
            this.nopks.remove(field);
        }
        return field;
    }

    public ModelField removeField(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        ModelField field = null;
        for (int i = 0; i < this.fields.size(); ++i) {
            field = (ModelField)this.fields.get(i);
            if (field.name.equals(fieldName)) {
                this.fields.remove(i);
                this.fieldsMap.remove(field.name);
                if (field.isPk) {
                    this.pks.remove(field);
                } else {
                    this.nopks.remove(field);
                }
            }
            field = null;
        }
        return field;
    }

    public List getAllFieldNames() {
        return this.getFieldNamesFromFieldVector(this.fields);
    }

    public List getPkFieldNames() {
        return this.getFieldNamesFromFieldVector(this.pks);
    }

    public List getNoPkFieldNames() {
        return this.getFieldNamesFromFieldVector(this.nopks);
    }

    public List getFieldNamesFromFieldVector(List modelFields) {
        ArrayList<String> nameList = new ArrayList<String>(modelFields.size());
        if (modelFields == null || modelFields.size() <= 0) {
            return nameList;
        }
        for (int i = 0; i < modelFields.size(); ++i) {
            ModelField field = (ModelField)modelFields.get(i);
            nameList.add(field.name);
        }
        return nameList;
    }

    public int getRelationsSize() {
        return this.relations.size();
    }

    public ModelRelation getRelation(int index) {
        return (ModelRelation)this.relations.get(index);
    }

    public Iterator getRelationsIterator() {
        return this.relations.iterator();
    }

    public ModelRelation getRelation(String relationName) {
        if (relationName == null) {
            return null;
        }
        for (int i = 0; i < this.relations.size(); ++i) {
            ModelRelation relation = (ModelRelation)this.relations.get(i);
            if (!relationName.equals(relation.title + relation.relEntityName)) continue;
            return relation;
        }
        return null;
    }

    public void addRelation(ModelRelation relation) {
        this.relations.add(relation);
    }

    public ModelRelation removeRelation(int index) {
        return (ModelRelation)this.relations.remove(index);
    }

    public int getIndexesSize() {
        return this.indexes.size();
    }

    public ModelIndex getIndex(int index) {
        return (ModelIndex)this.indexes.get(index);
    }

    public Iterator getIndexesIterator() {
        return this.indexes.iterator();
    }

    public ModelIndex getIndex(String indexName) {
        if (indexName == null) {
            return null;
        }
        for (int i = 0; i < this.indexes.size(); ++i) {
            ModelIndex index = (ModelIndex)this.indexes.get(i);
            if (!indexName.equals(index.getName())) continue;
            return index;
        }
        return null;
    }

    public void addIndex(ModelIndex index) {
        this.indexes.add(index);
    }

    public ModelIndex removeIndex(int index) {
        return (ModelIndex)this.indexes.remove(index);
    }

    public String nameString(List flds) {
        return this.nameString(flds, ", ", "");
    }

    public String nameString(List flds, String separator, String afterLast) {
        int i;
        StringBuffer returnString = new StringBuffer();
        if (flds.size() < 1) {
            return "";
        }
        for (i = 0; i < flds.size() - 1; ++i) {
            returnString.append(((ModelField)flds.get((int)i)).name);
            returnString.append(separator);
        }
        returnString.append(((ModelField)flds.get((int)i)).name);
        returnString.append(afterLast);
        return returnString.toString();
    }

    public String typeNameString(List flds) {
        ModelField curField;
        int i;
        StringBuffer returnString = new StringBuffer();
        if (flds.size() < 1) {
            return "";
        }
        for (i = 0; i < flds.size() - 1; ++i) {
            curField = (ModelField)flds.get(i);
            returnString.append(curField.type);
            returnString.append(" ");
            returnString.append(curField.name);
            returnString.append(", ");
        }
        curField = (ModelField)flds.get(i);
        returnString.append(curField.type);
        returnString.append(" ");
        returnString.append(curField.name);
        return returnString.toString();
    }

    public String fieldNameString() {
        return this.fieldNameString(", ", "");
    }

    public String fieldNameString(String separator, String afterLast) {
        return this.nameString(this.fields, separator, afterLast);
    }

    public String fieldTypeNameString() {
        return this.typeNameString(this.fields);
    }

    public String primKeyClassNameString() {
        return this.typeNameString(this.pks);
    }

    public String pkNameString() {
        return this.pkNameString(", ", "");
    }

    public String pkNameString(String separator, String afterLast) {
        return this.nameString(this.pks, separator, afterLast);
    }

    public String nonPkNullList() {
        return this.fieldsStringList(this.fields, "null", ", ", false, true);
    }

    public String fieldsStringList(List flds, String eachString, String separator) {
        return this.fieldsStringList(flds, eachString, separator, false, false);
    }

    public String fieldsStringList(List flds, String eachString, String separator, boolean appendIndex) {
        return this.fieldsStringList(flds, eachString, separator, appendIndex, false);
    }

    public String fieldsStringList(List flds, String eachString, String separator, boolean appendIndex, boolean onlyNonPK) {
        StringBuffer returnString = new StringBuffer();
        if (flds.size() < 1) {
            return "";
        }
        for (int i = 0; i < flds.size(); ++i) {
            if (onlyNonPK && ((ModelField)flds.get((int)i)).isPk) continue;
            returnString.append(eachString);
            if (appendIndex) {
                returnString.append(i + 1);
            }
            if (i >= flds.size() - 1) continue;
            returnString.append(separator);
        }
        return returnString.toString();
    }

    public String colNameString(List flds) {
        return this.colNameString(flds, ", ", "");
    }

    public String colNameString(List flds, String separator, String afterLast) {
        int i;
        StringBuffer returnString = new StringBuffer();
        if (flds.size() < 1) {
            return "";
        }
        for (i = 0; i < flds.size() - 1; ++i) {
            returnString.append(((ModelField)flds.get((int)i)).colName);
            returnString.append(separator);
        }
        returnString.append(((ModelField)flds.get((int)i)).colName);
        returnString.append(afterLast);
        return returnString.toString();
    }

    public String classNameString(List flds) {
        return this.classNameString(flds, ", ", "");
    }

    public String classNameString(List flds, String separator, String afterLast) {
        int i;
        StringBuffer returnString = new StringBuffer();
        if (flds.size() < 1) {
            return "";
        }
        for (i = 0; i < flds.size() - 1; ++i) {
            returnString.append(ModelUtil.upperFirstChar(((ModelField)flds.get((int)i)).name));
            returnString.append(separator);
        }
        returnString.append(ModelUtil.upperFirstChar(((ModelField)flds.get((int)i)).name));
        returnString.append(afterLast);
        return returnString.toString();
    }

    public String finderQueryString(List flds) {
        int i;
        StringBuffer returnString = new StringBuffer();
        if (flds.size() < 1) {
            return "";
        }
        for (i = 0; i < flds.size() - 1; ++i) {
            returnString.append(((ModelField)flds.get((int)i)).colName);
            returnString.append(" like {");
            returnString.append(i);
            returnString.append("} AND ");
        }
        returnString.append(((ModelField)flds.get((int)i)).colName);
        returnString.append(" like {");
        returnString.append(i);
        returnString.append("}");
        return returnString.toString();
    }

    public String httpArgList(List flds) {
        int i;
        StringBuffer returnString = new StringBuffer();
        if (flds.size() < 1) {
            return "";
        }
        for (i = 0; i < flds.size() - 1; ++i) {
            returnString.append("\"");
            returnString.append(this.tableName);
            returnString.append("_");
            returnString.append(((ModelField)flds.get((int)i)).colName);
            returnString.append("=\" + ");
            returnString.append(((ModelField)flds.get((int)i)).name);
            returnString.append(" + \"&\" + ");
        }
        returnString.append("\"");
        returnString.append(this.tableName);
        returnString.append("_");
        returnString.append(((ModelField)flds.get((int)i)).colName);
        returnString.append("=\" + ");
        returnString.append(((ModelField)flds.get((int)i)).name);
        return returnString.toString();
    }

    public String httpArgListFromClass(List flds) {
        int i;
        StringBuffer returnString = new StringBuffer();
        if (flds.size() < 1) {
            return "";
        }
        for (i = 0; i < flds.size() - 1; ++i) {
            returnString.append("\"");
            returnString.append(this.tableName);
            returnString.append("_");
            returnString.append(((ModelField)flds.get((int)i)).colName);
            returnString.append("=\" + ");
            returnString.append(ModelUtil.lowerFirstChar(this.entityName));
            returnString.append(".get");
            returnString.append(ModelUtil.upperFirstChar(((ModelField)flds.get((int)i)).name));
            returnString.append("() + \"&\" + ");
        }
        returnString.append("\"");
        returnString.append(this.tableName);
        returnString.append("_");
        returnString.append(((ModelField)flds.get((int)i)).colName);
        returnString.append("=\" + ");
        returnString.append(ModelUtil.lowerFirstChar(this.entityName));
        returnString.append(".get");
        returnString.append(ModelUtil.upperFirstChar(((ModelField)flds.get((int)i)).name));
        returnString.append("()");
        return returnString.toString();
    }

    public String httpArgListFromClass(List flds, String entityNameSuffix) {
        int i;
        StringBuffer returnString = new StringBuffer();
        if (flds.size() < 1) {
            return "";
        }
        for (i = 0; i < flds.size() - 1; ++i) {
            returnString.append("\"");
            returnString.append(this.tableName);
            returnString.append("_");
            returnString.append(((ModelField)flds.get((int)i)).colName);
            returnString.append("=\" + ");
            returnString.append(ModelUtil.lowerFirstChar(this.entityName));
            returnString.append(entityNameSuffix);
            returnString.append(".get");
            returnString.append(ModelUtil.upperFirstChar(((ModelField)flds.get((int)i)).name));
            returnString.append("() + \"&\" + ");
        }
        returnString.append("\"");
        returnString.append(this.tableName);
        returnString.append("_");
        returnString.append(((ModelField)flds.get((int)i)).colName);
        returnString.append("=\" + ");
        returnString.append(ModelUtil.lowerFirstChar(this.entityName));
        returnString.append(entityNameSuffix);
        returnString.append(".get");
        returnString.append(ModelUtil.upperFirstChar(((ModelField)flds.get((int)i)).name));
        returnString.append("()");
        return returnString.toString();
    }

    public String httpRelationArgList(List flds, ModelRelation relation) {
        ModelKeyMap keyMap;
        int i;
        StringBuffer returnString = new StringBuffer();
        if (flds.size() < 1) {
            return "";
        }
        for (i = 0; i < flds.size() - 1; ++i) {
            keyMap = relation.findKeyMapByRelated(((ModelField)flds.get((int)i)).name);
            if (keyMap != null) {
                returnString.append("\"");
                returnString.append(this.tableName);
                returnString.append("_");
                returnString.append(((ModelField)flds.get((int)i)).colName);
                returnString.append("=\" + ");
                returnString.append(ModelUtil.lowerFirstChar(relation.mainEntity.entityName));
                returnString.append(".get");
                returnString.append(ModelUtil.upperFirstChar(keyMap.fieldName));
                returnString.append("() + \"&\" + ");
                continue;
            }
            Debug.logWarning((String)("-- -- ENTITYGEN ERROR:httpRelationArgList: Related Key in Key Map not found for name: " + ((ModelField)flds.get((int)i)).name + " related entity: " + relation.relEntityName + " main entity: " + relation.mainEntity.entityName + " type: " + relation.type));
        }
        keyMap = relation.findKeyMapByRelated(((ModelField)flds.get((int)i)).name);
        if (keyMap != null) {
            returnString.append("\"");
            returnString.append(this.tableName);
            returnString.append("_");
            returnString.append(((ModelField)flds.get((int)i)).colName);
            returnString.append("=\" + ");
            returnString.append(ModelUtil.lowerFirstChar(relation.mainEntity.entityName));
            returnString.append(".get");
            returnString.append(ModelUtil.upperFirstChar(keyMap.fieldName));
            returnString.append("()");
        } else {
            Debug.logWarning((String)("-- -- ENTITYGEN ERROR:httpRelationArgList: Related Key in Key Map not found for name: " + ((ModelField)flds.get((int)i)).name + " related entity: " + relation.relEntityName + " main entity: " + relation.mainEntity.entityName + " type: " + relation.type));
        }
        return returnString.toString();
    }

    public String typeNameStringRelatedNoMapped(List flds, ModelRelation relation) {
        StringBuffer returnString = new StringBuffer();
        if (flds.size() < 1) {
            return "";
        }
        int i = 0;
        if (relation.findKeyMapByRelated(((ModelField)flds.get((int)i)).name) == null) {
            returnString.append(((ModelField)flds.get((int)i)).type);
            returnString.append(" ");
            returnString.append(((ModelField)flds.get((int)i)).name);
        }
        ++i;
        while (i < flds.size()) {
            if (relation.findKeyMapByRelated(((ModelField)flds.get((int)i)).name) == null) {
                if (returnString.length() > 0) {
                    returnString.append(", ");
                }
                returnString.append(((ModelField)flds.get((int)i)).type);
                returnString.append(" ");
                returnString.append(((ModelField)flds.get((int)i)).name);
            }
            ++i;
        }
        return returnString.toString();
    }

    public String typeNameStringRelatedAndMain(List flds, ModelRelation relation) {
        ModelKeyMap keyMap;
        int i;
        StringBuffer returnString = new StringBuffer();
        if (flds.size() < 1) {
            return "";
        }
        for (i = 0; i < flds.size() - 1; ++i) {
            keyMap = relation.findKeyMapByRelated(((ModelField)flds.get((int)i)).name);
            if (keyMap != null) {
                returnString.append(keyMap.fieldName);
                returnString.append(", ");
                continue;
            }
            returnString.append(((ModelField)flds.get((int)i)).name);
            returnString.append(", ");
        }
        keyMap = relation.findKeyMapByRelated(((ModelField)flds.get((int)i)).name);
        if (keyMap != null) {
            returnString.append(keyMap.fieldName);
        } else {
            returnString.append(((ModelField)flds.get((int)i)).name);
        }
        return returnString.toString();
    }

    public int compareTo(Object obj) {
        ModelEntity otherModelEntity = (ModelEntity)obj;
        return this.getEntityName().compareTo(otherModelEntity.getEntityName());
    }
}

