/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.workflow.spi.hibernate;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.module.propertyset.hibernate.DefaultHibernateConfigurationProvider;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.QueryNotSupportedException;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.query.Expression;
import com.opensymphony.workflow.query.FieldExpression;
import com.opensymphony.workflow.query.NestedExpression;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.query.WorkflowQuery;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import com.opensymphony.workflow.spi.hibernate.HibernateCurrentStep;
import com.opensymphony.workflow.spi.hibernate.HibernateHistoryStep;
import com.opensymphony.workflow.spi.hibernate.HibernateStep;
import com.opensymphony.workflow.spi.hibernate.HibernateWorkflowEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HibernateWorkflowStore
implements WorkflowStore {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowStore == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowStore = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateWorkflowStore")) : class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowStore));
    Session session;
    SessionFactory sessionFactory;
    static /* synthetic */ Class class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowStore;
    static /* synthetic */ Class class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry;
    static /* synthetic */ Class class$com$opensymphony$workflow$spi$hibernate$HibernateCurrentStep;
    static /* synthetic */ Class class$com$opensymphony$workflow$spi$hibernate$HibernateHistoryStep;

    public HibernateWorkflowStore() {
    }

    public HibernateWorkflowStore(SessionFactory sessionFactory) throws StoreException {
        this.sessionFactory = sessionFactory;
        try {
            this.session = sessionFactory.openSession();
        }
        catch (HibernateException he) {
            log.error((Object)"constructor", (Throwable)he);
            throw new StoreException("constructor", he);
        }
    }

    public void setEntryState(long entryId, int state) throws StoreException {
        try {
            HibernateWorkflowEntry entry = (HibernateWorkflowEntry)this.session.find("FROM entry IN CLASS " + (class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateWorkflowEntry")) : class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry).getName() + " WHERE entry.id = ?", (Object)new Long(entryId), (Type)Hibernate.LONG).get(0);
            entry.setState(state);
            this.session.save((Object)entry);
        }
        catch (HibernateException e) {
            log.error((Object)"An exception occured", (Throwable)e);
            return;
        }
    }

    public PropertySet getPropertySet(long entryId) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("entityName", "OSWorkflowEntry");
        args.put("entityId", new Long(entryId));
        DefaultHibernateConfigurationProvider configurationProvider = new DefaultHibernateConfigurationProvider();
        configurationProvider.setSessionFactory(this.sessionFactory);
        args.put("configurationProvider", configurationProvider);
        return PropertySetManager.getInstance((String)"hibernate", args);
    }

    public Step createCurrentStep(long entryId, int stepId, String owner, Date startDate, Date dueDate, String status, long[] previousIds) throws StoreException {
        HibernateWorkflowEntry entry;
        Transaction tx;
        HibernateCurrentStep step = new HibernateCurrentStep();
        try {
            tx = this.session.beginTransaction();
            entry = (HibernateWorkflowEntry)this.session.find("FROM entry in CLASS " + (class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateWorkflowEntry")) : class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry).getName() + " WHERE entry.id = ?", (Object)new Long(entryId), (Type)Hibernate.LONG).get(0);
        }
        catch (HibernateException he) {
            log.error((Object)("Looking for workflow entry " + entryId), (Throwable)he);
            throw new StoreException("Looking for workflow entry " + entryId, he);
        }
        step.setEntry(entry);
        step.setStepId(stepId);
        step.setOwner(owner);
        step.setStartDate(startDate);
        step.setDueDate(dueDate);
        step.setStatus(status);
        ArrayList<Long> stepIdList = new ArrayList<Long>(previousIds.length);
        for (int i = 0; i < previousIds.length; ++i) {
            long previousId = previousIds[i];
            stepIdList.add(new Long(previousId));
        }
        if (!stepIdList.isEmpty()) {
            String stepIds = TextUtils.join((String)", ", stepIdList);
            try {
                step.setPreviousSteps(this.session.find("FROM step in CLASS " + (class$com$opensymphony$workflow$spi$hibernate$HibernateCurrentStep == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateCurrentStep = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateCurrentStep")) : class$com$opensymphony$workflow$spi$hibernate$HibernateCurrentStep).getName() + " WHERE step.id IN (" + stepIds + ")"));
            }
            catch (HibernateException he) {
                log.error((Object)("Looking for step in " + stepIds), (Throwable)he);
                throw new StoreException("Looking for step in " + stepIds, he);
            }
        } else {
            step.setPreviousSteps(Collections.EMPTY_LIST);
        }
        if (entry.getCurrentSteps() == null) {
            ArrayList<HibernateCurrentStep> cSteps = new ArrayList<HibernateCurrentStep>(1);
            cSteps.add(step);
            entry.setCurrentSteps(cSteps);
        } else {
            entry.getCurrentSteps().add(step);
        }
        try {
            this.session.save((Object)entry);
            tx.commit();
            return step;
        }
        catch (HibernateException he) {
            log.error((Object)"Saving new workflow entry", (Throwable)he);
            throw new StoreException("Saving new workflow entry", he);
        }
    }

    public WorkflowEntry createEntry(String workflowName) throws StoreException {
        HibernateWorkflowEntry entry = new HibernateWorkflowEntry();
        entry.setState(0);
        entry.setWorkflowName(workflowName);
        try {
            Transaction tx = this.session.beginTransaction();
            this.session.save((Object)entry);
            tx.commit();
        }
        catch (HibernateException he) {
            log.error((Object)"Saving new workflow entry", (Throwable)he);
            throw new StoreException("Saving new workflow entry", he);
        }
        return entry;
    }

    public List findCurrentSteps(long entryId) throws StoreException {
        HibernateWorkflowEntry entry;
        try {
            entry = (HibernateWorkflowEntry)this.session.find("FROM entry in CLASS " + (class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateWorkflowEntry")) : class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry).getName() + " WHERE entry.id = ?", (Object)new Long(entryId), (Type)Hibernate.LONG).get(0);
        }
        catch (HibernateException he) {
            log.error((Object)("Looking for entryId " + entryId), (Throwable)he);
            throw new StoreException("Looking for entryId " + entryId, he);
        }
        try {
            return this.session.find("FROM step IN CLASS " + (class$com$opensymphony$workflow$spi$hibernate$HibernateCurrentStep == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateCurrentStep = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateCurrentStep")) : class$com$opensymphony$workflow$spi$hibernate$HibernateCurrentStep).getName() + " WHERE step.entry = ?", (Object)entry, Hibernate.entity(entry.getClass()));
        }
        catch (HibernateException he) {
            log.error((Object)("Looking for step id" + entry), (Throwable)he);
            throw new StoreException("Looking for step id" + entry, he);
        }
    }

    public WorkflowEntry findEntry(long entryId) throws StoreException {
        try {
            List result = this.session.find("FROM entry IN CLASS " + (class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateWorkflowEntry")) : class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry).getName() + " WHERE entry.id = ?", (Object)new Long(entryId), (Type)Hibernate.LONG);
            return (WorkflowEntry)result.get(0);
        }
        catch (HibernateException he) {
            log.error((Object)("Looking for entry " + entryId), (Throwable)he);
            throw new StoreException("Loooking for entry " + entryId, he);
        }
    }

    public List findHistorySteps(long entryId) throws StoreException {
        HibernateWorkflowEntry entry;
        try {
            entry = (HibernateWorkflowEntry)this.session.find("FROM entry in CLASS " + (class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateWorkflowEntry")) : class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry).getName() + " WHERE entry.id = ?", (Object)new Long(entryId), (Type)Hibernate.LONG).get(0);
        }
        catch (HibernateException he) {
            log.error((Object)("Finding entry " + entryId), (Throwable)he);
            throw new StoreException("Finding entry " + entryId, he);
        }
        try {
            return this.session.find("FROM step IN CLASS " + (class$com$opensymphony$workflow$spi$hibernate$HibernateHistoryStep == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateHistoryStep = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateHistoryStep")) : class$com$opensymphony$workflow$spi$hibernate$HibernateHistoryStep).getName() + " WHERE step.entry = ?", (Object)entry, Hibernate.entity(entry.getClass()));
        }
        catch (HibernateException he) {
            log.error((Object)("Looking for step with entry " + entry), (Throwable)he);
            throw new StoreException("Looking for step with entry " + entry, he);
        }
    }

    public void init(Map props) throws StoreException {
        try {
            this.sessionFactory = (SessionFactory)props.get("sessionFactory");
            this.session = this.sessionFactory.openSession();
        }
        catch (HibernateException he) {
            log.error((Object)"Setting sessionFactory", (Throwable)he);
            throw new StoreException("Setting sessionFactory", he);
        }
    }

    public Step markFinished(Step step, int actionId, Date finishDate, String status, String caller) throws StoreException {
        HibernateCurrentStep currentStep = (HibernateCurrentStep)step;
        currentStep.setActionId(actionId);
        currentStep.setFinishDate(finishDate);
        currentStep.setStatus(status);
        currentStep.setCaller(caller);
        try {
            Transaction tx = this.session.beginTransaction();
            this.session.save((Object)currentStep);
            tx.commit();
            return currentStep;
        }
        catch (HibernateException he) {
            log.error((Object)("Saving current step with action " + actionId), (Throwable)he);
            throw new StoreException("Saving current step with action " + actionId, he);
        }
    }

    public void moveToHistory(Step step) throws StoreException {
        HibernateWorkflowEntry entry;
        Transaction tx;
        try {
            tx = this.session.beginTransaction();
            entry = (HibernateWorkflowEntry)this.session.find("FROM entry IN CLASS " + (class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateWorkflowEntry")) : class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry).getName() + " WHERE entry.id = ?", (Object)new Long(step.getEntryId()), (Type)Hibernate.LONG).get(0);
        }
        catch (HibernateException he) {
            log.error((Object)("Looking for workflow entry " + step.getEntryId()), (Throwable)he);
            throw new StoreException("Looking for workflow entry " + step.getEntryId(), he);
        }
        HibernateHistoryStep hStep = new HibernateHistoryStep((HibernateStep)step);
        entry.getCurrentSteps().remove(step);
        if (entry.getHistorySteps() == null) {
            ArrayList<HibernateHistoryStep> hSteps = new ArrayList<HibernateHistoryStep>(1);
            hSteps.add(hStep);
            entry.setHistorySteps(hSteps);
        } else {
            entry.getHistorySteps().add(hStep);
        }
        try {
            this.session.save((Object)hStep);
            this.session.save((Object)entry);
            tx.commit();
        }
        catch (HibernateException he) {
            log.error((Object)("Saving workflow entry " + entry.getId()), (Throwable)he);
            throw new StoreException("Saving workflow entry " + entry.getId(), he);
        }
    }

    public List query(WorkflowExpressionQuery query) throws StoreException {
        Expression expression = query.getExpression();
        Class entityClass = this.getQueryClass(expression, null);
        Criterion expr = expression.isNested() ? this.buildNested((NestedExpression)expression) : this.queryComparison((FieldExpression)expression);
        Criteria criteria = this.session.createCriteria(entityClass);
        criteria.add(expr);
        try {
            HashSet<Long> results = new HashSet<Long>();
            Iterator iter = criteria.list().iterator();
            while (iter.hasNext()) {
                Long item;
                Object next = iter.next();
                if (next instanceof HibernateStep) {
                    HibernateStep step = (HibernateStep)next;
                    item = new Long(step.getEntryId());
                } else {
                    WorkflowEntry entry = (WorkflowEntry)next;
                    item = new Long(entry.getId());
                }
                results.add(item);
            }
            return new ArrayList(results);
        }
        catch (HibernateException e) {
            throw new StoreException("Error executing query " + expression, e);
        }
    }

    public List query(WorkflowQuery query) throws StoreException {
        int qtype = query.getType();
        if (qtype == 0 && query.getLeft() != null) {
            qtype = query.getLeft().getType();
        }
        Class entityClass = qtype == 2 ? (class$com$opensymphony$workflow$spi$hibernate$HibernateCurrentStep == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateCurrentStep = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateCurrentStep")) : class$com$opensymphony$workflow$spi$hibernate$HibernateCurrentStep) : (class$com$opensymphony$workflow$spi$hibernate$HibernateHistoryStep == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateHistoryStep = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateHistoryStep")) : class$com$opensymphony$workflow$spi$hibernate$HibernateHistoryStep);
        Criteria criteria = this.session.createCriteria(entityClass);
        Criterion expression = this.buildExpression(query);
        criteria.add(expression);
        try {
            HashSet<Long> results = new HashSet<Long>();
            Iterator iter = criteria.list().iterator();
            while (iter.hasNext()) {
                HibernateStep step = (HibernateStep)iter.next();
                results.add(new Long(step.getEntryId()));
            }
            return new ArrayList(results);
        }
        catch (HibernateException e) {
            throw new StoreException("Error executing query " + expression, e);
        }
    }

    private Criterion getExpression(WorkflowQuery query) {
        int operator = query.getOperator();
        switch (operator) {
            case 1: {
                return net.sf.hibernate.expression.Expression.eq((String)this.getFieldName(query.getField()), (Object)query.getValue());
            }
            case 5: {
                return net.sf.hibernate.expression.Expression.not((Criterion)net.sf.hibernate.expression.Expression.like((String)this.getFieldName(query.getField()), (Object)query.getValue()));
            }
            case 3: {
                return net.sf.hibernate.expression.Expression.gt((String)this.getFieldName(query.getField()), (Object)query.getValue());
            }
            case 2: {
                return net.sf.hibernate.expression.Expression.lt((String)this.getFieldName(query.getField()), (Object)query.getValue());
            }
        }
        return net.sf.hibernate.expression.Expression.eq((String)this.getFieldName(query.getField()), (Object)query.getValue());
    }

    private String getFieldName(int field) {
        switch (field) {
            case 4: {
                return "actionId";
            }
            case 6: {
                return "caller";
            }
            case 3: {
                return "finishDate";
            }
            case 1: {
                return "owner";
            }
            case 2: {
                return "startDate";
            }
            case 5: {
                return "stepId";
            }
            case 7: {
                return "status";
            }
            case 9: {
                return "state";
            }
            case 8: {
                return "workflowName";
            }
            case 10: {
                return "dueDate";
            }
        }
        return "1";
    }

    private Class getQueryClass(Expression expr, Collection classesCache) throws StoreException {
        if (classesCache == null) {
            classesCache = new HashSet<Class>();
        }
        if (expr instanceof FieldExpression) {
            FieldExpression fieldExpression = (FieldExpression)expr;
            switch (fieldExpression.getContext()) {
                case 2: {
                    classesCache.add(class$com$opensymphony$workflow$spi$hibernate$HibernateCurrentStep == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateCurrentStep = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateCurrentStep")) : class$com$opensymphony$workflow$spi$hibernate$HibernateCurrentStep);
                    break;
                }
                case 1: {
                    classesCache.add(class$com$opensymphony$workflow$spi$hibernate$HibernateHistoryStep == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateHistoryStep = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateHistoryStep")) : class$com$opensymphony$workflow$spi$hibernate$HibernateHistoryStep);
                    break;
                }
                case 3: {
                    classesCache.add(class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry == null ? (class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry = HibernateWorkflowStore.class$("com.opensymphony.workflow.spi.hibernate.HibernateWorkflowEntry")) : class$com$opensymphony$workflow$spi$hibernate$HibernateWorkflowEntry);
                    break;
                }
                default: {
                    throw new QueryNotSupportedException("Query for unsupported context " + fieldExpression.getContext());
                }
            }
        } else {
            NestedExpression nestedExpression = (NestedExpression)expr;
            for (int i = 0; i < nestedExpression.getExpressionCount(); ++i) {
                Expression expression = nestedExpression.getExpression(i);
                if (expression.isNested()) {
                    classesCache.add(this.getQueryClass(nestedExpression.getExpression(i), classesCache));
                    continue;
                }
                classesCache.add(this.getQueryClass(expression, classesCache));
            }
        }
        if (classesCache.size() > 1) {
            throw new QueryNotSupportedException("Store does not support nested queries of different types (types found:" + classesCache + ")");
        }
        return (Class)classesCache.iterator().next();
    }

    private Criterion buildExpression(WorkflowQuery query) throws StoreException {
        if (query.getLeft() == null) {
            if (query.getRight() == null) {
                return this.getExpression(query);
            }
            throw new StoreException("Invalid WorkflowQuery object.  QueryLeft is null but QueryRight is not.");
        }
        if (query.getRight() == null) {
            throw new StoreException("Invalid WorkflowQuery object.  QueryLeft is not null but QueryRight is.");
        }
        int operator = query.getOperator();
        WorkflowQuery left = query.getLeft();
        WorkflowQuery right = query.getRight();
        switch (operator) {
            case 6: {
                return net.sf.hibernate.expression.Expression.and((Criterion)this.buildExpression(left), (Criterion)this.buildExpression(right));
            }
            case 7: {
                return net.sf.hibernate.expression.Expression.or((Criterion)this.buildExpression(left), (Criterion)this.buildExpression(right));
            }
            case 8: {
                throw new StoreException("XOR Operator in Queries not supported by " + this.getClass().getName());
            }
        }
        throw new StoreException("Operator '" + operator + "' is not supported by " + this.getClass().getName());
    }

    private Criterion buildNested(NestedExpression nestedExpression) throws StoreException {
        Criterion full = null;
        block4: for (int i = 0; i < nestedExpression.getExpressionCount(); ++i) {
            Criterion expr;
            Expression expression = nestedExpression.getExpression(i);
            if (expression.isNested()) {
                expr = this.buildNested((NestedExpression)nestedExpression.getExpression(i));
            } else {
                FieldExpression sub = (FieldExpression)nestedExpression.getExpression(i);
                expr = this.queryComparison(sub);
                if (sub.isNegate()) {
                    expr = net.sf.hibernate.expression.Expression.not((Criterion)expr);
                }
            }
            if (full == null) {
                full = expr;
                continue;
            }
            switch (nestedExpression.getExpressionOperator()) {
                case 6: {
                    full = net.sf.hibernate.expression.Expression.and((Criterion)full, (Criterion)expr);
                    continue block4;
                }
                case 7: {
                    full = net.sf.hibernate.expression.Expression.or((Criterion)full, (Criterion)expr);
                }
            }
        }
        return full;
    }

    private Criterion queryComparison(FieldExpression expression) {
        int operator = expression.getOperator();
        switch (operator) {
            case 1: {
                return net.sf.hibernate.expression.Expression.eq((String)this.getFieldName(expression.getField()), (Object)expression.getValue());
            }
            case 5: {
                return net.sf.hibernate.expression.Expression.not((Criterion)net.sf.hibernate.expression.Expression.like((String)this.getFieldName(expression.getField()), (Object)expression.getValue()));
            }
            case 3: {
                return net.sf.hibernate.expression.Expression.gt((String)this.getFieldName(expression.getField()), (Object)expression.getValue());
            }
            case 2: {
                return net.sf.hibernate.expression.Expression.lt((String)this.getFieldName(expression.getField()), (Object)expression.getValue());
            }
        }
        return net.sf.hibernate.expression.Expression.eq((String)this.getFieldName(expression.getField()), (Object)expression.getValue());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

