/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.ofbiz.core.util.OrderedMap;
import org.ofbiz.core.util.UtilMisc;

public class UtilHttp {
    public static Map getParameterMap(HttpServletRequest request) {
        String name;
        int current;
        OrderedMap paramMap = new OrderedMap();
        String pathInfoStr = request.getPathInfo();
        if (!pathInfoStr.endsWith("/")) {
            pathInfoStr = pathInfoStr + "/";
        }
        int last = current = pathInfoStr.indexOf(47);
        while ((current = pathInfoStr.indexOf(47, last + 1)) != -1) {
            String element = pathInfoStr.substring(last + 1, current);
            last = current;
            if (element.charAt(0) != '~' || element.indexOf(61) <= -1) continue;
            name = element.substring(1, element.indexOf(61));
            String value = element.substring(element.indexOf(61) + 1);
            paramMap.put(name, value);
        }
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            paramMap.put(name, request.getParameter(name));
        }
        return paramMap;
    }

    public static String getApplicationName(HttpServletRequest request) {
        String appName = "root";
        if (request.getContextPath().length() > 1) {
            appName = request.getContextPath().substring(1);
        }
        return appName;
    }

    public static void parametersToAttributes(HttpServletRequest request) {
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            request.setAttribute(name, (Object)request.getParameter(name));
        }
    }

    public static StringBuffer getServerRootUrl(HttpServletRequest request) {
        StringBuffer requestUrl = new StringBuffer();
        requestUrl.append(request.getScheme());
        requestUrl.append("://" + request.getServerName());
        if (request.getServerPort() != 80 && request.getServerPort() != 443) {
            requestUrl.append(":" + request.getServerPort());
        }
        return requestUrl;
    }

    public static StringBuffer getFullRequestUrl(HttpServletRequest request) {
        StringBuffer requestUrl = UtilHttp.getServerRootUrl(request);
        requestUrl.append(request.getRequestURI());
        if (request.getQueryString() != null) {
            requestUrl.append("?" + request.getQueryString());
        }
        return requestUrl;
    }

    private static Locale getLocale(HttpServletRequest request, HttpSession session) {
        Object localeObject;
        Object object = localeObject = session != null ? session.getAttribute("locale") : null;
        if (localeObject == null) {
            Object object2 = localeObject = request != null ? request.getLocale() : null;
        }
        if (localeObject != null && localeObject instanceof String) {
            localeObject = UtilMisc.parseLocale((String)localeObject);
        }
        if (localeObject != null && localeObject instanceof Locale) {
            return (Locale)localeObject;
        }
        return Locale.getDefault();
    }

    public static Locale getLocale(HttpServletRequest request) {
        if (request == null) {
            return Locale.getDefault();
        }
        return UtilHttp.getLocale(request, request.getSession());
    }

    public static Locale getLocale(HttpSession session) {
        if (session == null) {
            return Locale.getDefault();
        }
        return UtilHttp.getLocale(null, session);
    }

    public static void setLocale(HttpServletRequest request, String localeString) {
        UtilHttp.setLocale(request, UtilMisc.parseLocale(localeString));
    }

    public static void setLocale(HttpServletRequest request, Locale locale) {
        request.getSession().setAttribute("locale", (Object)locale);
    }

    public static String urlEncodeArgs(Map args) {
        StringBuffer buf = new StringBuffer();
        Set names = args.keySet();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Object value = args.get(name);
            String valueStr = null;
            if (value != null && value instanceof String) {
                valueStr = (String)value;
            } else if (value != null) {
                valueStr = value.toString();
            }
            if (name == null) continue;
            buf.append(URLEncoder.encode(name));
            buf.append("=");
            if (valueStr == null) {
                valueStr = "";
            }
            buf.append(URLEncoder.encode(valueStr));
            if (!i.hasNext()) continue;
            buf.append("&");
        }
        return buf.toString();
    }
}

