/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Date;
import org.ofbiz.core.util.Debug;

public class SendMailSMTP {
    private String destinationSMTPServer = null;
    private String localMachine = null;
    private String senderName = null;
    private String recipientTO = null;
    private String recipientCC = null;
    private String recipientBCC = null;
    private String subject = null;
    private String message = null;
    private String extraHeader = null;
    private BufferedReader in;
    private BufferedWriter out;
    public static final int SMTP_PORT = 25;

    public SendMailSMTP() {
    }

    public SendMailSMTP(String sender) {
        this.setSender(sender);
    }

    public SendMailSMTP(String sender, String recipientTO, String message) {
        this.setSender(sender);
        this.setRecipientTO(recipientTO);
        this.setMessage(message);
    }

    public SendMailSMTP(String destinationSMTPServer, String sender, String recipientTO, String message) {
        this.setSender(sender);
        this.setRecipientTO(recipientTO);
        this.setMessage(message);
        this.setDestinationSMTPServer(destinationSMTPServer);
    }

    public SendMailSMTP(String destinationSMTPServer, String localMachine, String sender, String recipientTO, String recipientCC, String recipientBCC, String subject, String message) {
        this.setSender(sender);
        this.setRecipientTO(recipientTO);
        this.setRecipientCC(recipientCC);
        this.setRecipientBCC(recipientBCC);
        this.setSubject(subject);
        this.setMessage(message);
        this.setLocalMachine(localMachine);
        this.setDestinationSMTPServer(destinationSMTPServer);
    }

    public void setSender(String sender) {
        int indexOfAtSign = sender.indexOf(64);
        if (indexOfAtSign < 0) {
            throw new RuntimeException("Malformed sender address. Need full user@host format");
        }
        this.senderName = sender;
        this.localMachine = sender.substring(indexOfAtSign + 1);
    }

    public void setLocalMachine(String localMachine) {
        this.localMachine = localMachine;
    }

    public void setRecipientTO(String recipientTO) {
        this.recipientTO = recipientTO;
    }

    public void setRecipientCC(String recipientCC) {
        this.recipientCC = recipientCC;
    }

    public void setRecipientBCC(String recipientBCC) {
        this.recipientBCC = recipientBCC;
    }

    public void setDestinationSMTPServer(String destinationSMTPServer) {
        this.destinationSMTPServer = destinationSMTPServer;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setExtraHeader(String extraHeader) {
        this.extraHeader = extraHeader;
    }

    public void send() throws IOException {
        int indexofcomma;
        if (this.destinationSMTPServer == null) {
            throw new RuntimeException("No destinationSMTPServer specified!");
        }
        if (this.localMachine == null) {
            throw new RuntimeException("No localMachine specified!");
        }
        if (this.senderName == null) {
            throw new RuntimeException("No senderName specified!");
        }
        if (this.message == null) {
            throw new RuntimeException("No message specified!");
        }
        Socket s = new Socket(this.destinationSMTPServer, 25);
        this.in = new BufferedReader(new InputStreamReader(s.getInputStream(), "8859_1"));
        this.out = new BufferedWriter(new OutputStreamWriter(s.getOutputStream(), "8859_1"));
        String header = new String();
        if (this.subject != null) {
            header = "Subject: " + this.subject + "\n";
        }
        String response = this.hear(true);
        this.say("HELO " + this.localMachine + "\n");
        response = this.hear(true);
        header = header + "From: " + this.senderName + "\n";
        this.say("MAIL FROM: " + this.senderName + "\n");
        response = this.hear(true);
        if (this.recipientTO != null) {
            header = header + "To: " + this.recipientTO + "\n";
            indexofcomma = this.recipientTO.indexOf(44);
            while (indexofcomma > 0) {
                this.say("RCPT TO: " + this.recipientTO.substring(0, indexofcomma) + "\n");
                response = this.hear(false);
                this.recipientTO = this.recipientTO.substring(indexofcomma + 1);
                indexofcomma = this.recipientTO.indexOf(44);
            }
            this.say("RCPT TO: " + this.recipientTO + "\n");
            response = this.hear(false);
        }
        if (this.recipientCC != null) {
            header = header + "Cc: " + this.recipientCC + "\n";
            indexofcomma = this.recipientCC.indexOf(44);
            while (indexofcomma > 0) {
                this.say("RCPT TO: " + this.recipientCC.substring(0, indexofcomma) + "\n");
                response = this.hear(false);
                this.recipientCC = this.recipientCC.substring(indexofcomma + 1);
                indexofcomma = this.recipientCC.indexOf(44);
            }
            this.say("RCPT TO: " + this.recipientCC + "\n");
            response = this.hear(false);
        }
        if (this.recipientBCC != null) {
            indexofcomma = this.recipientBCC.indexOf(44);
            while (indexofcomma > 0) {
                this.say("RCPT TO: " + this.recipientBCC.substring(0, indexofcomma) + "\n");
                response = this.hear(false);
                this.recipientBCC = this.recipientBCC.substring(indexofcomma + 1);
                indexofcomma = this.recipientBCC.indexOf(44);
            }
            this.say("RCPT TO: " + this.recipientBCC + "\n");
            response = this.hear(false);
        }
        Date today = new Date();
        header = header + "Date: " + today.toString() + "\n";
        if (this.extraHeader != null) {
            header = header + this.extraHeader;
        }
        this.say("DATA\n");
        response = this.hear(true);
        this.say(header + "\n\n" + this.message + "\n.\n");
        response = this.hear(true);
        this.say("QUIT\n");
        s.close();
    }

    private void say(String toSay) throws IOException {
        this.out.write(toSay);
        this.out.flush();
    }

    private String hear(boolean stop) throws IOException {
        String inString = this.in.readLine();
        if ("23".indexOf(inString.charAt(0)) < 0) {
            if (stop) {
                throw new IOException("SMTP problem: " + inString);
            }
            System.out.println("SMTP problem: " + inString);
        }
        Debug.log("SendMailSMTP: " + inString);
        return inString;
    }
}

