/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HttpRequestFileUpload {
    private int BUFFER_SIZE = 4096;
    private int WAIT_INTERVAL = 200;
    private int MAX_WAITS = 20;
    private int waitCount = 0;
    private String savePath;
    private String filepath;
    private String filename;
    private String contentType;
    private String overrideFilename = null;
    private Dictionary fields;

    public String getOverrideFilename() {
        return this.overrideFilename;
    }

    public void setOverrideFilename(String ofName) {
        this.overrideFilename = ofName;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFieldValue(String fieldName) {
        if (this.fields == null || fieldName == null) {
            return null;
        }
        return (String)this.fields.get(fieldName);
    }

    private void setFilename(String s) {
        if (s == null) {
            return;
        }
        int pos = s.indexOf("filename=\"");
        if (pos != -1) {
            this.filepath = s.substring(pos + 10, s.length() - 1);
            pos = this.filepath.lastIndexOf("\\");
            this.filename = pos != -1 ? this.filepath.substring(pos + 1) : this.filepath;
        }
    }

    private void setContentType(String s) {
        if (s == null) {
            return;
        }
        int pos = s.indexOf(": ");
        if (pos != -1) {
            this.contentType = s.substring(pos + 2, s.length());
        }
    }

    public void doUpload(HttpServletRequest request) throws IOException {
        ServletInputStream in = request.getInputStream();
        String reqLengthString = request.getHeader("content-length");
        System.out.println("expect " + reqLengthString + " bytes.");
        int requestLength = 0;
        try {
            requestLength = new Integer(reqLengthString);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
        byte[] line = new byte[this.BUFFER_SIZE];
        int i = -1;
        i = this.waitingReadLine(in, line, 0, this.BUFFER_SIZE, requestLength);
        requestLength -= i;
        if (i < 3) {
            return;
        }
        int boundaryLength = i - 2;
        String boundary = new String(line, 0, boundaryLength);
        System.out.println("boundary=[" + boundary + "] length is " + boundaryLength);
        this.fields = new Hashtable();
        while (requestLength > 0) {
            String newLine = "";
            if (i > -1) {
                newLine = new String(line, 0, i);
            }
            if (newLine.startsWith("Content-Disposition: form-data; name=\"")) {
                if (newLine.indexOf("filename=\"") != -1) {
                    boolean oneByteLine;
                    this.setFilename(new String(line, 0, i - 2));
                    if (this.filename == null) {
                        return;
                    }
                    i = this.waitingReadLine(in, line, 0, this.BUFFER_SIZE, requestLength);
                    requestLength -= i;
                    this.setContentType(new String(line, 0, i - 2));
                    i = this.waitingReadLine(in, line, 0, this.BUFFER_SIZE, requestLength);
                    requestLength -= i;
                    newLine = new String(line, 0, i);
                    String filenameToUse = this.filename;
                    if (this.overrideFilename != null) {
                        filenameToUse = this.overrideFilename;
                    }
                    i = this.waitingReadLine(in, line, 0, this.BUFFER_SIZE, requestLength);
                    requestLength -= i;
                    newLine = new String(line, 0, i);
                    byte[] lastTwoBytes = new byte[2];
                    if (i > 1) {
                        lastTwoBytes[0] = line[i - 2];
                        lastTwoBytes[1] = line[i - 1];
                    }
                    System.out.println("about to create a file:" + (this.savePath == null ? "" : this.savePath) + filenameToUse);
                    FileOutputStream fos = new FileOutputStream((this.savePath == null ? "" : this.savePath) + filenameToUse);
                    boolean bail = new String(line, 0, i).startsWith(boundary);
                    boolean bl = oneByteLine = i == 1;
                    while (requestLength > 0 && !bail) {
                        if (i > 1) {
                            fos.write(line, 0, i - 2);
                        }
                        oneByteLine = i == 1;
                        if ((requestLength -= (i = this.waitingReadLine(in, line, 0, this.BUFFER_SIZE, requestLength))) < 1) {
                            bail = true;
                        } else if (oneByteLine) {
                            fos.write(lastTwoBytes, 0, 1);
                        } else {
                            fos.write(lastTwoBytes, 0, 2);
                        }
                        if (i > 1) {
                            lastTwoBytes[0] = line[i - 2];
                            lastTwoBytes[1] = line[i - 1];
                            continue;
                        }
                        lastTwoBytes[0] = line[0];
                    }
                    fos.flush();
                    fos.close();
                } else {
                    int pos = newLine.indexOf("name=\"");
                    String fieldName = newLine.substring(pos + 6, newLine.length() - 3);
                    i = this.waitingReadLine(in, line, 0, this.BUFFER_SIZE, requestLength);
                    requestLength -= i;
                    i = this.waitingReadLine(in, line, 0, this.BUFFER_SIZE, requestLength);
                    requestLength -= i;
                    newLine = new String(line, 0, i);
                    StringBuffer fieldValue = new StringBuffer(this.BUFFER_SIZE);
                    while (requestLength > 0 && !newLine.startsWith(boundary)) {
                        i = this.waitingReadLine(in, line, 0, this.BUFFER_SIZE, requestLength);
                        requestLength -= i;
                        if ((i == boundaryLength + 2 || i == boundaryLength + 4) && new String(line, 0, i).startsWith(boundary)) {
                            fieldValue.append(newLine.substring(0, newLine.length() - 2));
                        } else {
                            fieldValue.append(newLine);
                        }
                        newLine = new String(line, 0, i);
                    }
                    this.fields.put(fieldName, fieldValue.toString());
                }
            }
            if ((i = this.waitingReadLine(in, line, 0, this.BUFFER_SIZE, requestLength)) <= -1) continue;
            requestLength -= i;
        }
    }

    private int waitingReadLine(ServletInputStream in, byte[] buf, int off, int len, int reqLen) throws IOException {
        int i = -1;
        while ((i = in.readLine(buf, off, len)) == -1 && reqLen > 0) {
            System.out.print("waiting");
            if (this.waitCount > this.MAX_WAITS) {
                System.out.println("waited " + this.waitCount + " times, bailing out while still expecting " + reqLen + " bytes.");
                throw new IOException("waited " + this.waitCount + " times, bailing out while still expecting " + reqLen + " bytes.");
            }
            ++this.waitCount;
            long endMS = new Date().getTime() + (long)this.WAIT_INTERVAL;
            while (endMS > new Date().getTime()) {
                try {
                    this.wait(this.WAIT_INTERVAL);
                }
                catch (Exception e3) {
                    System.out.print(".");
                }
            }
            System.out.println(new Date().getTime() - endMS + " ms");
        }
        return i;
    }
}

