/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.HttpClientException;
import org.ofbiz.core.util.URLConnector;
import org.ofbiz.core.util.UtilHttp;
import org.ofbiz.core.util.UtilProperties;

public class HttpClient {
    public static final String module = HttpClient.class.getName();
    private int timeout = 30000;
    private boolean lineFeed = true;
    private boolean followRedirects = true;
    private String url = null;
    private Map parameters = null;
    private Map headers = null;
    private URL requestUrl = null;
    private URLConnection con = null;

    public HttpClient() {
    }

    public HttpClient(URL url) {
        this.url = url.toExternalForm();
    }

    public HttpClient(String url) {
        this.url = url;
    }

    public HttpClient(String url, Map parameters) {
        this.url = url;
        this.parameters = parameters;
    }

    public HttpClient(URL url, Map parameters) {
        this.url = url.toExternalForm();
        this.parameters = parameters;
    }

    public HttpClient(String url, Map parameters, Map headers) {
        this.url = url;
        this.parameters = parameters;
        this.headers = headers;
    }

    public HttpClient(URL url, Map parameters, Map headers) {
        this.url = url.toExternalForm();
        this.parameters = parameters;
        this.headers = headers;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setLineFeed(boolean lineFeed) {
        this.lineFeed = lineFeed;
    }

    public void setUrl(URL url) {
        this.url = url.toExternalForm();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public void setParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(name, value);
    }

    public void setHeaders(Map headers) {
        this.headers = headers;
    }

    public void setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(name, value);
    }

    public Map getHeaders() {
        return this.headers;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public String getUrl() {
        return this.url;
    }

    public String get() throws HttpClientException {
        return this.sendHttpRequest("get");
    }

    public InputStream getStream() throws HttpClientException {
        return this.sendHttpRequestStream("get");
    }

    public String post() throws HttpClientException {
        return this.sendHttpRequest("post");
    }

    public InputStream postStream() throws HttpClientException {
        return this.sendHttpRequestStream("post");
    }

    public String getResponseHeader(String header) throws HttpClientException {
        if (this.con == null) {
            throw new HttpClientException("Connection not yet established");
        }
        return this.con.getHeaderField(header);
    }

    public String getResponseHeaderFieldKey(int n) throws HttpClientException {
        if (this.con == null) {
            throw new HttpClientException("Connection not yet established");
        }
        return this.con.getHeaderFieldKey(n);
    }

    public String getResponseHeaderField(int n) throws HttpClientException {
        if (this.con == null) {
            throw new HttpClientException("Connection not yet established");
        }
        return this.con.getHeaderField(n);
    }

    public Object getResponseContent() throws IOException, HttpClientException {
        if (this.con == null) {
            throw new HttpClientException("Connection not yet established");
        }
        return this.con.getContent();
    }

    public String getResponseContentType() throws HttpClientException {
        if (this.con == null) {
            throw new HttpClientException("Connection not yet established");
        }
        return this.con.getContentType();
    }

    public int getResponseContentLength() throws HttpClientException {
        if (this.con == null) {
            throw new HttpClientException("Connection not yet established");
        }
        return this.con.getContentLength();
    }

    public String getResponseContentEncoding() throws HttpClientException {
        if (this.con == null) {
            throw new HttpClientException("Connection not yet established");
        }
        return this.con.getContentEncoding();
    }

    private String sendHttpRequest(String method) throws HttpClientException {
        InputStream in = this.sendHttpRequestStream(method);
        if (in == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        try {
            if (Debug.verboseOn()) {
                try {
                    Debug.logVerbose("ContentEncoding: " + this.con.getContentEncoding() + "; ContentType: " + this.con.getContentType() + " or: " + URLConnection.guessContentTypeFromStream(in), module);
                }
                catch (IOException ioe) {
                    Debug.logWarning(ioe, "Caught exception printing content debugging information", module);
                }
            }
            String charset = null;
            String contentType = this.con.getContentType();
            if (contentType == null) {
                try {
                    contentType = URLConnection.guessContentTypeFromStream(in);
                }
                catch (IOException ioe) {
                    Debug.logWarning(ioe, "Problems guessing content type from steam", module);
                }
            }
            if (Debug.verboseOn()) {
                Debug.logVerbose("Content-Type: " + contentType, module);
            }
            if (contentType != null) {
                contentType = contentType.toUpperCase();
                int charsetEqualsLoc = contentType.indexOf("=", contentType.indexOf("CHARSET"));
                int afterSemiColon = contentType.indexOf(";", charsetEqualsLoc);
                if (charsetEqualsLoc >= 0 && afterSemiColon >= 0) {
                    charset = contentType.substring(charsetEqualsLoc + 1, afterSemiColon);
                } else if (charsetEqualsLoc >= 0) {
                    charset = contentType.substring(charsetEqualsLoc + 1);
                }
                if (charset != null) {
                    charset = charset.trim();
                }
                if (Debug.infoOn()) {
                    Debug.logInfo("Getting text from HttpClient with charset: " + charset);
                }
            }
            BufferedReader post = new BufferedReader(charset == null ? new InputStreamReader(in) : new InputStreamReader(in, charset));
            String line = new String();
            if (Debug.verboseOn()) {
                Debug.logVerbose("---- HttpClient Response Content ----", module);
            }
            while ((line = post.readLine()) != null) {
                if (Debug.verboseOn()) {
                    Debug.logVerbose("[HttpClient] : " + line, module);
                }
                buf.append(line);
                if (!this.lineFeed) continue;
                buf.append("\n");
            }
        }
        catch (Exception e) {
            throw new HttpClientException("Error processing input stream", e);
        }
        return buf.toString();
    }

    private InputStream sendHttpRequestStream(String method) throws HttpClientException {
        String protocol = UtilProperties.getPropertyValue("jsse.properties", "java.protocol.handler.pkgs", "NONE");
        String proxyHost = UtilProperties.getPropertyValue("jsse.properties", "https.proxyHost", "NONE");
        String proxyPort = UtilProperties.getPropertyValue("jsse.properties", "https.proxyPort", "NONE");
        String cypher = UtilProperties.getPropertyValue("jsse.properties", "https.cipherSuites", "NONE");
        if (protocol != null && !protocol.equals("NONE")) {
            System.setProperty("java.protocol.handler.pkgs", protocol);
        }
        if (proxyHost != null && !proxyHost.equals("NONE")) {
            System.setProperty("https.proxyHost", proxyHost);
        }
        if (proxyPort != null && !proxyPort.equals("NONE")) {
            System.setProperty("https.proxyPort", proxyPort);
        }
        if (cypher != null && !cypher.equals("NONE")) {
            System.setProperty("https.cipherSuites", cypher);
        }
        String arguments = null;
        InputStream in = null;
        if (this.url == null) {
            throw new HttpClientException("Cannot process a null URL.");
        }
        if (this.parameters != null && this.parameters.size() > 0) {
            arguments = UtilHttp.urlEncodeArgs(this.parameters);
        }
        if (method.equalsIgnoreCase("get") && arguments != null) {
            this.url = this.url + "?" + arguments;
        }
        try {
            this.requestUrl = new URL(this.url);
            this.con = URLConnector.openConnection(this.requestUrl, this.timeout);
            if (this.con instanceof HttpURLConnection) {
                ((HttpURLConnection)this.con).setInstanceFollowRedirects(this.followRedirects);
            }
            this.con.setDoOutput(true);
            this.con.setUseCaches(false);
            if (method.equalsIgnoreCase("post")) {
                this.con.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                this.con.setDoInput(true);
            }
            if (this.headers != null && this.headers.size() > 0) {
                Set headerSet = this.headers.keySet();
                for (String headerName : headerSet) {
                    String headerValue = (String)this.headers.get(headerName);
                    this.con.setRequestProperty(headerName, headerValue);
                }
            }
            if (method.equalsIgnoreCase("post")) {
                DataOutputStream out = new DataOutputStream(this.con.getOutputStream());
                out.writeBytes(arguments);
                out.flush();
                out.close();
            }
            in = this.con.getInputStream();
        }
        catch (Exception e) {
            throw new HttpClientException("Error processing request", e);
        }
        return in;
    }
}

