/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.util.Debug;

public final class BshUtil {
    public static final String module = BshUtil.class.getName();

    public static final Object eval(String expression, Map context) throws EvalError {
        Interpreter bsh = new Interpreter();
        Object o = null;
        if (expression == null || expression.equals("")) {
            Debug.logError("BSH Evaluation error. Empty expression", module);
            return null;
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose("Evaluating -- " + expression, module);
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose("Using Context -- " + context, module);
        }
        try {
            if (context != null) {
                Set keySet = context.keySet();
                for (Object key : keySet) {
                    Object value = context.get(key);
                    bsh.set((String)key, value);
                }
            }
            o = bsh.eval(expression);
            if (Debug.verboseOn()) {
                Debug.logVerbose("Evaluated to -- " + o, module);
            }
            NameSpace ns = bsh.getNameSpace();
            String[] varNames = ns.getVariableNames();
            for (int x = 0; x < varNames.length; ++x) {
                context.put(varNames[x], bsh.get(varNames[x]));
            }
        }
        catch (EvalError e) {
            Debug.logError(e, "BSH Evaluation error.", module);
            throw e;
        }
        return o;
    }
}

