/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.serialize;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.serialize.SerializeException;
import org.ofbiz.core.util.UtilMisc;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XmlSerializer {
    private static WeakReference simpleDateFormatter;

    public static String serialize(Object object) throws SerializeException, FileNotFoundException, IOException {
        Document document = UtilXml.makeEmptyXmlDocument((String)"ofbiz-ser");
        Element rootElement = document.getDocumentElement();
        rootElement.appendChild(XmlSerializer.serializeSingle(object, document));
        return UtilXml.writeXmlDocument((Document)document);
    }

    public static Object deserialize(String content, GenericDelegator delegator) throws SerializeException, SAXException, ParserConfigurationException, IOException {
        Node curChild;
        Document document = UtilXml.readXmlDocument((String)content, (boolean)false);
        Element rootElement = document.getDocumentElement();
        for (curChild = rootElement.getFirstChild(); curChild != null && curChild.getNodeType() != 1; curChild = curChild.getNextSibling()) {
        }
        if (curChild == null) {
            return null;
        }
        Element element = (Element)curChild;
        return XmlSerializer.deserializeSingle(element, delegator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element serializeSingle(Object object, Document document) throws SerializeException {
        if (document == null) {
            return null;
        }
        if (object == null) {
            return document.createElement("null");
        }
        if (object instanceof String) {
            return XmlSerializer.makeElement("std-String", object, document);
        }
        if (object instanceof Integer) {
            return XmlSerializer.makeElement("std-Integer", object, document);
        }
        if (object instanceof Long) {
            return XmlSerializer.makeElement("std-Long", object, document);
        }
        if (object instanceof Float) {
            return XmlSerializer.makeElement("std-Float", object, document);
        }
        if (object instanceof Double) {
            return XmlSerializer.makeElement("std-Double", object, document);
        }
        if (object instanceof Boolean) {
            return XmlSerializer.makeElement("std-Boolean", object, document);
        }
        if (object instanceof Locale) {
            return XmlSerializer.makeElement("std-Locale", object, document);
        }
        if (object instanceof Timestamp) {
            return XmlSerializer.makeElement("sql-Timestamp", object, document);
        }
        if (object instanceof Date) {
            return XmlSerializer.makeElement("sql-Date", object, document);
        }
        if (object instanceof Time) {
            return XmlSerializer.makeElement("sql-Time", object, document);
        }
        if (object instanceof java.util.Date) {
            DateFormat formatter = XmlSerializer.getDateFormat();
            String stringValue = null;
            DateFormat dateFormat = formatter;
            synchronized (dateFormat) {
                stringValue = formatter.format((java.util.Date)object);
            }
            return XmlSerializer.makeElement("std-Date", stringValue, document);
        }
        if (object instanceof Collection) {
            String elementName = null;
            elementName = object instanceof ArrayList ? "col-ArrayList" : (object instanceof LinkedList ? "col-LinkedList" : (object instanceof Stack ? "col-Stack" : (object instanceof Vector ? "col-Vector" : (object instanceof TreeSet ? "col-TreeSet" : (object instanceof HashSet ? "col-HashSet" : "col-Collection")))));
            Collection value = (Collection)object;
            Element element = document.createElement(elementName);
            Iterator iter = value.iterator();
            while (iter.hasNext()) {
                element.appendChild(XmlSerializer.serializeSingle(iter.next(), document));
            }
            return element;
        }
        if (object instanceof GenericPK) {
            GenericPK value = (GenericPK)object;
            return value.makeXmlElement(document, "eepk-");
        }
        if (object instanceof GenericValue) {
            GenericValue value = (GenericValue)object;
            return value.makeXmlElement(document, "eeval-");
        }
        if (object instanceof Map) {
            String elementName = null;
            elementName = object instanceof HashMap ? "map-HashMap" : (object instanceof Properties ? "map-Properties" : (object instanceof Hashtable ? "map-Hashtable" : (object instanceof WeakHashMap ? "map-WeakHashMap" : (object instanceof TreeMap ? "map-TreeMap" : "map-Map"))));
            Element element = document.createElement(elementName);
            Map value = (Map)object;
            for (Map.Entry entry : value.entrySet()) {
                Element entryElement = document.createElement("map-Entry");
                element.appendChild(entryElement);
                Element key = document.createElement("map-Key");
                entryElement.appendChild(key);
                key.appendChild(XmlSerializer.serializeSingle(entry.getKey(), document));
                Element mapValue = document.createElement("map-Value");
                entryElement.appendChild(mapValue);
                mapValue.appendChild(XmlSerializer.serializeSingle(entry.getValue(), document));
            }
            return element;
        }
        return XmlSerializer.serializeCustom(object, document);
    }

    public static Element serializeCustom(Object object, Document document) throws SerializeException {
        throw new SerializeException("Cannot serialize object of class " + object.getClass().getName());
    }

    public static Element makeElement(String elementName, Object value, Document document) {
        if (value == null) {
            return document.createElement("null");
        }
        Element element = document.createElement(elementName);
        element.setAttribute("value", value.toString());
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeSingle(Element element, GenericDelegator delegator) throws SerializeException {
        String tagName = element.getTagName();
        if (tagName.equals("null")) {
            return null;
        }
        if (tagName.startsWith("std-")) {
            if ("std-String".equals(tagName)) {
                return element.getAttribute("value");
            }
            if ("std-Integer".equals(tagName)) {
                String valStr = element.getAttribute("value");
                return Integer.valueOf(valStr);
            }
            if ("std-Long".equals(tagName)) {
                String valStr = element.getAttribute("value");
                return Long.valueOf(valStr);
            }
            if ("std-Float".equals(tagName)) {
                String valStr = element.getAttribute("value");
                return Float.valueOf(valStr);
            }
            if ("std-Double".equals(tagName)) {
                String valStr = element.getAttribute("value");
                return Double.valueOf(valStr);
            }
            if ("std-Boolean".equals(tagName)) {
                String valStr = element.getAttribute("value");
                return Boolean.valueOf(valStr);
            }
            if ("std-Locale".equals(tagName)) {
                String valStr = element.getAttribute("value");
                return UtilMisc.parseLocale((String)valStr);
            }
            if ("std-Date".equals(tagName)) {
                String valStr = element.getAttribute("value");
                DateFormat formatter = XmlSerializer.getDateFormat();
                java.util.Date value = null;
                try {
                    DateFormat dateFormat = formatter;
                    synchronized (dateFormat) {
                        value = formatter.parse(valStr);
                    }
                }
                catch (ParseException e) {
                    throw new SerializeException("Could not parse date String: " + valStr, e);
                }
                return value;
            }
        } else if (tagName.startsWith("sql-")) {
            if ("sql-Timestamp".equals(tagName)) {
                String valStr = element.getAttribute("value");
                return Timestamp.valueOf(valStr);
            }
            if ("sql-Date".equals(tagName)) {
                String valStr = element.getAttribute("value");
                return Date.valueOf(valStr);
            }
            if ("sql-Time".equals(tagName)) {
                String valStr = element.getAttribute("value");
                return Time.valueOf(valStr);
            }
        } else {
            if (tagName.startsWith("col-")) {
                AbstractCollection value = null;
                if ("col-ArrayList".equals(tagName)) {
                    value = new ArrayList();
                } else if ("col-LinkedList".equals(tagName)) {
                    value = new LinkedList();
                } else if ("col-Stack".equals(tagName)) {
                    value = new Stack();
                } else if ("col-Vector".equals(tagName)) {
                    value = new Vector();
                } else if ("col-TreeSet".equals(tagName)) {
                    value = new TreeSet();
                } else if ("col-HashSet".equals(tagName)) {
                    value = new HashSet();
                } else if ("col-Collection".equals(tagName)) {
                    value = new LinkedList();
                }
                if (value == null) {
                    return XmlSerializer.deserializeCustom(element);
                }
                for (Node curChild = element.getFirstChild(); curChild != null; curChild = curChild.getNextSibling()) {
                    if (curChild.getNodeType() != 1) continue;
                    value.add(XmlSerializer.deserializeSingle((Element)curChild, delegator));
                }
                return value;
            }
            if (tagName.startsWith("map-")) {
                Map<Object, Object> value = null;
                if ("map-HashMap".equals(tagName)) {
                    value = new HashMap();
                } else if ("map-Properties".equals(tagName)) {
                    value = new Properties();
                } else if ("map-Hashtable".equals(tagName)) {
                    value = new Hashtable();
                } else if ("map-WeakHashMap".equals(tagName)) {
                    value = new WeakHashMap();
                } else if ("map-TreeMap".equals(tagName)) {
                    value = new TreeMap();
                } else if ("map-Map".equals(tagName)) {
                    value = new HashMap();
                }
                if (value == null) {
                    return XmlSerializer.deserializeCustom(element);
                }
                for (Node curChild = element.getFirstChild(); curChild != null; curChild = curChild.getNextSibling()) {
                    Node tempNode;
                    Element curElement;
                    if (curChild.getNodeType() != 1 || !"map-Entry".equals((curElement = (Element)curChild).getTagName())) continue;
                    Element mapKeyElement = UtilXml.firstChildElement((Element)curElement, (String)"map-Key");
                    Element keyElement = null;
                    for (tempNode = mapKeyElement.getFirstChild(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                        if (tempNode.getNodeType() != 1) continue;
                        keyElement = (Element)tempNode;
                        break;
                    }
                    if (keyElement == null) {
                        throw new SerializeException("Could not find an element under the map-Key");
                    }
                    Element mapValueElement = UtilXml.firstChildElement((Element)curElement, (String)"map-Value");
                    Element valueElement = null;
                    for (tempNode = mapValueElement.getFirstChild(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                        if (tempNode.getNodeType() != 1) continue;
                        valueElement = (Element)tempNode;
                        break;
                    }
                    if (valueElement == null) {
                        throw new SerializeException("Could not find an element under the map-Value");
                    }
                    value.put(XmlSerializer.deserializeSingle(keyElement, delegator), XmlSerializer.deserializeSingle(valueElement, delegator));
                }
                return value;
            }
            if (tagName.startsWith("eepk-")) {
                return delegator.makePK(element);
            }
            if (tagName.startsWith("eeval-")) {
                return delegator.makeValue(element);
            }
        }
        return XmlSerializer.deserializeCustom(element);
    }

    public static Object deserializeCustom(Element element) throws SerializeException {
        throw new SerializeException("Cannot deserialize element named " + element.getTagName());
    }

    private static DateFormat getDateFormat() {
        DateFormat formatter = null;
        if (simpleDateFormatter != null) {
            formatter = (DateFormat)simpleDateFormatter.get();
        }
        if (formatter == null) {
            formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            simpleDateFormatter = new WeakReference<DateFormat>(formatter);
        }
        return formatter;
    }
}

