/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.ServletException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.FastCommonAccessLogValve;
import org.apache.catalina.valves.ValveBase;

public final class FastCommonAccessLogValve
extends ValveBase
implements Lifecycle {
    private String dateStamp = "";
    private String directory = "logs";
    protected static final String info = "org.apache.catalina.valves.FastCommonAccessLogValve/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private boolean combined = false;
    private String pattern = null;
    private String prefix = "access_log.";
    private boolean rotatable = true;
    private volatile long rotationLastChecked = 0L;
    private StringManager sm = StringManager.getManager((String)"org.apache.catalina.valves");
    private boolean started = false;
    private String suffix = "";
    private PrintWriter writer = null;
    private SimpleDateFormat fileDateFormatter = null;
    private static final TimeZone timezone = TimeZone.getDefault();
    private static final String timeZoneNoDST = FastCommonAccessLogValve.calculateTimeZoneOffset(timezone.getRawOffset());
    private static final String timeZoneDST;
    private static ThreadLocal currentDateStruct;
    private String space = " ";
    private boolean resolveHosts = false;
    private String condition = null;
    private String fileDateFormat = null;

    public FastCommonAccessLogValve() {
        this.setPattern("common");
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getInfo() {
        return info;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (pattern == null) {
            pattern = "";
        }
        if (pattern.equals("common")) {
            pattern = "%h %l %u %t \"%r\" %s %b";
        }
        if (pattern.equals("combined")) {
            pattern = "%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"";
        }
        this.pattern = pattern;
        this.combined = this.pattern.equals("%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"");
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setResolveHosts(boolean resolveHosts) {
        this.resolveHosts = resolveHosts;
    }

    public boolean isResolveHosts() {
        return this.resolveHosts;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getFileDateFormat() {
        return this.fileDateFormat;
    }

    public void setFileDateFormat(String fileDateFormat) {
        this.fileDateFormat = fileDateFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backgroundProcess() {
        FastCommonAccessLogValve fastCommonAccessLogValve = this;
        synchronized (fastCommonAccessLogValve) {
            if (this.writer != null) {
                this.writer.flush();
            }
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
        if (this.condition != null && null != request.getRequest().getAttribute(this.condition)) {
            return;
        }
        StringBuffer result = new StringBuffer();
        String value = null;
        if (this.isResolveHosts()) {
            result.append(request.getRemoteHost());
        } else {
            result.append(request.getRemoteAddr());
        }
        result.append(" - ");
        value = request.getRemoteUser();
        if (value == null) {
            result.append("- ");
        } else {
            result.append(value);
            result.append(this.space);
        }
        AccessDateStruct struct = (AccessDateStruct)currentDateStruct.get();
        result.append(struct.getCurrentDateString());
        result.append(request.getMethod());
        result.append(this.space);
        result.append(request.getRequestURI());
        if (request.getQueryString() != null) {
            result.append('?');
            result.append(request.getQueryString());
        }
        result.append(this.space);
        result.append(request.getProtocol());
        result.append("\" ");
        result.append(response.getStatus());
        result.append(this.space);
        long length = response.getContentCountLong();
        value = length <= 0L ? "-" : "" + length;
        result.append(value);
        if (this.combined) {
            result.append(this.space);
            result.append("\"");
            String referer = request.getHeader("referer");
            if (referer != null) {
                result.append(referer);
            } else {
                result.append("-");
            }
            result.append("\"");
            result.append(this.space);
            result.append("\"");
            String ua = request.getHeader("user-agent");
            if (ua != null) {
                result.append(ua);
            } else {
                result.append("-");
            }
            result.append("\"");
        }
        this.log(result.toString());
    }

    private synchronized void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.dateStamp = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String message) {
        long systime;
        if (this.rotatable && (systime = System.currentTimeMillis()) - this.rotationLastChecked > 1000L) {
            FastCommonAccessLogValve fastCommonAccessLogValve = this;
            synchronized (fastCommonAccessLogValve) {
                if (systime - this.rotationLastChecked > 1000L) {
                    this.rotationLastChecked = systime;
                    String tsDate = this.fileDateFormatter.format(new Date(systime));
                    if (!this.dateStamp.equals(tsDate)) {
                        this.close();
                        this.dateStamp = tsDate;
                        this.open();
                    }
                }
            }
        }
        FastCommonAccessLogValve fastCommonAccessLogValve = this;
        synchronized (fastCommonAccessLogValve) {
            if (this.writer != null) {
                this.writer.println(message);
            }
        }
    }

    private static String lookup(String month) {
        int index;
        try {
            index = Integer.parseInt(month) - 1;
        }
        catch (Throwable t) {
            index = 0;
        }
        return months[index];
    }

    private synchronized void open() {
        File dir = new File(this.directory);
        if (!dir.isAbsolute()) {
            dir = new File(System.getProperty("catalina.base"), this.directory);
        }
        dir.mkdirs();
        try {
            String pathname = this.rotatable ? dir.getAbsolutePath() + File.separator + this.prefix + this.dateStamp + this.suffix : dir.getAbsolutePath() + File.separator + this.prefix + this.suffix;
            this.writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(pathname, true), 128000), false);
        }
        catch (IOException e) {
            this.writer = null;
        }
    }

    private static String getTimeZone(Date date) {
        if (timezone.inDaylightTime(date)) {
            return timeZoneDST;
        }
        return timeZoneNoDST;
    }

    private static String calculateTimeZoneOffset(long offset) {
        StringBuffer tz = new StringBuffer();
        if (offset < 0L) {
            tz.append("-");
            offset = -offset;
        } else {
            tz.append("+");
        }
        long hourOffset = offset / 3600000L;
        long minuteOffset = offset / 60000L % 60L;
        if (hourOffset < 10L) {
            tz.append("0");
        }
        tz.append(hourOffset);
        if (minuteOffset < 10L) {
            tz.append("0");
        }
        tz.append(minuteOffset);
        return tz.toString();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("accessLogValve.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.fileDateFormat == null || this.fileDateFormat.length() == 0) {
            this.fileDateFormat = "yyyy-MM-dd";
        }
        FastCommonAccessLogValve fastCommonAccessLogValve = this;
        synchronized (fastCommonAccessLogValve) {
            this.fileDateFormatter = new SimpleDateFormat(this.fileDateFormat);
            this.fileDateFormatter.setTimeZone(timezone);
            this.dateStamp = this.fileDateFormatter.format(new Date());
        }
        this.open();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("accessLogValve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.close();
    }

    static /* synthetic */ TimeZone access$000() {
        return timezone;
    }

    static /* synthetic */ String access$100(String x0) {
        return FastCommonAccessLogValve.lookup(x0);
    }

    static /* synthetic */ String access$200(Date x0) {
        return FastCommonAccessLogValve.getTimeZone(x0);
    }

    static {
        int offset = timezone.getDSTSavings();
        timeZoneDST = FastCommonAccessLogValve.calculateTimeZoneOffset(timezone.getRawOffset() + offset);
        currentDateStruct = new /* Unavailable Anonymous Inner Class!! */;
    }
}

