/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.jms;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.jms.AbstractJmsListener;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.GeneralException;
import org.ofbiz.core.util.JNDIContextFactory;

public class JmsTopicListener
extends AbstractJmsListener {
    public static final String module = JmsTopicListener.class.getName();
    private TopicConnection con = null;
    private TopicSession session = null;
    private Topic topic = null;
    private String jndiServer;
    private String jndiName;
    private String topicName;
    private String userName;
    private String password;

    public JmsTopicListener(ServiceDispatcher dispatcher, String jndiServer, String jndiName, String topicName, String userName, String password) {
        super(dispatcher);
        this.jndiServer = jndiServer;
        this.jndiName = jndiName;
        this.topicName = topicName;
        this.userName = userName;
        this.password = password;
    }

    public void close() throws GenericServiceException {
        try {
            if (this.session != null) {
                this.session.close();
            }
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (JMSException e) {
            throw new GenericServiceException("Cannot close connection(s).", e);
        }
    }

    public synchronized void load() throws GenericServiceException {
        block7: {
            try {
                InitialContext jndi = JNDIContextFactory.getInitialContext((String)this.jndiServer);
                TopicConnectionFactory factory = (TopicConnectionFactory)jndi.lookup(this.jndiName);
                if (factory != null) {
                    this.con = factory.createTopicConnection(this.userName, this.password);
                    this.con.setExceptionListener((ExceptionListener)this);
                    this.session = this.con.createTopicSession(false, 1);
                    this.topic = (Topic)jndi.lookup(this.topicName);
                    if (this.topic != null) {
                        TopicSubscriber subscriber = this.session.createSubscriber(this.topic);
                        subscriber.setMessageListener((MessageListener)this);
                        this.con.start();
                        this.setConnected(true);
                        if (Debug.infoOn()) {
                            Debug.logInfo((String)("Listening to topic [" + this.topicName + "] on [" + this.jndiServer + "]..."), (String)module);
                        }
                        break block7;
                    }
                    throw new GenericServiceException("Topic lookup failed.");
                }
                throw new GenericServiceException("Factory (broker) lookup failed.");
            }
            catch (NamingException ne) {
                throw new GenericServiceException("JNDI lookup problems; listener not running.", ne);
            }
            catch (JMSException je) {
                throw new GenericServiceException("JMS internal error; listener not running.", je);
            }
            catch (GeneralException ge) {
                throw new GenericServiceException("Problems with InitialContext; listener not running.", ge);
            }
        }
    }
}

