/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.jms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.xa.XAResource;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.entity.GenericTransactionException;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.serialize.XmlSerializer;
import org.ofbiz.core.service.GenericRequester;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.ModelService;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.ServiceUtil;
import org.ofbiz.core.service.config.ServiceConfigUtil;
import org.ofbiz.core.service.engine.GenericEngine;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.GeneralException;
import org.ofbiz.core.util.JNDIContextFactory;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;

public class JmsServiceEngine
implements GenericEngine {
    public static final String module = JmsServiceEngine.class.getName();
    protected ServiceDispatcher dispatcher;

    public JmsServiceEngine(ServiceDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    protected Element getServiceElement(ModelService modelService) throws GenericServiceException {
        Element rootElement = null;
        try {
            rootElement = ServiceConfigUtil.getXmlRootElement();
        }
        catch (GenericConfigException e) {
            throw new GenericServiceException("Error getting JMS Service element", e);
        }
        Element serviceElement = UtilXml.firstChildElement((Element)rootElement, (String)"jms-service", (String)"name", (String)modelService.location);
        if (serviceElement == null) {
            throw new GenericServiceException("Cannot find an JMS service definition for the name [" + modelService.location + "] in the serviceengine.xml file");
        }
        return serviceElement;
    }

    protected Message makeMessage(Session session, ModelService modelService, Map context) throws GenericServiceException, JMSException {
        List outParams = modelService.getParameterNames("OUT", false);
        if (outParams != null && outParams.size() > 0) {
            throw new GenericServiceException("JMS service cannot have required OUT parameters; no parameters will be returned.");
        }
        String xmlContext = null;
        try {
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("Serializing Context --> " + context), (String)module);
            }
            xmlContext = XmlSerializer.serialize((Object)context);
        }
        catch (Exception e) {
            throw new GenericServiceException("Cannot serialize context.", e);
        }
        MapMessage message = session.createMapMessage();
        message.setString("serviceName", modelService.invoke);
        message.setString("serviceContext", xmlContext);
        return message;
    }

    protected List serverList(Element serviceElement) throws GenericServiceException {
        String sendMode = serviceElement.getAttribute("send-mode");
        List serverList = UtilXml.childElementList((Element)serviceElement, (String)"server");
        if (sendMode.equals("none")) {
            return new ArrayList();
        }
        if (sendMode.equals("all")) {
            return serverList;
        }
        throw new GenericServiceException("Requested send mode not supported.");
    }

    protected Map runTopic(ModelService modelService, Map context, Element server) throws GenericServiceException {
        String serverName = server.getAttribute("jndi-server-name");
        String jndiName = server.getAttribute("jndi-name");
        String topicName = server.getAttribute("topic-queue");
        String userName = server.getAttribute("username");
        String password = server.getAttribute("password");
        String clientId = server.getAttribute("client-id");
        InitialContext jndi = null;
        TopicConnectionFactory factory = null;
        TopicConnection con = null;
        try {
            jndi = JNDIContextFactory.getInitialContext((String)serverName);
            factory = (TopicConnectionFactory)jndi.lookup(jndiName);
        }
        catch (GeneralException ge) {
            throw new GenericServiceException("Problems getting JNDI InitialContext.", ge.getNested());
        }
        catch (NamingException ne) {
            JNDIContextFactory.clearInitialContext((String)serverName);
            try {
                jndi = JNDIContextFactory.getInitialContext((String)serverName);
                factory = (TopicConnectionFactory)jndi.lookup(jndiName);
            }
            catch (GeneralException ge2) {
                throw new GenericServiceException("Problems getting JNDI InitialContext.", ge2.getNested());
            }
            catch (NamingException ne2) {
                throw new GenericServiceException("JNDI lookup problems.", ne);
            }
        }
        try {
            con = factory.createTopicConnection(userName, password);
            if (clientId != null && clientId.length() > 1) {
                con.setClientID(clientId);
            }
            con.start();
            TopicSession session = con.createTopicSession(false, 1);
            Topic topic = (Topic)jndi.lookup(topicName);
            TopicPublisher publisher = session.createPublisher(topic);
            Message message = this.makeMessage((Session)session, modelService, context);
            publisher.publish(message);
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("Sent JMS Message to " + topicName), (String)module);
            }
            publisher.close();
            session.close();
            con.close();
        }
        catch (NamingException ne) {
            throw new GenericServiceException("Problems with JNDI lookup.", ne);
        }
        catch (JMSException je) {
            throw new GenericServiceException("JMS Internal Error.", je);
        }
        return ServiceUtil.returnSuccess();
    }

    protected Map runQueue(ModelService modelService, Map context, Element server) throws GenericServiceException {
        String serverName = server.getAttribute("jndi-server-name");
        String jndiName = server.getAttribute("jndi-name");
        String queueName = server.getAttribute("topic-queue");
        String userName = server.getAttribute("username");
        String password = server.getAttribute("password");
        String clientId = server.getAttribute("client-id");
        InitialContext jndi = null;
        QueueConnectionFactory factory = null;
        QueueConnection con = null;
        try {
            jndi = JNDIContextFactory.getInitialContext((String)serverName);
            factory = (QueueConnectionFactory)jndi.lookup(jndiName);
        }
        catch (GeneralException ge) {
            throw new GenericServiceException("Problems getting JNDI InitialContext.", ge.getNested());
        }
        catch (NamingException ne) {
            JNDIContextFactory.clearInitialContext((String)serverName);
            try {
                jndi = JNDIContextFactory.getInitialContext((String)serverName);
                factory = (QueueConnectionFactory)jndi.lookup(jndiName);
            }
            catch (GeneralException ge2) {
                throw new GenericServiceException("Problems getting JNDI InitialContext.", ge2.getNested());
            }
            catch (NamingException ne2) {
                throw new GenericServiceException("JNDI lookup problem.", ne2);
            }
        }
        try {
            con = factory.createQueueConnection(userName, password);
            if (clientId != null && clientId.length() > 1) {
                con.setClientID(clientId);
            }
            con.start();
            QueueSession session = con.createQueueSession(false, 1);
            Queue queue = (Queue)jndi.lookup(queueName);
            QueueSender sender = session.createSender(queue);
            Message message = this.makeMessage((Session)session, modelService, context);
            sender.send(message);
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("Sent JMS Message to " + queueName), (String)module);
            }
            sender.close();
            session.close();
            con.close();
        }
        catch (NamingException ne) {
            throw new GenericServiceException("Problems with JNDI lookup.", ne);
        }
        catch (JMSException je) {
            throw new GenericServiceException("JMS Internal Error.", je);
        }
        return ServiceUtil.returnSuccess();
    }

    protected Map runXaQueue(ModelService modelService, Map context, Element server) throws GenericServiceException {
        String serverName = server.getAttribute("jndi-server-name");
        String jndiName = server.getAttribute("jndi-name");
        String queueName = server.getAttribute("topic-queue");
        String userName = server.getAttribute("username");
        String password = server.getAttribute("password");
        String clientId = server.getAttribute("client-id");
        InitialContext jndi = null;
        XAQueueConnectionFactory factory = null;
        XAQueueConnection con = null;
        try {
            jndi = JNDIContextFactory.getInitialContext((String)serverName);
            factory = (XAQueueConnectionFactory)jndi.lookup(jndiName);
        }
        catch (GeneralException ge) {
            throw new GenericServiceException("Problems getting JNDI InitialContext.", ge.getNested());
        }
        catch (NamingException ne) {
            JNDIContextFactory.clearInitialContext((String)serverName);
            try {
                jndi = JNDIContextFactory.getInitialContext((String)serverName);
                factory = (XAQueueConnectionFactory)jndi.lookup(jndiName);
            }
            catch (GeneralException ge2) {
                throw new GenericServiceException("Problems getting JNDI InitialContext.", ge2.getNested());
            }
            catch (NamingException ne2) {
                throw new GenericServiceException("JNDI lookup problems.", ne2);
            }
        }
        try {
            con = factory.createXAQueueConnection(userName, password);
            if (clientId != null && clientId.length() > 1) {
                con.setClientID(userName);
            }
            con.start();
            XAQueueSession session = con.createXAQueueSession();
            XAResource resource = session.getXAResource();
            if (TransactionUtil.getStatus() == 0) {
                TransactionUtil.enlistResource((XAResource)resource);
            }
            Queue queue = (Queue)jndi.lookup(queueName);
            QueueSession qSession = session.getQueueSession();
            QueueSender sender = qSession.createSender(queue);
            Message message = this.makeMessage((Session)session, modelService, context);
            sender.send(message);
            if (TransactionUtil.getStatus() != 0) {
                session.commit();
            }
            Debug.logInfo((String)"Message sent.", (String)module);
            sender.close();
            session.close();
            con.close();
        }
        catch (GenericTransactionException gte) {
            throw new GenericServiceException("Problems enlisting resource w/ transaction manager.", gte.getNested());
        }
        catch (NamingException ne) {
            throw new GenericServiceException("Problems with JNDI lookup.", ne);
        }
        catch (JMSException je) {
            throw new GenericServiceException("JMS Internal Error.", je);
        }
        return ServiceUtil.returnSuccess();
    }

    protected Map run(ModelService modelService, Map context) throws GenericServiceException {
        Element serviceElement = this.getServiceElement(modelService);
        List serverList = this.serverList(serviceElement);
        HashMap result = new HashMap();
        for (Element server : serverList) {
            String serverType = server.getAttribute("type");
            if (serverType.equals("topic")) {
                result.putAll(this.runTopic(modelService, context, server));
                continue;
            }
            if (serverType.equals("queue")) {
                result.putAll(this.runQueue(modelService, context, server));
                continue;
            }
            throw new GenericServiceException("Illegal server messaging type.");
        }
        return result;
    }

    public Map runSync(String localName, ModelService modelService, Map context) throws GenericServiceException {
        return this.run(modelService, context);
    }

    public void runSyncIgnore(String localName, ModelService modelService, Map context) throws GenericServiceException {
        this.run(modelService, context);
    }

    public void runAsync(String localName, ModelService modelService, Map context, GenericRequester requester, boolean persist) throws GenericServiceException {
        Map result = this.run(modelService, context);
        requester.receiveResult(result);
    }

    public void runAsync(String localName, ModelService modelService, Map context, boolean persist) throws GenericServiceException {
        this.run(modelService, context);
    }
}

