/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.jms;

import java.util.Map;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.serialize.XmlSerializer;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericDispatcher;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.LocalDispatcher;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.jms.GenericMessageListener;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.ObjectType;

public abstract class AbstractJmsListener
implements GenericMessageListener,
ExceptionListener {
    public static final String module = AbstractJmsListener.class.getName();
    protected LocalDispatcher dispatcher;
    protected boolean isConnected = false;

    protected AbstractJmsListener(ServiceDispatcher dispatcher) {
        DispatchContext dctx = new DispatchContext("JMSDispatcher", null, this.getClass().getClassLoader(), null);
        this.dispatcher = new GenericDispatcher(dctx, dispatcher);
    }

    protected Map runService(MapMessage message) {
        Map context = null;
        String serviceName = null;
        String xmlContext = null;
        try {
            serviceName = message.getString("serviceName");
            xmlContext = message.getString("serviceContext");
            if (serviceName == null || xmlContext == null) {
                Debug.logError((String)"Message received is not an OFB service message. Ignored!", (String)module);
                return null;
            }
            Object o = XmlSerializer.deserialize((String)xmlContext, (GenericDelegator)this.dispatcher.getDelegator());
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("De-Serialized Context --> " + o), (String)module);
            }
            if (ObjectType.instanceOf((Object)o, (String)"java.util.Map")) {
                context = (Map)o;
            }
        }
        catch (JMSException je) {
            Debug.logError((Throwable)je, (String)"Problems reading message.", (String)module);
        }
        catch (Exception e) {
            Debug.logError((Throwable)e, (String)"Problems deserializing the service context.", (String)module);
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("Running service: " + serviceName), (String)module);
        }
        Map result = null;
        if (context != null) {
            try {
                result = this.dispatcher.runSync(serviceName, context);
            }
            catch (GenericServiceException gse) {
                Debug.logError((Throwable)((Object)gse), (String)"Problems with service invocation.", (String)module);
            }
        }
        return result;
    }

    public void onMessage(Message message) {
        MapMessage mapMessage = null;
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("JMS Message Received --> " + message), (String)module);
        }
        if (!(message instanceof MapMessage)) {
            Debug.logError((String)"Received message is not a MapMessage!");
            return;
        }
        mapMessage = (MapMessage)message;
        this.runService(mapMessage);
    }

    public void onException(JMSException je) {
        this.setConnected(false);
        Debug.logError((Throwable)je, (String)"JMS connection exception", (String)module);
        while (!this.isConnected()) {
            try {
                this.refresh();
            }
            catch (GenericServiceException e) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void refresh() throws GenericServiceException {
        this.close();
        this.load();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    protected void setConnected(boolean connected) {
        this.isConnected = connected;
    }
}

