/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceHandler;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.security.Security;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.LocalDispatcher;
import org.ofbiz.core.service.ModelService;
import org.ofbiz.core.service.ModelServiceReader;
import org.ofbiz.core.service.config.ServiceConfigUtil;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;

public class DispatchContext
implements Serializable {
    public static final String module = DispatchContext.class.getName();
    protected static final String GLOBAL_KEY = "global.services";
    protected static UtilCache modelService = new UtilCache("service.ModelServices", 0L, 0L);
    protected transient LocalDispatcher dispatcher;
    protected ClassLoader loader;
    protected Collection readers;
    protected Map attributes;
    protected String name;

    public DispatchContext(String name, Collection readers, ClassLoader loader, LocalDispatcher dispatcher) {
        Map globalService;
        this.name = name;
        this.readers = readers;
        this.loader = loader;
        this.dispatcher = dispatcher;
        this.attributes = new HashMap();
        Map localService = this.addReaders(readers);
        if (localService != null) {
            modelService.put((Object)name, (Object)localService);
        }
        if ((globalService = this.addGlobal()) != null) {
            modelService.put((Object)GLOBAL_KEY, (Object)globalService);
        }
    }

    public Object getAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            return this.attributes.get(name);
        }
        return null;
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Collection getReaders() {
        return this.readers;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelService getModelService(String serviceName) throws GenericServiceException {
        Map serviceMap = (Map)modelService.get((Object)this.name);
        if (serviceMap == null) {
            DispatchContext dispatchContext = this;
            synchronized (dispatchContext) {
                serviceMap = (Map)modelService.get((Object)this.name);
                if (serviceMap == null && (serviceMap = this.addReaders(this.readers)) != null) {
                    modelService.put((Object)this.name, (Object)serviceMap);
                }
            }
        }
        ModelService retVal = null;
        if (serviceMap != null) {
            retVal = (ModelService)serviceMap.get(serviceName);
        }
        if (retVal == null) {
            retVal = this.getGlobalModelService(serviceName);
        }
        if (retVal != null && retVal.interfaceCheck()) {
            ModelService newModel = new ModelService(retVal);
            newModel.interfaceUpdate(this);
            return newModel;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelService getGlobalModelService(String serviceName) throws GenericServiceException {
        ModelService retVal;
        Map serviceMap = (Map)modelService.get((Object)GLOBAL_KEY);
        if (serviceMap == null) {
            DispatchContext dispatchContext = this;
            synchronized (dispatchContext) {
                serviceMap = (Map)modelService.get((Object)GLOBAL_KEY);
                if (serviceMap == null && (serviceMap = this.addGlobal()) != null) {
                    modelService.put((Object)GLOBAL_KEY, (Object)serviceMap);
                }
            }
        }
        if ((retVal = (ModelService)serviceMap.get(serviceName)) == null) {
            throw new GenericServiceException("Cannot locate service by name (" + serviceName + ")");
        }
        return retVal;
    }

    public LocalDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(LocalDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public GenericDelegator getDelegator() {
        return this.dispatcher.getDelegator();
    }

    public Security getSecurity() {
        return this.dispatcher.getSecurity();
    }

    private Map addReaders(Collection readerURLs) {
        HashMap serviceMap = new HashMap();
        if (readerURLs == null) {
            return null;
        }
        for (URL readerURL : readerURLs) {
            serviceMap.putAll(this.addReader(readerURL));
        }
        return serviceMap;
    }

    private Map addReader(URL readerURL) {
        if (readerURL == null) {
            Debug.logError((String)"Cannot add reader with a null reader URL");
            return null;
        }
        ModelServiceReader reader = ModelServiceReader.getModelServiceReader(readerURL);
        if (reader == null) {
            Debug.logError((String)("Could not load the reader for the reader URL " + readerURL));
            return null;
        }
        Map serviceMap = reader.getModelServices();
        return serviceMap;
    }

    private Map addReader(ResourceHandler handler) {
        ModelServiceReader reader = ModelServiceReader.getModelServiceReader(handler);
        if (reader == null) {
            Debug.logError((String)("Could not load the reader for " + handler));
            return null;
        }
        Map serviceMap = reader.getModelServices();
        return serviceMap;
    }

    private Map addGlobal() {
        HashMap globalMap = new HashMap();
        Element rootElement = null;
        try {
            rootElement = ServiceConfigUtil.getXmlRootElement();
        }
        catch (GenericConfigException e) {
            Debug.logError((Throwable)e, (String)"Error getting Service Engine XML root element");
            return null;
        }
        List globalServicesElements = UtilXml.childElementList((Element)rootElement, (String)"global-services");
        for (Element globalServicesElement : globalServicesElements) {
            ResourceHandler handler = new ResourceHandler("serviceengine.xml", globalServicesElement);
            Map servicesMap = this.addReader(handler);
            if (servicesMap == null) continue;
            globalMap.putAll(servicesMap);
        }
        return globalMap;
    }
}

