/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.util.BeanUtil;
import webwork.util.TextUtil;
import webwork.view.taglib.WebWorkBodyTagSupport;

public class BasicPropertyTag
extends WebWorkBodyTagSupport {
    protected static Log log = LogFactory.getLog(BasicPropertyTag.class);
    protected String valueAttr;
    protected Boolean escape;
    protected boolean hadBody;

    public void setValue(String inName) {
        this.valueAttr = inName;
    }

    public void setEscape(boolean inEscape) {
        this.escape = new Boolean(inEscape);
    }

    public int doStartTag() throws JspException {
        this.hadBody = false;
        Object value = this.findValue(this.valueAttr);
        this.getStack().pushValue(value);
        String id = this.getId();
        if (id != null && value != null) {
            this.pageContext.setAttribute(id, value);
            this.pageContext.setAttribute(id, value, 2);
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        if (this.bodyContent == null) {
            return 0;
        }
        String body = null;
        try {
            body = this.bodyContent.getString();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl = this.hadBody = body != null && body.length() != 0;
        if (this.hadBody) {
            try {
                if (this.shouldEscape()) {
                    body = TextUtil.escapeHTML(body);
                }
                this.bodyContent.getEnclosingWriter().write(body);
            }
            catch (IOException e) {
                throw new JspException("Could not show attribute " + this.valueAttr, (Throwable)e);
            }
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        Object value = this.getStack().popValue();
        if (!this.hadBody) {
            try {
                if (value != null && this.getId() == null) {
                    if (value instanceof Iterator) {
                        Iterator iter = (Iterator)value;
                        if (iter.hasNext()) {
                            if (this.shouldEscape()) {
                                this.pageContext.getOut().write(TextUtil.escapeHTML(BeanUtil.toStringValue(iter.next())));
                            } else {
                                this.pageContext.getOut().write(BeanUtil.toStringValue(iter.next()));
                            }
                        }
                    } else if (value instanceof char[]) {
                        if (this.shouldEscape()) {
                            this.pageContext.getOut().write(TextUtil.escapeHTML(String.valueOf((char[])value)));
                        } else {
                            this.pageContext.getOut().write(String.valueOf((char[])value));
                        }
                    } else if (this.shouldEscape()) {
                        this.pageContext.getOut().write(TextUtil.escapeHTML(BeanUtil.toStringValue(value)));
                    } else {
                        this.pageContext.getOut().write(BeanUtil.toStringValue(value));
                    }
                } else {
                    this.pageContext.getOut().write("");
                }
            }
            catch (Throwable t) {
                String msg = "Could not show value: " + this.valueAttr;
                throw new JspException(msg + ", throwable: " + t, t);
            }
        }
        super.doEndTag();
        return 6;
    }

    protected boolean shouldEscape() {
        if (this.escape == null) {
            return false;
        }
        return this.escape;
    }
}

