/*
 * Decompiled with CFR 0.152.
 */
package webwork.action;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.CommandDriven;
import webwork.action.IllegalArgumentAware;
import webwork.action.ResultException;
import webwork.util.InjectionUtils;
import webwork.util.editor.PropertyEditorException;

public class ActionSupport
implements Action,
Serializable,
IllegalArgumentAware {
    private static Log debugLog = LogFactory.getLog(ActionSupport.class);
    protected transient Log log = LogFactory.getLog(this.getClass());
    protected Map errorMap;
    protected Collection errorMessages;
    protected String command;
    private String actionName = null;

    public void addIllegalArgumentException(String fieldName, IllegalArgumentException e) {
        String msg = e.getMessage();
        if (e instanceof PropertyEditorException) {
            msg = this.getPropertyEditorMessage(fieldName, (PropertyEditorException)e);
        }
        this.addError(fieldName, msg);
    }

    protected String getPropertyEditorMessage(String fieldName, PropertyEditorException pe) {
        String bundleText = this.getText(pe.getBundleKey());
        Object[] propertyValues = pe.getPropertyValues();
        if (propertyValues == null) {
            return bundleText;
        }
        return MessageFormat.format(bundleText, propertyValues);
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean isCommand(String aName) {
        return this.command != null && this.command.equals(aName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        Object re;
        String result;
        long start;
        block12: {
            start = 0L;
            result = null;
            if (debugLog.isDebugEnabled()) {
                debugLog.debug((Object)"Action executing..");
                start = System.currentTimeMillis();
            }
            Object request = ActionContext.getContext().get("webwork.action.ServletContext.request");
            if (request != null && (re = (ResultException)((ServletRequest)request).getAttribute("webwork.action.ResultException")) != null) {
                ((ServletRequest)request).removeAttribute("webwork.action.ResultException");
                throw re;
            }
            if (this.command == null || this.command.length() <= 0 || !(this instanceof CommandDriven)) break block12;
            result = this.invokeCommand();
            re = result;
            if (debugLog.isDebugEnabled()) {
                debugLog.debug((Object)("Action execution done, returned " + result));
                debugLog.debug((Object)("Action executed in " + (System.currentTimeMillis() - start) + " ms"));
            }
            return re;
        }
        try {
            this.validate();
            result = this.doExecute();
            re = result;
        }
        catch (ResultException e) {
            String string;
            try {
                String msg = e.getMessage();
                if (msg != null) {
                    this.addErrorMessage(msg);
                }
                string = e.getResult();
            }
            catch (Throwable throwable) {
                if (debugLog.isDebugEnabled()) {
                    debugLog.debug((Object)("Action execution done, returned " + result));
                    debugLog.debug((Object)("Action executed in " + (System.currentTimeMillis() - start) + " ms"));
                }
                throw throwable;
            }
            if (debugLog.isDebugEnabled()) {
                debugLog.debug((Object)("Action execution done, returned " + result));
                debugLog.debug((Object)("Action executed in " + (System.currentTimeMillis() - start) + " ms"));
            }
            return string;
        }
        if (debugLog.isDebugEnabled()) {
            debugLog.debug((Object)("Action execution done, returned " + result));
            debugLog.debug((Object)("Action executed in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return re;
    }

    public String doDefault() throws Exception {
        return "input";
    }

    public Collection getErrorMessages() {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList();
        }
        return this.errorMessages;
    }

    public void setErrorMessages(Collection errorMessages) {
        this.errorMessages = errorMessages;
    }

    public boolean getHasErrorMessages() {
        return this.errorMessages == null ? false : this.errorMessages.size() > 0;
    }

    public void addErrorMessage(String anErrorMessage) {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList();
        }
        this.errorMessages.add(anErrorMessage);
    }

    public void addError(String fieldName, String errorMessage) {
        if (this.errorMap == null) {
            this.errorMap = new HashMap();
        }
        this.errorMap.put(fieldName, errorMessage);
    }

    public Map getErrors() {
        if (this.errorMap == null) {
            this.errorMap = new HashMap();
        }
        return this.errorMap;
    }

    public void setErrors(Map errorMap) {
        this.errorMap = errorMap;
    }

    public boolean getHasErrors() {
        return this.errorMap == null ? false : this.errorMap.size() > 0;
    }

    public Locale getLocale() {
        return ActionContext.getLocale();
    }

    public ResourceBundle getTexts(String aBundleName) {
        return ResourceBundle.getBundle(aBundleName, this.getLocale(), Thread.currentThread().getContextClassLoader());
    }

    public ResourceBundle getTexts() {
        return this.getTexts(this.getClass().getName());
    }

    public String getText(String aTextName) {
        Class<?> thisClass = this.getClass();
        while (true) {
            try {
                ResourceBundle bundle = this.getTexts(thisClass.getName());
                return bundle.getString(aTextName);
            }
            catch (MissingResourceException ex) {
                MissingResourceException e = ex;
                if (!(thisClass = thisClass.getSuperclass()).equals(Object.class)) continue;
                throw e;
            }
            break;
        }
    }

    protected String doExecute() throws Exception {
        return "success";
    }

    protected void doValidation() {
    }

    protected void validate() throws ResultException {
        this.doValidation();
        if (this.invalidInput()) {
            throw new ResultException("input");
        }
    }

    public boolean invalidInput() {
        return this.getHasErrorMessages() || this.getHasErrors();
    }

    protected String invokeCommand() throws Exception {
        Method method;
        StringBuffer sb = new StringBuffer("do");
        sb.append(this.command);
        sb.setCharAt(2, Character.toUpperCase(sb.charAt(2)));
        String cmd = sb.toString();
        debugLog.debug((Object)("Executing action with command=" + this.command + " (mapped to method: " + cmd + ")"));
        try {
            method = this.getClass().getMethod(cmd, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No command '" + this.command + "' in action");
        }
        try {
            return (String)InjectionUtils.invoke(method, this, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.log = LogFactory.getLog(this.getClass());
    }

    protected String getActionName() {
        if (this.actionName == null) {
            String classname = this.getClass().getName();
            this.actionName = classname.substring(classname.lastIndexOf(46) + 1);
        }
        return this.actionName;
    }

    public TimeZone getTimezone() {
        return null;
    }
}

