/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.schema;

import electric.util.Value;
import electric.util.java.JavaSource;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.reflect.Reflect;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.accessors.UnboundAccessor;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaEntry;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import electric.xml.io.simple.AnyType;
import java.io.IOException;

public final class SchemaAttribute
extends SchemaEntry {
    private String use;
    private String value;
    private boolean qualify;

    public SchemaAttribute(Type parentType, Element schema) throws SchemaException {
        super(parentType);
        this.readSchema(schema);
    }

    public SchemaAttribute(Schema schemaObject, Element schemaElement) throws SchemaException {
        super(schemaObject);
        this.readSchema(schemaElement);
    }

    public String getJavaName() throws SchemaException {
        return this.getType().getJavaName();
    }

    public Class getJavaClass() throws SchemaException {
        return this.getType().getJavaClass();
    }

    public void writeJava(JavaSource source) throws SchemaException {
        this.accessor.writeJava(source);
    }

    public void readSchema(Element schema) throws SchemaException {
        this.name = schema.getAttributeValue("name");
        this.setType(schema);
        this.use = schema.getAttributeValue("use");
        this.value = schema.getAttributeValue("value");
        String form = schema.getAttributeValue("form");
        this.qualify = form == null ? this.getSchema().getQualifyAttributes() : form.equals("qualified");
        this.accessor = new UnboundAccessor(this, this.name, schema);
    }

    private void setType(Element schema) throws SchemaException {
        this.typeQName = schema.getAttributeValue("type");
        if (this.typeQName != null) {
            this.typeQName = schema.getQName(this.typeQName);
            return;
        }
        this.refQName = schema.getAttributeValue("ref");
        if (this.refQName != null) {
            if (this.name == null) {
                this.name = Element.getParts(this.refQName)[1];
            }
            this.refQName = schema.getQName(this.refQName);
            return;
        }
        if (!schema.hasElement("simpleType")) {
            this.type = new AnyType();
            return;
        }
        Element anonymousElement = schema.getElement("simpleType");
        this.type = this.schema.getNamespaces().getTypeWithSchema(this.schema.getTargetNamespace(), this.name + SchemaEntry.ANONYMOUS_SUFFIX, anonymousElement);
        this.type.setAnonymous(true);
        this.schema.addSchemaType(this.type);
    }

    public void writeSchema(Element schema, boolean annotated) throws SchemaException {
        this.appendImport(schema);
        String xsdPrefix = schema.getPrefix(SchemaProperties.getDefaultSchema(), "xsd");
        Element attribute = schema.addElement(xsdPrefix, "attribute");
        attribute.setAttribute("name", this.name);
        if (this.use != null) {
            attribute.setAttribute("use", this.use);
        }
        if (this.value != null) {
            attribute.setAttribute("value", this.value);
        }
        if (annotated) {
            this.accessor.annotateSchema(attribute);
        }
        if (this.qualify != this.getSchema().getQualifyAttributes()) {
            attribute.setAttribute("form", this.qualify ? "qualified" : "unqualified");
        }
        attribute.setAttribute("type", this.getType().getName(attribute));
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        try {
            Object field = this.accessor.get(object);
            String prefix = null;
            if (this.qualify) {
                prefix = writer.getElement().getPrefix(this.getNamespace());
            }
            if (field != null) {
                writer.writeAttribute(prefix, this.name, field.toString());
            }
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new IOException(exception.toString());
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        try {
            Class javaClass = this.getJavaClass();
            if (javaClass == null) {
                throw new IOException(this.getType().getQName() + " has no mapping to a java class");
            }
            String string = reader.readAttributeValue(this.name);
            if (string != null) {
                Value field = new Value(Reflect.valueOf(string, javaClass));
                this.accessor.set(value, field);
            }
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new IOException(exception.toString());
        }
    }
}

