/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.canonical;

import electric.util.comparators.IComparator;
import electric.xml.Attribute;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.IXMLConstants;
import electric.xml.IXPath;
import electric.xml.IXPathConstants;
import electric.xml.IXPathFactory;
import electric.xml.Node;
import electric.xml.Nodes;
import electric.xml.Text;
import electric.xml.XPath;
import electric.xml.canonical.CanonicalizationException;
import electric.xml.canonical.Canonicalizer;
import electric.xml.canonical.NamespaceComparator;
import electric.xml.canonical.NodeComparator;
import electric.xml.canonical.NodeUtil;
import electric.xml.xpath.NodeSet;
import electric.xml.xpath.XPathNamespace;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Stack;

public class ExclusiveCanonicalizer
extends Canonicalizer
implements IXMLConstants,
IXPathConstants {
    private static IXPathFactory xpathFactory = XPath.getFactory(1);
    public static final String UTF8 = "UTF8";
    protected Writer writer;
    protected Hashtable prefixList;

    protected static boolean visiblyUtilizes(Element e, String P, String V, NodeSet nodeSet) throws Exception {
        if (e == null || P == null || nodeSet == null) {
            return false;
        }
        if (e.getPrefix() != null && e.getPrefix().equals(P)) {
            return true;
        }
        if (e.getPrefix() == null && P.equals("xmlns")) {
            return true;
        }
        String xmlAttr = "./attribute::*[namespace-uri()!=\"http://www.w3.org/2000/xmlns/\"]";
        IXPath attrPath = xpathFactory.newXPath(xmlAttr, null);
        attrPath.setNamespace("xml", "http://www.w3.org/XML/1998/namespace/");
        Nodes attrNodes = attrPath.getNodes(e);
        boolean vis = false;
        while (attrNodes.hasMoreElements()) {
            Attribute ni = (Attribute)attrNodes.nextElement();
            if (ni.getPrefix() == null || !ni.getPrefix().equals(P) || !nodeSet.contains(ni)) continue;
            vis = true;
            break;
        }
        return vis;
    }

    protected void writeText(Text root, NodeSet nodeSet, Stack state, boolean writeNode) throws Exception {
        String nodeValue = root.getNodeValue();
        if (writeNode) {
            this.writer.write(nodeValue);
        }
    }

    protected void writeNamespace(XPathNamespace root, NodeSet nodeSet, Stack state, boolean writeNode) throws Exception {
        Element e;
        String uri;
        Hashtable ns_rendered = (Hashtable)state.peek();
        String name = root.getPrefix();
        String value = root.getNamespaceURI();
        if (name.equals("xml") && value.equals("http://www.w3.org/XML/1998/namespace")) {
            writeNode = false;
        }
        if ((uri = (String)ns_rendered.get(root.getPrefix())) != null && uri.equals(root.getNamespaceURI())) {
            writeNode = false;
        }
        if (!ExclusiveCanonicalizer.visiblyUtilizes(e = root.getOwnerElement(), root.getPrefix(), root.getNamespaceURI(), nodeSet)) {
            writeNode = false;
        }
        Node parent = root.getOwnerElement();
        if ((parent = (Node)parent.getParentNode()) != null) {
            parent = (Node)parent.getParentNode();
        }
        while (parent != null && !nodeSet.contains(parent)) {
            parent = (Node)parent.getParentNode();
        }
        if (parent != null && nodeSet.contains(parent)) {
            IXPath namespaceXPath = xpathFactory.newXPath("./namespace::*", null);
            Nodes namespaceNodes = namespaceXPath.getNodes(parent);
            while (namespaceNodes.hasMoreElements()) {
                XPathNamespace namespacei = (XPathNamespace)namespaceNodes.nextElement();
                if (!namespacei.getPrefix().equals(root.getPrefix()) || !namespacei.getNamespaceURI().equals(root.getNamespaceURI())) continue;
                String puri = (String)ns_rendered.get(root.getPrefix());
                if (puri == null) break;
                writeNode = false;
                break;
            }
        }
        if (writeNode) {
            ns_rendered.put(name, value);
            this.writeNamespaceNode(name, value);
        }
    }

    protected void writeNamespaceNode(String name, String value) throws IOException {
        this.writer.write(" xmlns");
        if (!name.equals("xmlns")) {
            this.writer.write(58);
            this.writer.write(name);
        }
        this.writer.write(61);
        this.writer.write(34);
        this.writer.write(value);
        this.writer.write(34);
    }

    protected void writeAttribute(Attribute root, NodeSet nodeSet, Stack state, boolean writeNode) throws Exception {
        if (writeNode) {
            this.writer.write(32);
            this.writer.write(root.getNodeName());
            this.writer.write(61);
            this.writer.write(34);
            this.writer.write(root.getNodeValue());
            this.writer.write(34);
        }
    }

    protected void writeDocument(Document document, NodeSet nodeSet, Stack state, boolean writeNode) throws Exception {
        this.write(document.getRoot(), nodeSet, state);
    }

    protected void writeElement(Element element, NodeSet nodeSet, Stack state, boolean writeNode) throws Exception {
        if (writeNode) {
            this.writer.write(60);
            this.writer.write(element.getNodeName());
        }
        this.processElementNamespaces(this.writer, element, nodeSet, state);
        this.processElementAttributes(this.writer, element, nodeSet, state);
        if (writeNode) {
            this.writer.write(62);
        }
        this.processElementChildren(this.writer, element, nodeSet, state);
        if (writeNode) {
            this.writer.write(60);
            this.writer.write(47);
            this.writer.write(element.getNodeName());
            this.writer.write(62);
        }
    }

    private void processElementChildren(Writer writer, Element element, NodeSet nodeSet, Stack state) throws Exception {
        Hashtable ns_rendered = (Hashtable)state.peek();
        IXPath childrenXPath = xpathFactory.newXPath("./child::node()", null);
        Nodes childrenNodes = childrenXPath.getNodes(element);
        while (childrenNodes.hasMoreElements()) {
            Hashtable new_ns_rendered = (Hashtable)ns_rendered.clone();
            state.push(new_ns_rendered);
            Node child = (Node)childrenNodes.nextElement();
            this.write(child, nodeSet, state);
            state.pop();
        }
    }

    private void processElementAttributes(Writer writer, Element element, NodeSet nodeSet, Stack state) throws Exception {
        String attrPath = "./attribute::*";
        IXPath attributeXPath = xpathFactory.newXPath(attrPath, null);
        Nodes attributeNodes = attributeXPath.getNodes(element);
        Nodes sortedAttributeNodes = NodeUtil.sortNodes(attributeNodes, (IComparator)new NodeComparator());
        while (sortedAttributeNodes.hasMoreElements()) {
            Attribute attr = (Attribute)sortedAttributeNodes.nextElement();
            String namespaceURI = attr.getNamespaceURI();
            if (namespaceURI != null && namespaceURI.equals("http://www.w3.org/2000/xmlns/")) continue;
            this.write(attr, nodeSet, state);
        }
    }

    private void processElementNamespaces(Writer writer, Element element, NodeSet nodeSet, Stack state) throws Exception {
        IXPath namespaceXPath = xpathFactory.newXPath("./namespace::*", null);
        Nodes namespaceNodes = namespaceXPath.getNodes(element);
        Nodes sortedNamespaceNodes = NodeUtil.sortNodes(namespaceNodes, (IComparator)new NamespaceComparator());
        while (sortedNamespaceNodes.hasMoreElements()) {
            XPathNamespace namespace = (XPathNamespace)sortedNamespaceNodes.nextElement();
            this.write(namespace, nodeSet, state);
        }
    }

    public synchronized void canonicalize(NodeSet nodeSet, Node root, OutputStream output) throws CanonicalizationException {
        try {
            this.writer = new OutputStreamWriter(output, UTF8);
            this.prefixList = new Hashtable();
            NodeSet newNodeSet = new NodeSet(nodeSet);
            Stack state = new Stack();
            Hashtable ns_rendered = new Hashtable();
            state.push(ns_rendered);
            this.write(root, newNodeSet, state);
            this.writer.flush();
        }
        catch (Exception exception) {
            throw new CanonicalizationException("ExclusiveCanonicalization problem", exception);
        }
    }
}

