/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb.server;

import electric.util.array.ArrayUtil;
import electric.util.log.Log;
import electric.xdb.IXDBConstants;
import electric.xdb.Id;
import electric.xdb.server.GetMissingData;
import electric.xdb.server.GetSyncInfo;
import electric.xdb.server.Member;
import electric.xdb.server.SyncInfo;
import electric.xdb.server.XDBServer;
import java.util.HashSet;
import java.util.Vector;

class SyncWithServers
implements IXDBConstants {
    private XDBServer server;
    private int countdown;

    public SyncWithServers(XDBServer server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void start() {
        Member[] members = this.server.getMembers();
        GetSyncInfo[] commands = new GetSyncInfo[]{};
        int i = 0;
        while (i < members.length) {
            Member member = members[i];
            if (member.isOnline()) {
                ++this.countdown;
                GetSyncInfo command = new GetSyncInfo(this, member);
                command.start();
                commands = (GetSyncInfo[])ArrayUtil.addElement(commands, command);
            }
            ++i;
        }
        SyncWithServers syncWithServers = this;
        // MONITORENTER : syncWithServers
        while (this.countdown > 0) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        // MONITOREXIT : syncWithServers
        HashSet<Id> set = new HashSet<Id>();
        GetMissingData[] commands2 = new GetMissingData[commands.length];
        int i2 = 0;
        while (i2 < commands.length) {
            GetSyncInfo command = commands[i2];
            SyncInfo syncInfo = command.getSyncInfo();
            if (syncInfo != null) {
                Id[] ids = syncInfo.getIds();
                if (ids == null) {
                    command.getMember().setLastSyncedTag(command.getSyncInfo().getLastTag());
                } else if ((ids = this.server.getMissingIds(ids)) == null) {
                    command.getMember().setLastSyncedTag(command.getSyncInfo().getLastTag());
                } else {
                    Vector<Id> vector = new Vector<Id>();
                    int j = 0;
                    while (j < ids.length) {
                        if (!set.contains(ids[j])) {
                            vector.addElement(ids[j]);
                            set.add(ids[j]);
                        }
                        ++j;
                    }
                    if (vector.isEmpty()) {
                        command.getMember().setLastSyncedTag(command.getSyncInfo().getLastTag());
                    } else {
                        Object[] array = new Id[vector.size()];
                        vector.copyInto(array);
                        commands2[i2] = new GetMissingData(this, command, (Id[])array);
                    }
                }
            }
            ++i2;
        }
        this.countdown = 0;
        int i3 = 0;
        while (i3 < commands2.length) {
            if (commands2[i3] != null) {
                ++this.countdown;
                commands2[i3].start();
            }
            ++i3;
        }
        SyncWithServers syncWithServers2 = this;
        // MONITORENTER : syncWithServers2
        while (this.countdown > 0) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        // MONITOREXIT : syncWithServers2
        if (!Log.isLogging(IXDBConstants.XDB_SYNC_EVENT)) return;
        Log.log(IXDBConstants.XDB_SYNC_EVENT, (Object)("synced: groupName=" + this.server.getGroup() + ", groupSize=" + this.server.getGroupSize() + ", dataCount=" + this.server.getDataCount()));
    }

    public XDBServer getServer() {
        return this.server;
    }

    public synchronized void finished() {
        --this.countdown;
        this.notify();
    }
}

