/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb.server;

import electric.xdb.server.JoinInfo;
import electric.xdb.server.JoinServer;
import electric.xdb.server.XDBServer;

class JoinServers {
    private XDBServer server;
    private String[] urls;
    private int countdown;

    public JoinServers(XDBServer server, String[] urls) {
        this.server = server;
        this.urls = urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        JoinInfo localInfo = new JoinInfo(this.server.getName(), this.server.getURL());
        int i = 0;
        while (i < this.urls.length) {
            ++this.countdown;
            new JoinServer(this, this.urls[i], localInfo).start();
            ++i;
        }
        JoinServers joinServers = this;
        synchronized (joinServers) {
            while (this.countdown > 0) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public XDBServer getServer() {
        return this.server;
    }

    public synchronized void finished() {
        --this.countdown;
        this.notify();
    }
}

