/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl.util;

import electric.glue.context.ServiceContext;
import electric.service.descriptor.MethodDescriptor;
import electric.soap.wsdl.SOAPBinding;
import electric.soap.wsdl.SOAPOperation;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.comparators.AscendingStringComparator;
import electric.util.comparators.IComparator;
import electric.util.reflect.Reflect;
import electric.util.sorting.BubbleSort;
import electric.wsdl.Operation;
import electric.wsdl.Part;
import electric.wsdl.WSDL;
import electric.wsdl.generator.WSDLGenerator;
import electric.wsdl.loader.WSDLLoader;
import java.lang.reflect.Method;

public class SignatureGenerator {
    private static IComparator comparator = new AscendingStringComparator();
    static /* synthetic */ Class class$electric$soap$wsdl$SOAPBinding;
    static /* synthetic */ Class class$java$lang$Object;

    public static void main(String[] args) throws Exception {
        String url = args[0];
        WSDL wsdl = WSDLLoader.getWSDL(url);
        String signature = SignatureGenerator.getSignature(wsdl);
        System.out.println("signature = " + signature);
    }

    public static synchronized String getSignature(WSDL wsdl) {
        String tModel = wsdl.getTModel();
        if (tModel != null) {
            return tModel;
        }
        SOAPBinding binding = (SOAPBinding)wsdl.getBindings(class$electric$soap$wsdl$SOAPBinding == null ? (class$electric$soap$wsdl$SOAPBinding = SignatureGenerator.class$("electric.soap.wsdl.SOAPBinding")) : class$electric$soap$wsdl$SOAPBinding)[0];
        SOAPOperation[] operations = binding.getSOAPOperations();
        Object[] signatures = new String[]{};
        int i = 0;
        while (i < operations.length) {
            signatures = (String[])ArrayUtil.addElement(signatures, SignatureGenerator.getSignature(operations[i]));
            ++i;
        }
        BubbleSort.sort(signatures, comparator);
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < signatures.length) {
            buffer.append((String)signatures[i2]);
            ++i2;
        }
        String string = buffer.toString();
        int length = string.length() / 4;
        String part1 = SignatureGenerator.toHex(string.substring(0, length));
        String part2 = SignatureGenerator.toHex(string.substring(length, length * 2));
        String part3 = SignatureGenerator.toHex(string.substring(length * 2, length * 3));
        String part4 = SignatureGenerator.toHex(string.substring(length * 3, length * 4));
        tModel = part1 + "-" + part2.substring(0, 4) + "-" + part2.substring(4) + "-" + part3.substring(0, 4) + "-" + part3.substring(4) + part4;
        wsdl.setTModel(tModel);
        return tModel;
    }

    public static String getSignature(Class type) {
        return SignatureGenerator.getSignature(new Class[]{type}, new Context());
    }

    public static String getDocLitSignature(Class type) {
        ServiceContext context = new ServiceContext();
        context.setDocumentStyle();
        return SignatureGenerator.getSignature(new Class[]{type}, context);
    }

    public static String getSignature(Class[] interfaces, Context context) {
        Method[] methods = new Method[]{};
        int i = 0;
        while (i < interfaces.length) {
            Method[] array = interfaces[i].getMethods();
            methods = (Method[])ArrayUtil.addElements(methods, array);
            ++i;
        }
        methods = Reflect.getMethodsNotImplementedBy(methods, new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = SignatureGenerator.class$("java.lang.Object")) : class$java$lang$Object});
        XURL[] endpoints = new XURL[]{};
        try {
            MethodDescriptor[] descriptors = new MethodDescriptor[methods.length];
            int i2 = 0;
            while (i2 < methods.length) {
                descriptors[i2] = new MethodDescriptor(methods[i2]);
                ++i2;
            }
            WSDL wsdl = WSDLGenerator.getWSDL(endpoints, "no-description", context, descriptors, interfaces[0]);
            return SignatureGenerator.getSignature(wsdl);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String toHex(String string) {
        if ((string = Integer.toString(Math.abs(SignatureGenerator.hashCode(string)), 16).toUpperCase()).length() < 8) {
            string = "00000000".substring(0, 8 - string.length()) + string;
        }
        return string;
    }

    private static int hashCode(String string) {
        int hash = 0;
        int length = string.length();
        int i = 0;
        while (i < length) {
            hash = 31 * hash + string.charAt(i);
            ++i;
        }
        return hash;
    }

    private static String getSignature(SOAPOperation soapOperation) {
        Operation operation = soapOperation.getOperation();
        StringBuffer buffer = new StringBuffer();
        buffer.append(operation.getName());
        boolean rpc = soapOperation.isRPC();
        int i = 0;
        while (i < operation.getInput().getMessage().getPartCount()) {
            Part part = operation.getInput().getMessage().getPart(i);
            if (rpc) {
                buffer.append("_I" + part.getType().getQName());
            } else {
                buffer.append("_I" + part.getSchemaElement().getName());
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < operation.getOutput().getMessage().getPartCount()) {
            Part part = operation.getOutput().getMessage().getPart(i2);
            if (rpc) {
                buffer.append("_O" + part.getType().getQName());
            } else {
                buffer.append("_O" + part.getSchemaElement().getName());
            }
            ++i2;
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

