/*
 * Decompiled with CFR 0.152.
 */
package electric.util.resourceloader;

import electric.util.Context;
import electric.util.XURL;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.resourceloader.IResourceLoader;
import electric.util.resourceloader.file.FileResourceLoader;
import electric.util.resourceloader.url.URLResourceLoader;
import java.io.IOException;
import java.util.Hashtable;

public class ResourceLoaders
implements ILoggingConstants {
    private static final Context EMPTY_CONTEXT = new Context();
    private static final FileResourceLoader fileResourceLoader = new FileResourceLoader();
    private static final Hashtable loaders = new Hashtable();
    private static final URLResourceLoader defaultLoader = new URLResourceLoader();

    public static void addResourceLoader(String protocol, IResourceLoader loader) {
        loaders.put(protocol, loader);
    }

    public static IResourceLoader getResourceLoader(String protocol) {
        IResourceLoader loader = (IResourceLoader)loaders.get(protocol);
        if (loader == null) {
            loader = defaultLoader;
        }
        return loader;
    }

    public static FileResourceLoader getFileResourceLoader() {
        return fileResourceLoader;
    }

    public static byte[] loadResource(String path) throws IOException {
        return ResourceLoaders.loadResource(path, EMPTY_CONTEXT);
    }

    public static byte[] loadResource(String path, Context context) throws IOException {
        if (Log.isLogging(ILoggingConstants.RESOURCES_EVENT)) {
            Log.log(ILoggingConstants.RESOURCES_EVENT, (Object)("trying to load: " + path));
        }
        if (!XURL.hasProtocol(path)) {
            path = "file:/" + path;
        }
        XURL xurl = new XURL(path);
        IResourceLoader loader = ResourceLoaders.getLoader(xurl);
        byte[] resource = loader.loadResource(path, context);
        if (Log.isLogging(ILoggingConstants.RESOURCES_EVENT)) {
            Log.log(ILoggingConstants.RESOURCES_EVENT, (Object)("success loading: " + path));
        }
        return resource;
    }

    private static IResourceLoader getLoader(XURL xurl) {
        IResourceLoader loader = (IResourceLoader)loaders.get(xurl.getProtocol());
        return loader != null ? loader : defaultLoader;
    }

    static {
        ResourceLoaders.addResourceLoader("file", fileResourceLoader);
    }
}

