/*
 * Decompiled with CFR 0.152.
 */
package electric.util.io;

import electric.util.encoding.XMLEncodings;
import electric.util.log.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public final class Streams {
    private static final int CHUNK_SIZE = 10000;
    private static final byte[] NO_BYTES = new byte[0];

    public static Reader getReader(File file) throws IOException {
        FileInputStream input = new FileInputStream(file);
        byte[] header = Streams.readUpTo((InputStream)input, 100);
        input.close();
        String encoding = XMLEncodings.getJavaEncoding(header);
        return new InputStreamReader((InputStream)new FileInputStream(file), encoding);
    }

    public static Reader getReader(InputStream input) throws IOException {
        if (!(input instanceof BufferedInputStream)) {
            input = new BufferedInputStream(input);
        }
        input.mark(100);
        byte[] header = Streams.readUpTo(input, 100);
        input.reset();
        String encoding = XMLEncodings.getJavaEncoding(header);
        return new InputStreamReader(input, encoding);
    }

    public static Writer getWriter(File file, String encoding) throws IOException, UnsupportedEncodingException {
        return Streams.getWriter(new FileOutputStream(file), encoding);
    }

    public static Writer getWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        encoding = XMLEncodings.getJavaEncoding(encoding);
        return new OutputStreamWriter(output, encoding);
    }

    public static byte[] readFully(File file) throws IOException {
        RandomAccessFile input = new RandomAccessFile(file, "r");
        byte[] bytes = new byte[(int)input.length()];
        input.readFully(bytes);
        input.close();
        return bytes;
    }

    public static void readFully(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        Streams.readFully(input, buffer, offset, length, -1L);
    }

    public static void readFully(InputStream input, byte[] buffer, int offset, int length, long logMask) throws IOException {
        int total = 0;
        while (total < length) {
            int amount = input.read(buffer, offset + total, length - total);
            if (amount < 0) {
                throw new EOFException("expected " + length + " bytes of content, got " + total);
            }
            if (logMask > -1L && Log.isLogging(logMask)) {
                Log.log(logMask, (Object)new String(buffer, offset + total, amount));
            }
            total += amount;
        }
    }

    public static byte[] readFully(InputStream input, int length) throws IOException {
        return Streams.readFully(input, length, -1L);
    }

    public static byte[] readFully(InputStream input, int length, long logMask) throws IOException {
        if (length == -1) {
            return Streams.readFully(input, logMask);
        }
        if (length == 0) {
            return NO_BYTES;
        }
        byte[] buffer = new byte[length];
        Streams.readFully(input, buffer, 0, length, logMask);
        return buffer;
    }

    public static byte[] readFully(InputStream input) throws IOException {
        return Streams.readFully(input, -1L);
    }

    public static byte[] readFully(InputStream input, long logMask) throws IOException {
        int count;
        byte[] buffer = new byte[10000];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((count = input.read(buffer, 0, buffer.length)) != -1) {
            output.write(buffer, 0, count);
        }
        buffer = output.toByteArray();
        if (logMask > -1L && Log.isLogging(logMask)) {
            Log.log(logMask, (Object)new String(buffer));
        }
        return buffer;
    }

    public static int readUpTo(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        int total = 0;
        while (total < length) {
            int amount = input.read(buffer, offset + total, length - total);
            if (amount < 0) break;
            total += amount;
        }
        return total;
    }

    public static byte[] readUpTo(InputStream input, int length) throws IOException {
        if (length <= 0) {
            return NO_BYTES;
        }
        byte[] buffer = new byte[length];
        int total = Streams.readUpTo(input, buffer, 0, length);
        if (total < length) {
            byte[] tmp = buffer;
            buffer = new byte[total];
            System.arraycopy(tmp, 0, buffer, 0, total);
        }
        return buffer;
    }

    public static byte[] readUpTo(InputStream input, byte[] delimeter) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Streams.copy(input, (OutputStream)output, delimeter, -1L);
        return output.toByteArray();
    }

    public static String readLine(InputStream input) throws IOException {
        return Streams.readLine(input, XMLEncodings.getSystemEncoding());
    }

    public static String readLine(InputStream input, String encoding) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(100);
        boolean curPos = false;
        int ch;
        while ((ch = input.read()) != -1) {
            if (ch == 13) {
                ch = input.read();
                if (ch == 10) {
                    return new String(buffer.toByteArray(), encoding);
                }
                buffer.write(13);
                buffer.write(ch);
                continue;
            }
            if (ch == 10) {
                return new String(buffer.toByteArray(), encoding);
            }
            buffer.write(ch);
        }
        return !curPos ? null : new String(buffer.toByteArray(), encoding);
    }

    public static void copy(InputStream input, OutputStream output, int length, int buffersize, long logMask) throws IOException {
        int chunksize;
        int readBytes;
        byte[] buffer = new byte[length == -1 ? buffersize : Math.min(buffersize, length)];
        int total = 0;
        while ((readBytes = Streams.readUpTo(input, buffer, 0, chunksize = length == -1 ? buffersize : Math.min(buffersize, length - total))) != 0) {
            if (logMask > -1L && Log.isLogging(logMask)) {
                Log.log(logMask, (Object)new String(buffer, 0, readBytes));
            }
            output.write(buffer, 0, readBytes);
            if (length == -1 || (total += readBytes) < length) continue;
            break;
        }
    }

    public static void copy(InputStream input, OutputStream output, int length, int buffersize) throws IOException {
        Streams.copy(input, output, length, buffersize, -1L);
    }

    public static void copy(InputStream input, OutputStream output, byte[] delimiter, long logMask) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(output);
        byte firstByte = delimiter[0];
        block0: while (true) {
            int ch;
            if ((ch = input.read()) != firstByte) {
                writer.write(ch);
                continue;
            }
            int i = 1;
            while (i < delimiter.length) {
                ch = input.read();
                if (ch != delimiter[i]) {
                    int j = 0;
                    while (j < i) {
                        writer.write(delimiter[j]);
                        ++j;
                    }
                    writer.write(ch);
                    continue block0;
                }
                ++i;
            }
            break;
        }
        writer.flush();
    }
}

