/*
 * Decompiled with CFR 0.152.
 */
package electric.util.io;

import electric.util.io.ISource;
import electric.util.io.Streams;
import electric.util.log.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamSource
implements ISource {
    private static int BUFFER_SIZE = 2048;
    private InputStream input;
    private int length;
    private byte[] firstChunk;
    private int firstChunkLength;
    private boolean canResend = true;
    private long logMask;

    public StreamSource(InputStream input, int length, long logMask) {
        this.input = input;
        this.length = length;
        this.logMask = logMask;
    }

    public void write(OutputStream output) throws IOException {
        if (this.firstChunk == null) {
            try {
                this.firstChunk = new byte[BUFFER_SIZE];
                this.firstChunkLength = Streams.readUpTo(this.input, this.firstChunk, 0, this.firstChunk.length);
            }
            catch (IOException exception) {
                // empty catch block
            }
        }
        if (Log.isLogging(this.logMask)) {
            Log.log(this.logMask, (Object)new String(this.firstChunk, 0, this.firstChunkLength));
        }
        output.write(this.firstChunk, 0, this.firstChunkLength);
        output.flush();
        int remainingBytes = this.length - this.firstChunkLength;
        if (remainingBytes > 0) {
            this.canResend = false;
            Streams.copy(this.input, output, remainingBytes, BUFFER_SIZE, this.logMask);
        }
    }

    public boolean canResend() {
        return this.canResend;
    }

    public int getLength() {
        return this.length;
    }

    public static void setBufferSize(int bufferSize) {
        BUFFER_SIZE = bufferSize;
    }

    public static int getBufferSize() {
        return BUFFER_SIZE;
    }
}

