/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Authorization;
import electric.uddi.Category;
import electric.uddi.IInquiryCommand;
import electric.uddi.ISubscriptionFilter;
import electric.uddi.IUDDIServer;
import electric.uddi.Identifier;
import electric.uddi.Name;
import electric.uddi.Qualifier;
import electric.uddi.TModel;
import electric.uddi.TModelInfo;
import electric.uddi.TModelInfos;
import electric.uddi.UDDIException;
import electric.uddi.selectors.AndSelector;
import electric.uddi.selectors.CategorySelector;
import electric.uddi.selectors.ISelector;
import electric.uddi.selectors.IdentifierSelector;
import electric.uddi.selectors.NameSelector;
import electric.uddi.selectors.OrSelector;
import electric.uddi.util.UDDIUtil;
import electric.util.array.ArrayUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;
import java.util.Enumeration;

public final class FindTModels
implements IInquiryCommand,
ISubscriptionFilter {
    private String name;
    private Identifier[] identifiers;
    private Category[] categories;
    private Qualifier qualifier = Qualifier.DEFAULT;
    private transient AndSelector selector;

    public FindTModels() {
    }

    public FindTModels(String name, Identifier[] identifiers, Category[] categories, Qualifier qualifier) {
        this.name = name;
        this.identifiers = identifiers;
        this.categories = categories;
        this.qualifier = qualifier != null ? qualifier : Qualifier.DEFAULT;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Identifier[] getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(Identifier[] identifiers) {
        this.identifiers = identifiers;
    }

    public Category[] getCategories() {
        return this.categories;
    }

    public void setCategories(Category[] categories) {
        this.categories = categories;
    }

    public Qualifier getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(Qualifier qualifier) {
        this.qualifier = qualifier;
    }

    public String getVersion() {
        int count = 0;
        if (this.name != null) {
            ++count;
        }
        if (this.identifiers != null) {
            ++count;
        }
        if (this.categories != null) {
            ++count;
        }
        return count > 1 ? "2.0" : "1.0";
    }

    public boolean needsAuthorization() {
        return false;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        ISelector selector = this.getSelector();
        try {
            TModelInfo[] matches = new TModelInfo[]{};
            Enumeration enumeration = server.getTModels();
            while (enumeration.hasMoreElements()) {
                TModel tModel = (TModel)enumeration.nextElement();
                if (tModel.isHidden() || !selector.selects(server, tModel)) continue;
                matches = (TModelInfo[])ArrayUtil.addElement(matches, new TModelInfo(tModel));
            }
            return new TModelInfos(matches, false);
        }
        catch (UDDIException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new UDDIException(exception.toString());
        }
    }

    public synchronized ISelector getSelector() {
        int i;
        if (this.selector != null) {
            return this.selector;
        }
        this.selector = new AndSelector();
        if (this.name != null) {
            this.selector.addSelector(new NameSelector(new Name(this.name), this.qualifier));
        }
        if (this.identifiers != null && this.identifiers.length > 0) {
            ISelector identifiersSelector;
            if (this.qualifier.getComparisonStrategy() == 1) {
                identifiersSelector = new AndSelector();
                i = 0;
                while (i < this.identifiers.length) {
                    ((AndSelector)identifiersSelector).addSelector(new IdentifierSelector(this.identifiers[i]));
                    ++i;
                }
                this.selector.addSelector(identifiersSelector);
            } else {
                identifiersSelector = new OrSelector();
                i = 0;
                while (i < this.identifiers.length) {
                    ((OrSelector)identifiersSelector).addSelector(new IdentifierSelector(this.identifiers[i]));
                    ++i;
                }
                this.selector.addSelector(identifiersSelector);
            }
        }
        if (this.categories != null && this.categories.length > 0) {
            ISelector categoriesSelector;
            if (this.qualifier.getComparisonStrategy() == 3) {
                categoriesSelector = new OrSelector();
                i = 0;
                while (i < this.categories.length) {
                    ((OrSelector)categoriesSelector).addSelector(new CategorySelector(this.categories[i]));
                    ++i;
                }
                this.selector.addSelector(categoriesSelector);
            } else {
                categoriesSelector = new AndSelector();
                i = 0;
                while (i < this.categories.length) {
                    ((AndSelector)categoriesSelector).addSelector(new CategorySelector(this.categories[i]));
                    ++i;
                }
                this.selector.addSelector(categoriesSelector);
            }
        }
        return this.selector;
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("find_tModel");
        this.qualifier.write(query);
        if (this.name != null) {
            query.writeString("name", this.name);
        }
        if (this.identifiers != null) {
            Identifier.writeList(query, this.identifiers);
        }
        if (this.categories != null) {
            Category.writeList(query, this.categories);
        }
    }

    public void read(IReader reader) throws IOException {
        this.qualifier = Qualifier.readQualifier(reader);
        this.name = reader.readString("name");
        IReader child = null;
        child = reader.getReader("identifierBag");
        if (child != null) {
            this.identifiers = Identifier.readList(child);
        }
        if ((child = reader.getReader("categoryBag")) != null) {
            this.categories = Category.readList(child);
        }
    }
}

