/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Authorization;
import electric.uddi.Category;
import electric.uddi.IInquiryCommand;
import electric.uddi.ISubscriptionFilter;
import electric.uddi.IUDDIServer;
import electric.uddi.Name;
import electric.uddi.Qualifier;
import electric.uddi.Service;
import electric.uddi.ServiceInfo;
import electric.uddi.ServiceInfos;
import electric.uddi.TModel;
import electric.uddi.UDDIException;
import electric.uddi.selectors.AndSelector;
import electric.uddi.selectors.CategorySelector;
import electric.uddi.selectors.ISelector;
import electric.uddi.selectors.NameSelector;
import electric.uddi.selectors.OrSelector;
import electric.uddi.selectors.ServiceTModelSelector;
import electric.uddi.util.UDDIUtil;
import electric.util.array.ArrayUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public final class FindServices
implements IInquiryCommand,
ISubscriptionFilter {
    private String businessKey;
    private Name[] names;
    private Category[] categories;
    private String[] tModelKeys;
    private Qualifier qualifier = Qualifier.DEFAULT;
    private transient AndSelector selector;

    public FindServices() {
    }

    public FindServices(String businessKey, Name[] names, Category[] categories, String[] tModelKeys, Qualifier qualifier) {
        this.businessKey = businessKey;
        this.names = names;
        this.categories = categories;
        this.tModelKeys = tModelKeys;
        this.qualifier = qualifier != null ? qualifier : Qualifier.DEFAULT;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public Name[] getNames() {
        return this.names;
    }

    public void setNames(Name[] names) {
        this.names = names;
    }

    public Category[] getCategories() {
        return this.categories;
    }

    public void setCategories(Category[] categories) {
        this.categories = categories;
    }

    public String[] getTModelKeys() {
        return this.tModelKeys;
    }

    public void setTModelKeys(String[] tModelKeys) {
        this.tModelKeys = tModelKeys;
    }

    public Qualifier getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(Qualifier qualifier) {
        this.qualifier = qualifier;
    }

    public String getVersion() {
        int count = 0;
        if (this.names != null) {
            ++count;
        }
        if (this.categories != null) {
            ++count;
        }
        if (this.tModelKeys != null) {
            ++count;
        }
        return count > 1 || this.names != null && this.names.length > 1 ? "2.0" : "1.0";
    }

    public boolean needsAuthorization() {
        return false;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        ISelector selector = this.getSelector();
        Enumeration businessKeys = null;
        if (this.businessKey == null || this.businessKey.length() == 0) {
            businessKeys = server.getBusinessKeys();
        } else {
            Vector<String> keys = new Vector<String>();
            keys.addElement(this.businessKey);
            businessKeys = keys.elements();
        }
        ServiceInfo[] matches = new ServiceInfo[]{};
        while (businessKeys.hasMoreElements()) {
            String businessKey = (String)businessKeys.nextElement();
            String[] serviceKeys = server.getServiceKeysForBusiness(businessKey);
            int i = 0;
            while (i < serviceKeys.length) {
                Service service = server.readService(serviceKeys[i]);
                if (selector.selects(server, service)) {
                    matches = (ServiceInfo[])ArrayUtil.addElement(matches, new ServiceInfo(service));
                }
                ++i;
            }
        }
        return new ServiceInfos(matches, false);
    }

    public synchronized ISelector getSelector() {
        int i;
        if (this.selector != null) {
            return this.selector;
        }
        this.selector = new AndSelector();
        if (this.names != null && this.names.length > 0) {
            OrSelector namesSelector = new OrSelector();
            i = 0;
            while (i < this.names.length) {
                namesSelector.addSelector(new NameSelector(this.names[i], this.qualifier));
                ++i;
            }
            this.selector.addSelector(namesSelector);
        }
        if (this.categories != null && this.categories.length > 0) {
            ISelector categoriesSelector;
            if (this.qualifier.getComparisonStrategy() == 3) {
                categoriesSelector = new OrSelector();
                i = 0;
                while (i < this.categories.length) {
                    ((OrSelector)categoriesSelector).addSelector(new CategorySelector(this.categories[i]));
                    ++i;
                }
                this.selector.addSelector(categoriesSelector);
            } else {
                categoriesSelector = new AndSelector();
                i = 0;
                while (i < this.categories.length) {
                    ((AndSelector)categoriesSelector).addSelector(new CategorySelector(this.categories[i]));
                    ++i;
                }
                this.selector.addSelector(categoriesSelector);
            }
        }
        if (this.tModelKeys != null && this.tModelKeys.length > 0) {
            ISelector tModelsSelector;
            if (this.qualifier.getComparisonStrategy() == 3) {
                tModelsSelector = new OrSelector();
                i = 0;
                while (i < this.tModelKeys.length) {
                    ((OrSelector)tModelsSelector).addSelector(new ServiceTModelSelector(this.tModelKeys[i]));
                    ++i;
                }
                this.selector.addSelector(tModelsSelector);
            } else {
                tModelsSelector = new AndSelector();
                i = 0;
                while (i < this.tModelKeys.length) {
                    ((AndSelector)tModelsSelector).addSelector(new ServiceTModelSelector(this.tModelKeys[i]));
                    ++i;
                }
                this.selector.addSelector(tModelsSelector);
            }
        }
        return this.selector;
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("find_service");
        if (this.businessKey != null) {
            query.writeAttribute("businessKey", this.businessKey);
        }
        this.qualifier.write(query);
        if (this.names != null && this.names.length > 0) {
            Name.validate(this.names);
            Name.writeList(query, this.names);
        }
        if (this.categories != null) {
            Category.writeList(query, this.categories);
        }
        if (this.tModelKeys != null) {
            TModel.writeKeyList(query, this.tModelKeys);
        }
    }

    public void read(IReader reader) throws IOException {
        this.businessKey = reader.readAttributeValue("businessKey");
        this.qualifier = Qualifier.readQualifier(reader);
        if (reader.getReaders("name").length > 0) {
            this.names = Name.readList(reader);
            Name.validate(this.names);
        }
        IReader child = null;
        child = reader.getReader("categoryBag");
        if (child != null) {
            this.categories = Category.readList(child);
        }
        if ((child = reader.getReader("tModelBag")) != null) {
            this.tModelKeys = TModel.readKeyList(child);
        }
    }
}

