/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Authorization;
import electric.uddi.Binding;
import electric.uddi.Bindings;
import electric.uddi.IInquiryCommand;
import electric.uddi.ISubscriptionFilter;
import electric.uddi.IUDDIServer;
import electric.uddi.Qualifier;
import electric.uddi.TModel;
import electric.uddi.UDDIException;
import electric.uddi.selectors.AndSelector;
import electric.uddi.selectors.BusinessTModelSelector;
import electric.uddi.selectors.ISelector;
import electric.uddi.selectors.OrSelector;
import electric.uddi.util.UDDIUtil;
import electric.util.array.ArrayUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class FindBindings
implements IInquiryCommand,
ISubscriptionFilter {
    private String serviceKey;
    private String[] tModelKeys;
    private Qualifier qualifier = Qualifier.DEFAULT;
    private transient ISelector selector;

    public FindBindings() {
    }

    public FindBindings(String serviceKey, String[] tModelKeys, Qualifier qualifier) {
        this.serviceKey = serviceKey;
        this.tModelKeys = tModelKeys;
        this.qualifier = qualifier != null ? qualifier : Qualifier.DEFAULT;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public String[] getTModelKeys() {
        return this.tModelKeys;
    }

    public void setTModelKeys(String[] tModelKeys) {
        this.tModelKeys = tModelKeys;
    }

    public Qualifier getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(Qualifier qualifier) {
        this.qualifier = qualifier;
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsAuthorization() {
        return false;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        ISelector selector = this.getSelector();
        String[] bindingKeys = server.getBindingKeysForService(this.serviceKey);
        Binding[] matches = new Binding[]{};
        int i = 0;
        while (i < bindingKeys.length) {
            Binding binding = server.readBinding(bindingKeys[i]);
            if (selector.selects(server, binding)) {
                matches = (Binding[])ArrayUtil.addElement(matches, binding);
            }
            ++i;
        }
        return new Bindings(matches);
    }

    public synchronized ISelector getSelector() {
        if (this.selector != null) {
            return this.selector;
        }
        if (this.tModelKeys != null && this.tModelKeys.length > 0) {
            if (this.qualifier.getComparisonStrategy() == 3) {
                OrSelector orSelector = new OrSelector();
                int i = 0;
                while (i < this.tModelKeys.length) {
                    orSelector.addSelector(new BusinessTModelSelector(this.tModelKeys[i]));
                    ++i;
                }
                this.selector = orSelector;
            } else {
                AndSelector andSelector = new AndSelector();
                int i = 0;
                while (i < this.tModelKeys.length) {
                    andSelector.addSelector(new BusinessTModelSelector(this.tModelKeys[i]));
                    ++i;
                }
                this.selector = andSelector;
            }
        } else {
            this.selector = new AndSelector();
        }
        return this.selector;
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("find_binding");
        query.writeAttribute("serviceKey", this.serviceKey);
        this.qualifier.write(query);
        TModel.writeKeyList(query, this.tModelKeys);
    }

    public void read(IReader reader) throws IOException {
        this.serviceKey = reader.readAttributeValue("serviceKey");
        this.qualifier = Qualifier.readQualifier(reader);
        this.tModelKeys = TModel.readKeyList(reader.getReader("tModelBag"));
    }
}

