/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.references.rebind;

import electric.fabric.IFabricConstants;
import electric.soap.references.ISOAPReference;
import electric.soap.references.ISOAPReferenceFactory;
import electric.soap.references.SOAPReferenceFactories;
import electric.soap.references.rebind.RebindSOAPReference;
import electric.util.Context;
import electric.util.XURL;
import electric.util.http.HTTPUtil;
import electric.util.log.ILoggingConstants;
import electric.wsdl.WSDL;
import java.util.Vector;

public final class RebindSOAPReferenceFactory
implements ISOAPReferenceFactory,
IFabricConstants,
ILoggingConstants {
    public boolean newSOAPReference(Vector referenceChain, XURL endpoint, WSDL wsdl, Context proxyContext) {
        if (endpoint.getProtocol() != null) {
            return false;
        }
        String path = endpoint.getFile();
        if (!path.startsWith("?glue")) {
            return false;
        }
        boolean failover = HTTPUtil.hasParameter(path, "failover");
        if (!failover) {
            return false;
        }
        path = HTTPUtil.removeParameter(path, "failover");
        ISOAPReference soapReference = this.getSOAPReference(endpoint = new XURL(endpoint.getProtocol(), endpoint.getHost(), endpoint.getPort(), path, endpoint.getReference()), wsdl, proxyContext);
        if (soapReference == null) {
            return false;
        }
        soapReference = new RebindSOAPReference(endpoint, proxyContext, this, soapReference);
        referenceChain.addElement(soapReference);
        return true;
    }

    public ISOAPReference getSOAPReference(XURL endpoint, WSDL wsdl, Context proxyContext) {
        int index = SOAPReferenceFactories.getIndex(this);
        return SOAPReferenceFactories.newSOAPReference(endpoint, wsdl, proxyContext, index);
    }
}

