/*
 * Decompiled with CFR 0.152.
 */
package electric.server.jms.jbossmq;

import electric.server.jms.IJMSAdapter;
import electric.util.Context;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JBossMQAdapter
implements IJMSAdapter {
    private static final String providerURL = "jnp://localhost:1099";
    private static final String contextFactory = "org.jnp.interfaces.NamingContextFactory";
    private static final String CONNECTION_FACTORY = "ConnectionFactory";
    private boolean isStarted = false;
    private javax.naming.Context initialContext;
    private Context context;
    private QueueConnectionFactory defaultConnFactory;

    public void startup(Context context) throws JMSException, NamingException {
        this.context = context;
        Hashtable<String, String> jndiProperties = new Hashtable<String, String>();
        jndiProperties.put("java.naming.factory.initial", contextFactory);
        jndiProperties.put("java.naming.provider.url", providerURL);
        this.initialContext = new InitialContext(jndiProperties);
        this.defaultConnFactory = (QueueConnectionFactory)this.initialContext.lookup(CONNECTION_FACTORY);
        this.isStarted = true;
    }

    public void shutdown() throws JMSException, NamingException {
        this.isStarted = false;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public Context getStartupContext() {
        return this.context;
    }

    public Queue getQueue(String queueName, boolean create) throws JMSException, NamingException {
        queueName = "queue/" + queueName;
        return (Queue)this.initialContext.lookup(queueName);
    }

    public QueueConnectionFactory getQueueConnectionFactory(String queueConnFactoryName, boolean create) throws JMSException, NamingException {
        if (create) {
            return (QueueConnectionFactory)this.initialContext.lookup(CONNECTION_FACTORY);
        }
        return this.defaultConnFactory;
    }

    public String getClassName() {
        return "org.jboss.mq.SpyQueue";
    }

    public String getProviderName() {
        return "JBossMQ";
    }
}

