/*
 * Decompiled with CFR 0.152.
 */
package electric.server.http;

import electric.application.Application;
import electric.application.Applications;
import electric.glue.IGLUEContextConstants;
import electric.registry.security.RegistryGuards;
import electric.server.IServer;
import electric.server.Servers;
import electric.server.http.IServerURLDetector;
import electric.server.http.IServletHandler;
import electric.servlet.Config;
import electric.servlet.HTTPContext;
import electric.servlet.httpget.HTTPGetServlet;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.command.Commands;
import electric.util.http.IHTTPConstants;
import electric.util.http.RedirectException;
import electric.util.io.Streams;
import electric.util.license.License;
import electric.util.license.LicensingException;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.Product;
import electric.util.string.Strings;
import electric.xml.Document;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ServletServer
extends HttpServlet
implements IServer,
IHTTPConstants,
IGLUEContextConstants,
ILoggingConstants {
    private static final String HTTP_REGISTRY_ROOT = "httpRegistryRoot";
    private static final String ELECTRIC_COMMANDS = "electric.commands";
    private static final String ELECTRIC_SERVER_DETECTOR = "electric.server.detector";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String DEFAULT_DETECTOR = "electric.server.http.detectors.init.InitParamURLDetector";
    private static Class[] handlerTypes;
    private static IServerURLDetector[] detectors;
    private IServletHandler[] handlers = new IServletHandler[0];
    private String root;
    private XURL path;
    private HTTPGetServlet httpGet = new HTTPGetServlet();
    private Application application;

    public String toString() {
        return "ServletServer( path=" + this.path + ", root=" + this.root + " )";
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Context context = Context.thread();
        context.setProperty("httpRequest", request);
        context.setProperty("httpResponse", response);
        context.setProperty("httpServletConfig", this.getServletConfig());
        context.setProperty("application", this.application);
        if (this.path == null) {
            this.addServer(request);
        }
        try {
            int i = 0;
            while (i < this.handlers.length) {
                if (this.handlers[i].service(this, request, response)) {
                    return;
                }
                ++i;
            }
            this.httpGet.service((ServletRequest)request, (ServletResponse)response);
        }
        catch (RedirectException exception) {
            response.sendRedirect(exception.getPath());
        }
        catch (ServletException exception) {
            throw exception;
        }
        finally {
            context.removeProperty("httpRequest");
            context.removeProperty("httpResponse");
            context.removeProperty("httpServletConfig");
            context.removeProperty("application");
        }
    }

    public static void addHandlerType(Class handlerType) {
        handlerTypes = (Class[])ArrayUtil.addElement(handlerTypes, handlerType);
    }

    public static void removeHandlerType(Class handlerType) {
        handlerTypes = (Class[])ArrayUtil.removeElement(handlerTypes, handlerType);
    }

    public void addHandler(IServletHandler handler, int index) {
        this.handlers = index == -1 ? (IServletHandler[])ArrayUtil.addElement(this.handlers, handler) : (IServletHandler[])ArrayUtil.insertElementAt(this.handlers, handler, index);
    }

    public void removeHandler(IServletHandler handler) {
        this.handlers = (IServletHandler[])ArrayUtil.removeElement(this.handlers, handler);
    }

    private void addHandlers() throws ServletException {
        int i = 0;
        while (i < handlerTypes.length) {
            try {
                this.addHandler((IServletHandler)handlerTypes[i].newInstance(), i);
            }
            catch (Exception exception) {
                if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                    Log.log(ILoggingConstants.ERROR_EVENT, "error adding handler. handler class " + handlerTypes[i], exception);
                }
                throw new ServletException(exception.toString());
            }
            ++i;
        }
    }

    public static void addDetector(IServerURLDetector detector) {
        detectors = (IServerURLDetector[])ArrayUtil.addElement(detectors, detector);
    }

    public static void addDetectors(String detectors) {
        StringTokenizer tokenizer = new StringTokenizer(detectors, ", \t");
        while (tokenizer.hasMoreTokens()) {
            String detectorClassName = tokenizer.nextToken();
            ServletServer.addDetector(detectorClassName);
        }
    }

    private static void addDetector(String detectorClassName) {
        block2: {
            try {
                Class detectorClass = ClassLoaders.loadClass(detectorClassName);
                ServletServer.addDetector((IServerURLDetector)detectorClass.newInstance());
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "Could not load Server URL Detector " + detectorClassName, throwable);
            }
        }
    }

    private static void addContainerDetectors() {
        ServletServer.addDetector("electric.server.http.detectors.weblogic.WebLogicURLDetector");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!Product.isStarted() || Applications.getDefaultApplication() != null && Applications.isHosted()) {
            this.initApplication(config);
        }
        this.initRoot(config);
        this.initCommands(config);
        this.initServer(config);
        this.initSecurity(config);
        if (this.application != null) {
            this.application.start();
        }
        this.initHandlers();
        if (License.isClientLicense()) {
            throw new LicensingException("soap/http server is disabled. Contact TME Sales to obtain a server side license");
        }
    }

    private void initApplication(ServletConfig config) {
        Applications.setHosted(true);
        ServletContext servletContext = config.getServletContext();
        this.application = Applications.getApplication(servletContext);
    }

    private void initRoot(ServletConfig config) {
        this.setRoot(config.getInitParameter(HTTP_REGISTRY_ROOT));
    }

    private void initCommands(ServletConfig config) throws ServletException {
        String commandFile = config.getInitParameter(ELECTRIC_COMMANDS);
        if (commandFile != null) {
            try {
                this.executeCommands(config, commandFile);
            }
            catch (Throwable throwable) {
                if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                    Log.log(ILoggingConstants.ERROR_EVENT, "error executing commands", throwable);
                }
                throw new ServletException(throwable.toString());
            }
        }
    }

    private void executeCommands(ServletConfig config, String filename) throws Throwable {
        InputStream input = config.getServletContext().getResourceAsStream(filename);
        if (input == null) {
            File file = new File(filename);
            if (!file.exists()) {
                file = new File(config.getServletContext().getRealPath(filename));
            }
            if (!file.exists()) {
                throw new IllegalArgumentException("cannot find " + filename);
            }
            input = new FileInputStream(file);
        }
        byte[] bytes = Streams.readFully(input);
        input.close();
        Document document = new Document(bytes);
        Commands.execute(document);
    }

    private void initServer(ServletConfig config) throws ServletException {
        String initDetectors = config.getInitParameter(ELECTRIC_SERVER_DETECTOR);
        if (initDetectors != null) {
            ServletServer.addDetectors(initDetectors);
        }
        int i = 0;
        while (i < detectors.length) {
            String url = detectors[i].getURL(config);
            if (url != null) {
                this.addServer(url);
                return;
            }
            ++i;
        }
    }

    private void initSecurity(ServletConfig config) {
        ServletContext context = config.getServletContext();
        if (context instanceof HTTPContext) {
            this.initSecurity(config, (HTTPContext)context);
        }
    }

    private void initSecurity(ServletConfig config, HTTPContext httpContext) {
        Hashtable hash = httpContext.getServletMappings();
        Enumeration enumeration = hash.keys();
        String pattern = null;
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            Config mappedConfig = (Config)hash.get(object);
            if (!mappedConfig.equals(config)) continue;
            pattern = (String)object;
            break;
        }
        if (pattern != null) {
            if (pattern.equals("/*") || pattern.equals("/")) {
                pattern = "/";
            } else if (pattern.endsWith("/*")) {
                pattern = pattern.substring(0, pattern.length() - 2);
            }
            httpContext.addPathGuards(new RegistryGuards(this.root, pattern));
        }
    }

    private void initHandlers() throws ServletException {
        this.addHandlers();
        int i = 0;
        while (i < this.handlers.length) {
            this.handlers[i].init(this);
            ++i;
        }
    }

    public void destroy() {
    }

    public String getType() {
        return "soap/http";
    }

    public String getRoot() {
        return this.root;
    }

    private void setRoot(String root) {
        this.root = root == null ? "/" : (root.equals("-") ? null : (root.endsWith("/") ? root : root + "/"));
    }

    public XURL getPath() {
        return this.path;
    }

    private void setPath(String url) throws ServletException {
        try {
            this.path = new XURL(url);
        }
        catch (MalformedURLException exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to parse URL " + url, exception);
            }
            throw new ServletException(exception.toString());
        }
    }

    public String getLocalPath(String uri) {
        if (this.path != null) {
            int pathLength;
            int n = pathLength = this.path.getFile() != null ? this.path.getFile().length() : 0;
            if (uri.length() > pathLength) {
                return Strings.splice(this.root, uri.substring(pathLength));
            }
        }
        return null;
    }

    private void addServer(String url) throws ServletException {
        this.setPath(url);
        if (this.getServletConfig().getServletContext().getRealPath("somefile") != null) {
            this.httpGet.init(this.getServletConfig());
        }
        Servers.addServer(url, this);
    }

    private void addServer(HttpServletRequest request) throws UnknownHostException, ServletException {
        if (this.application != null) {
            Applications.registerApplication(request.getContextPath(), this.application);
        }
        String protocol = request.isSecure() ? HTTPS : HTTP;
        InetAddress address = InetAddress.getByName(request.getServerName());
        String tail = address.getHostName() + ":" + request.getServerPort() + request.getContextPath() + request.getServletPath();
        String url = protocol + "://" + tail;
        this.addServer(url);
    }

    static {
        block4: {
            handlerTypes = new Class[0];
            detectors = new IServerURLDetector[0];
            try {
                Class detectorClass = ClassLoaders.loadClass(DEFAULT_DETECTOR);
                ServletServer.addDetector((IServerURLDetector)detectorClass.newInstance());
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block4;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "Cannot load electric.server.http.detectors.init.InitParamURLDetector.  electric.http.url will be ignored.", throwable);
            }
        }
        String property = Context.getSystemProperty(ELECTRIC_SERVER_DETECTOR);
        if (property != null) {
            ServletServer.addDetectors(property);
        } else {
            ServletServer.addContainerDetectors();
        }
    }
}

