/*
 * Decompiled with CFR 0.152.
 */
package electric.server;

import electric.glue.IGLUELoggingConstants;
import electric.server.IServer;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Servers
implements IGLUELoggingConstants {
    private static final Hashtable nameToServer = new Hashtable();

    public static void addServer(String name, IServer server) {
        nameToServer.put(name, server);
        if (Log.isLogging(ILoggingConstants.STARTUP_EVENT)) {
            String logText = server.getType() + " server started on " + server.getPath();
            if (!server.getRoot().equals("/")) {
                logText = logText + ", " + server.getRoot();
            }
            Log.log(ILoggingConstants.STARTUP_EVENT, (Object)logText);
        }
    }

    public static synchronized IServer getServer(String name) {
        return (IServer)nameToServer.get(name);
    }

    public static synchronized IServer removeServer(String name) {
        return (IServer)nameToServer.remove(name);
    }

    public static synchronized IServer[] getServers() {
        IServer[] array = new IServer[nameToServer.size()];
        Enumeration enumeration = nameToServer.elements();
        int i = 0;
        while (i < array.length) {
            array[i] = (IServer)enumeration.nextElement();
            ++i;
        }
        return array;
    }

    private static synchronized boolean servingXURL(XURL xurl) {
        Enumeration enumeration = nameToServer.elements();
        while (enumeration.hasMoreElements()) {
            IServer server = (IServer)enumeration.nextElement();
            if (server.getPath().getPort() != xurl.getPort() || !xurl.getProtocol().equals(server.getPath().getProtocol())) continue;
            return true;
        }
        return false;
    }

    public static boolean isLocal(XURL xurl) {
        return xurl.hasLocalHost() && Servers.servingXURL(xurl);
    }

    public static boolean isLocal(String url) {
        if (!XURL.hasProtocol(url)) {
            return true;
        }
        try {
            return Servers.isLocal(new XURL(url));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static synchronized XURL[] getPaths() {
        XURL[] paths = new XURL[]{};
        Enumeration enumeration = nameToServer.elements();
        while (enumeration.hasMoreElements()) {
            IServer server = (IServer)enumeration.nextElement();
            if (server.getRoot() == null) continue;
            paths = (XURL[])ArrayUtil.addElement(paths, server.getPath());
        }
        return paths;
    }

    public static synchronized IServer[] getServersForProtocol(String protocol) {
        IServer[] array = new IServer[]{};
        Enumeration enumeration = nameToServer.elements();
        while (enumeration.hasMoreElements()) {
            IServer server = (IServer)enumeration.nextElement();
            if (!server.getPath().getProtocol().equals(protocol)) continue;
            array = (IServer[])ArrayUtil.addElement(array, server);
        }
        return array;
    }

    public static synchronized IServer getServerForLocalPath(String urn) {
        Enumeration enumeration = nameToServer.elements();
        while (enumeration.hasMoreElements()) {
            IServer server = (IServer)enumeration.nextElement();
            if (server.getRoot() == null || !urn.startsWith(server.getRoot())) continue;
            return server;
        }
        return null;
    }

    public static synchronized IServer getServerForPath(XURL xurl) {
        if (xurl == null || !xurl.hasLocalHost()) {
            return null;
        }
        Enumeration enumeration = nameToServer.elements();
        while (enumeration.hasMoreElements()) {
            IServer server = (IServer)enumeration.nextElement();
            XURL serverXURL = server.getPath();
            if (serverXURL.getPort() != xurl.getPort() || !xurl.getProtocol().equals(serverXURL.getProtocol())) continue;
            if (serverXURL.getFile() == null) {
                return server;
            }
            if (serverXURL.getFile() != null && !xurl.getFile().startsWith(serverXURL.getFile())) continue;
            return server;
        }
        return null;
    }

    public static String getLocalPath(XURL xurl) {
        IServer server = Servers.getServerForPath(xurl);
        return server == null ? null : server.getLocalPath(xurl.getFile());
    }

    public static String getPath(String urn) {
        IServer server;
        if (!urn.startsWith("/")) {
            urn = "/" + urn;
        }
        if ((server = Servers.getServerForLocalPath(urn)) == null) {
            return null;
        }
        return server.getPath() + urn.substring(server.getRoot().length() - 1);
    }
}

