/*
 * Decompiled with CFR 0.152.
 */
package electric.security.acl;

import electric.application.Applications;
import electric.glue.IGLUELoggingConstants;
import electric.security.ICredentials;
import electric.security.IRealm;
import electric.security.acl.ACLMonitor;
import electric.security.basic.BasicPrincipal;
import electric.util.array.ArrayUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.path.Paths;
import electric.util.resourceloader.ResourceLoaders;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;

public class ACLRealm
implements IRealm,
IGLUELoggingConstants {
    private String name;
    private Hashtable nameToPrincipal = new Hashtable();
    private Hashtable nameToPassword = new Hashtable();
    private Hashtable nameToRoles = new Hashtable();
    private String filename;

    public ACLRealm(String name) throws IOException, ParseException {
        this(name, "security/" + name + ".xml");
    }

    public ACLRealm(String name, String filename) throws IOException, ParseException {
        this.filename = Paths.normalizePath(filename);
        this.name = name;
        this.read();
        this.possiblyMonitor();
    }

    public String getName() {
        return this.name;
    }

    String getFilename() {
        return this.filename;
    }

    public void addUser(String name, String password, String[] roles) {
        this.addPrincipal(name, password, roles);
        this.save();
    }

    public Enumeration getPrincipals() {
        return this.nameToPrincipal.elements();
    }

    public Principal getPrincipal(String name) {
        return (Principal)this.nameToPrincipal.get(name);
    }

    void addPrincipal(String name, String password, String[] roles) {
        this.nameToPrincipal.put(name, new BasicPrincipal(name));
        if (password != null) {
            this.nameToPassword.put(name, password);
        }
        if (roles != null) {
            this.nameToRoles.put(name, roles);
        }
    }

    public String[] getRoles(String name) {
        return (String[])this.nameToRoles.get(name);
    }

    public boolean isUserInRole(String name, String[] roles) {
        String[] userRoles = this.getRoles(name);
        if (userRoles == null) {
            return false;
        }
        int i = 0;
        while (i < userRoles.length) {
            int j = 0;
            while (j < roles.length) {
                if (userRoles[i].equals(roles[j])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public String getPassword(String name) {
        return (String)this.nameToPassword.get(name);
    }

    public boolean authenticate(ICredentials credentials) throws SecurityException {
        if (credentials != null) {
            return credentials.authenticate(this);
        }
        return false;
    }

    private void read() throws ParseException, IOException {
        Document acls = new Document(ResourceLoaders.loadResource(this.filename));
        Elements users = acls.getRoot().getElements();
        while (users.hasMoreElements()) {
            Element user = users.next();
            Elements roleElements = user.getElements("role");
            String[] roles = new String[]{};
            while (roleElements.hasMoreElements()) {
                roles = (String[])ArrayUtil.addElement(roles, roleElements.next().getString());
            }
            if (user.hasElement("name") && user.hasElement("password")) {
                this.addPrincipal(user.getElement("name").getString(), user.getElement("password").getString(), roles);
                continue;
            }
            if (!Log.isLogging(ILoggingConstants.SECURITY_EVENT)) continue;
            Log.log(ILoggingConstants.SECURITY_EVENT, (Object)("user element invalid " + user));
        }
    }

    private void write() {
        Document doc = new Document();
        doc.setRoot("acls");
        Enumeration enumeration = this.nameToPassword.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String password = (String)this.nameToPassword.get(name);
            String[] roles = (String[])this.nameToRoles.get(name);
            Element user = doc.addElement("user");
            user.addElement("name").setText(name);
            if (password != null) {
                user.addElement("password").setText(password);
            }
            if (roles == null) continue;
            int i = 0;
            while (i < roles.length) {
                user.addElement("role").addText(roles[i]);
                ++i;
            }
        }
    }

    void clear() {
        this.nameToPassword.clear();
        this.nameToPrincipal.clear();
        this.nameToRoles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws IOException, ParseException {
        ACLRealm aCLRealm = this;
        synchronized (aCLRealm) {
            this.clear();
            this.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        ACLRealm aCLRealm = this;
        synchronized (aCLRealm) {
            this.write();
        }
    }

    public void possiblyMonitor() {
        block4: {
            try {
                Element root = Applications.getDefaultApplication().getConfig().getRoot();
                Element hotDeploy = root.getElement("hotDeployment");
                if (hotDeploy == null) {
                    return;
                }
                String ENABLED = "enabled";
                if (hotDeploy.hasElement(ENABLED) && hotDeploy.getBoolean(ENABLED)) {
                    this.monitor();
                }
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block4;
                Log.log(ILoggingConstants.ERROR_EVENT, "unable to setup monitoring for " + this.filename, throwable);
            }
        }
    }

    public void monitor() {
        new ACLMonitor(this, this.filename);
    }
}

