/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.pro.config;

import electric.glue.pro.config.IConfigConstants;
import electric.security.IRealm;
import electric.security.Realms;
import electric.soap.security.SOAPSecurityException;
import electric.soap.security.encryption.WSSEncryption;
import electric.soap.security.signature.xml.ElementReference;
import electric.soap.security.util.ConfigUtil;
import electric.util.product.IConfig;
import electric.util.string.Base64;
import electric.xml.Element;
import electric.xml.Elements;

public class WSSEncryptionConfig
implements IConfig,
IConfigConstants {
    public void config(Element wsSecurityElement) throws SOAPSecurityException {
        Elements encryptionSpecs = wsSecurityElement.getElements("encryptionTemplate");
        while (encryptionSpecs.hasMoreElements()) {
            Element encryptionElement = encryptionSpecs.next();
            this.addEncryption(encryptionElement);
        }
    }

    private void addEncryption(Element encryptionElement) throws SOAPSecurityException {
        String user;
        String name = encryptionElement.getString("name");
        if (name == null) {
            return;
        }
        WSSEncryption encryptionSpec = new WSSEncryption();
        Elements references = encryptionElement.getElements("reference");
        while (references.hasMoreElements()) {
            ElementReference reference = ConfigUtil.createReference(references.next());
            if (reference == null) continue;
            encryptionSpec.setReference(reference);
        }
        Element secretKey = encryptionElement.getElement("secretKey");
        if (secretKey == null) {
            throw new SOAPSecurityException("encryption template, only secret keys supported");
        }
        String realmName = secretKey.getTextString("realm");
        String algorithm = encryptionElement.getTextString("algorithm");
        if (algorithm == null) {
            encryptionSpec.setAlgorithm(algorithm);
        }
        if ((user = secretKey.getTextString("user")) == null) {
            throw new SecurityException("encryption template, user not set");
        }
        encryptionSpec.setKeyName(user);
        if (realmName != null) {
            this.configRealmKey(encryptionSpec, realmName);
        } else {
            this.configHardcodedKey(secretKey, encryptionSpec);
        }
        WSSEncryption.addEncryptionSpec(name, encryptionSpec);
    }

    private void configRealmKey(WSSEncryption encryptionSpec, String realmName) {
        IRealm realm = Realms.getRealm(realmName);
        if (realm == null) {
            throw new SecurityException("encryption template, realm name not valid: " + realmName);
        }
        encryptionSpec.setRealm(realm);
    }

    private void configHardcodedKey(Element secretKey, WSSEncryption encryptionSpec) {
        String secretKeyString = secretKey.getTextString("base64Key");
        if (secretKey == null) {
            throw new SecurityException("encryption template, secret key must be set");
        }
        byte[] secretKeyBytes = Base64.fromBase64(secretKeyString);
        encryptionSpec.setSecretKeyBytes(secretKeyBytes);
    }
}

