/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.logs;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.logs.ILogManager;
import electric.fabric.logs.LogEntry;
import electric.fabric.logs.LogEntryLookup;
import electric.fabric.logs.LogManagerException;
import electric.fabric.services.ServiceInfo;
import electric.glue.context.ServiceContext;
import electric.proxy.IReference;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.util.Context;
import electric.xdb.Data;
import electric.xdb.IXDBConstants;
import electric.xdb.Query;
import electric.xdb.Result;
import electric.xdb.XDBException;
import electric.xdb.client.IXDBClient;
import electric.xdb.client.XDBClients;
import electric.xml.Element;

public final class LogManager
implements ILogManager,
IFabricConstants,
IXDBConstants {
    private IReference reference;
    private IXDBClient logs = XDBClients.getClient("logs");
    static /* synthetic */ Class class$electric$fabric$logs$ILogManager;

    public LogManager() throws RegistryException {
        ServiceContext context = new ServiceContext();
        context.setDocumentStyle();
        Registry.publish("/fabric/logManager", (Object)this, class$electric$fabric$logs$ILogManager == null ? (class$electric$fabric$logs$ILogManager = LogManager.class$("electric.fabric.logs.ILogManager")) : class$electric$fabric$logs$ILogManager, (Context)context);
    }

    public synchronized IReference getReference() throws RegistryException {
        if (this.reference != null) {
            return this.reference;
        }
        Class[] interfaces = new Class[]{class$electric$fabric$logs$ILogManager == null ? (class$electric$fabric$logs$ILogManager = LogManager.class$("electric.fabric.logs.ILogManager")) : class$electric$fabric$logs$ILogManager};
        Context context = new Context();
        this.reference = Registry.getReference("/fabric/logManager", interfaces, context);
        return this.reference;
    }

    public void start() throws Exception {
        String wsdlURL = Registry.getPath(this) + ".wsdl";
        ServiceInfo serviceInfo = new ServiceInfo(wsdlURL);
        serviceInfo.setDescription("fabric log manager");
        serviceInfo.addMetadata("inFabricServer", "true");
        serviceInfo.addMetadata("systemService", "true");
        Fabric.getServiceManager().publishUsingInfo(serviceInfo);
    }

    public void addLogEntry(LogEntry entry) throws LogManagerException {
        try {
            this.logs.addData(new Data(entry));
        }
        catch (XDBException exception) {
            throw new LogManagerException(exception);
        }
    }

    public int getLogCount() throws LogManagerException {
        try {
            return this.logs.getDataCount();
        }
        catch (XDBException exception) {
            throw new LogManagerException(exception);
        }
    }

    public LogEntry[] getAllLogEntries(int max) throws LogManagerException {
        return this.getLogEntriesWithCategoryAndEndpoint("*", "*", max);
    }

    public LogEntry[] getLogEntriesWithCategory(String category, int max) throws LogManagerException {
        return this.getLogEntriesWithCategoryAndEndpoint(category, "*", max);
    }

    public LogEntry[] getLogEntriesWithCategoryAndEndpoint(String category, String endpoint, int max) throws LogManagerException {
        LogEntryLookup action = new LogEntryLookup(category, endpoint, max);
        try {
            Result result = this.logs.perform(action);
            return (LogEntry[])result.getValue();
        }
        catch (XDBException exception) {
            throw new LogManagerException(exception);
        }
    }

    public void removeAllLogEntries() throws LogManagerException {
        try {
            this.logs.removeAllData();
        }
        catch (XDBException exception) {
            throw new LogManagerException(exception);
        }
    }

    public void removeAllLogEntriesForEndpoint(String endpoint) throws LogManagerException {
        Element envelope = new Element("Envelope");
        Element body = envelope.addElement("Body");
        Element nodeInfoElement = body.addElement("LogEntry");
        Element propertiesElement = nodeInfoElement.addElement("properties");
        Element valuesElement = propertiesElement.addElement("values");
        valuesElement.setString("endpoint", endpoint);
        Query query = new Query(envelope);
        try {
            this.logs.removeDataForQuery(query);
        }
        catch (XDBException exception) {
            throw new LogManagerException(exception);
        }
    }

    public void removeLogEntriesWithCategory(String category) throws LogManagerException {
        Element envelope = new Element("Envelope");
        Element body = envelope.addElement("Body");
        Element nodeInfoElement = body.addElement("LogEntry");
        if (category != null) {
            Element propertiesElement = nodeInfoElement.addElement("properties");
            Element valuesElement = propertiesElement.addElement("values");
            valuesElement.setString("category", category);
        }
        Query query = new Query(envelope);
        try {
            this.logs.removeDataForQuery(query);
        }
        catch (XDBException exception) {
            throw new LogManagerException(exception);
        }
    }

    public void livenessPing() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

