/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.endpoints;

import electric.fabric.endpoints.RuleComparator;
import electric.fabric.rules.Rule;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPMessage;
import electric.soap.handlers.splice.ISplicedSOAPHandler;
import electric.util.Context;
import electric.util.UUID;
import electric.util.comparators.IComparator;
import electric.util.sorting.BubbleSort;
import electric.util.time.TimeUtil;
import java.rmi.RemoteException;

public final class Endpoint
implements ISOAPHandler,
ISplicedSOAPHandler {
    private static final IComparator RULE_COMPARATOR = new RuleComparator();
    private static final String NEXT_HANDLER = "nextHandler";
    private static final String SEND_REQUEST_TIME = "sendRequestTime";
    private static final String RECEIVE_RESPONSE_TIME = "receiveResponseTime";
    private static final String ENDPOINT_URL = "endpointURL";
    private String key;
    private String url;
    private Rule[] rules = new Rule[0];
    private long timeOfLastRefresh;

    public Endpoint(String url) {
        this.key = new UUID().getKey();
        this.url = url;
        this.timeOfLastRefresh = TimeUtil.now();
    }

    public String toString() {
        return "Endpoint( path=" + this.url + ", rules=" + this.rules.length + ", timeOfLastRefresh=" + this.timeOfLastRefresh + " )";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Endpoint)) {
            return false;
        }
        return ((Endpoint)object).url.equals(this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String getKey() {
        return this.key;
    }

    public String getURL() {
        return this.url;
    }

    public synchronized void setRules(Rule[] rules) {
        BubbleSort.sort(rules, RULE_COMPARATOR);
        if (this.rules.length != rules.length) {
            this.replaceRules(rules);
            return;
        }
        int i = 0;
        while (i < rules.length) {
            if (!rules[i].getKey().equals(this.rules[i].getKey())) {
                this.replaceRules(rules);
                return;
            }
            ++i;
        }
    }

    private void replaceRules(Rule[] rules) {
        int i = 0;
        while (i < rules.length) {
            Rule existingRule = this.getRuleWithKey(rules[i].getKey());
            rules[i] = existingRule == null ? (Rule)rules[i].deepCopy() : (Rule)rules[i].shallowCopy();
            ++i;
        }
        int i2 = 0;
        while (i2 < rules.length - 1) {
            rules[i2].getProcessor().setNextHandler(rules[i2 + 1].getProcessor());
            ++i2;
        }
        if (rules.length > 0) {
            rules[rules.length - 1].getProcessor().setNextHandler(this);
        }
        this.rules = rules;
    }

    public synchronized Rule getRuleWithKey(String key) {
        int i = 0;
        while (i < this.rules.length) {
            if (this.rules[i].getKey().equals(key)) {
                return this.rules[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized Rule[] getRules() {
        return this.rules;
    }

    synchronized ISOAPHandler getFirstHandler(Context messageContext, ISOAPHandler nextHandler) {
        if (this.rules.length == 0) {
            return nextHandler;
        }
        messageContext.setProperty(NEXT_HANDLER, nextHandler);
        return this.rules[0].getProcessor();
    }

    public long getTimeOfLastRefresh() {
        return this.timeOfLastRefresh;
    }

    public void setTimeOfLastRefresh(long time) {
        this.timeOfLastRefresh = time;
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext, ISOAPHandler nextHandler) throws RemoteException, SecurityException {
        messageContext.setProperty(ENDPOINT_URL, this.url);
        messageContext.setProperty(SEND_REQUEST_TIME, new Long(TimeUtil.now()));
        ISOAPHandler firstHandler = this.getFirstHandler(messageContext, nextHandler);
        return firstHandler.handle(request, messageContext);
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        ISOAPHandler nextHandler = (ISOAPHandler)messageContext.getProperty(NEXT_HANDLER);
        SOAPMessage response = nextHandler.handle(request, messageContext);
        messageContext.setProperty(RECEIVE_RESPONSE_TIME, new Long(TimeUtil.now()));
        return response;
    }
}

