/*
 * Decompiled with CFR 0.152.
 */
package electric.directory;

import electric.directory.DirectoryException;
import electric.directory.IContainer;
import electric.directory.IDirectory;
import electric.directory.ISelector;
import electric.directory.Parts;
import electric.util.Enumerations;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Directory
implements IDirectory,
ILoggingConstants {
    protected Dictionary dictionary;
    protected IDirectory parent;

    public Directory() {
        this.dictionary = new Hashtable();
    }

    public Directory(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    public String toString() {
        return this.toString("Directory");
    }

    protected String toString(String type) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(type + "( parent=\"");
        buffer.append(this.parent);
        buffer.append("\" dictionary=\"");
        buffer.append(" keys=( ");
        boolean first = true;
        Enumeration keys = this.dictionary.keys();
        while (keys.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(keys.nextElement());
        }
        buffer.append(" )\" );");
        return buffer.toString();
    }

    public String getPath(Object object) throws DirectoryException {
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String path;
            String key = (String)enumeration.nextElement();
            Object candidate = this.peek(key);
            if (candidate == object) {
                return key;
            }
            if (!(candidate instanceof IContainer) || (path = ((IContainer)candidate).getPath(object)) == null) continue;
            return path.equals("") ? key : key + "/" + path;
        }
        return null;
    }

    public Object get(String path) throws DirectoryException {
        Parts parts = this.getParts(path, false);
        if (parts.directory == null) {
            return parts.tail == null ? this.getPrimitive(parts.head) : null;
        }
        if (parts.tail != null) {
            return parts.directory.get(parts.tail);
        }
        return parts.directory;
    }

    private Object getPrimitive(String path) throws DirectoryException {
        try {
            return this.dictionary.get(path);
        }
        catch (Throwable throwable) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "error during get( " + path + " )", throwable);
            }
            throw new DirectoryException(throwable.toString());
        }
    }

    public Object peek(String path) throws DirectoryException {
        return this.getPrimitive(path);
    }

    public Object put(String path, Object object) throws DirectoryException {
        Parts parts = this.getParts(path, true);
        if (parts.directory == null) {
            return this.putPrimitive(parts.head, object);
        }
        if (parts.tail != null) {
            return parts.directory.put(parts.tail, object);
        }
        throw new DirectoryException("cannot put path " + path);
    }

    private Object putPrimitive(String path, Object object) throws DirectoryException {
        try {
            if (object instanceof IDirectory) {
                ((IDirectory)object).setParent(this);
            }
            return this.dictionary.put(path, object);
        }
        catch (Throwable throwable) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "error during put( " + path + ", " + object + " )", throwable);
            }
            throw new DirectoryException(throwable.toString());
        }
    }

    public Object remove(String path) throws DirectoryException {
        Parts parts = this.getParts(path, false);
        if (parts.directory == null) {
            return parts.tail == null ? this.removePrimitive(parts.head) : null;
        }
        if (parts.tail != null) {
            return parts.directory.remove(parts.tail);
        }
        throw new DirectoryException("cannot remove path " + path);
    }

    private Object removePrimitive(String path) throws DirectoryException {
        try {
            return this.dictionary.remove(path);
        }
        catch (Throwable throwable) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "error during remove( " + path + " )", throwable);
            }
            throw new DirectoryException(throwable.toString());
        }
    }

    public void setParent(IDirectory directory) {
        this.parent = directory;
    }

    public IDirectory getParent() {
        return this.parent;
    }

    public IDirectory getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public IDirectory newSubdirectory(String name) throws DirectoryException {
        Directory subdirectory = new Directory();
        subdirectory.setParent(this);
        this.put(name, subdirectory);
        return subdirectory;
    }

    public void delete() throws DirectoryException {
    }

    public int size() {
        return this.dictionary.size();
    }

    public Enumeration keys() {
        return this.dictionary.keys();
    }

    public boolean removeObject(Object object) throws DirectoryException {
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (this.peek(key) != object) continue;
            this.removePrimitive(key);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Parts getParts(String path, boolean create) throws DirectoryException {
        Parts parts = new Parts();
        if (path.length() == 0) {
            throw new DirectoryException("a path cannot be empty");
        }
        if (path.startsWith("/")) {
            parts.head = "/";
            parts.directory = this.getRoot();
            parts.tail = path.length() == 1 ? null : path.substring(1);
            return parts;
        } else if (path.startsWith("..")) {
            parts.head = "..";
            parts.directory = this.getParent();
            if (path.length() <= 2) return parts;
            if (path.charAt(2) != '/') throw new DirectoryException(".. must appear alone or followed by a /");
            parts.tail = path.substring(3);
            return parts;
        } else if (path.startsWith(".")) {
            parts.head = ".";
            parts.directory = this;
            if (path.length() <= 1) return parts;
            if (path.charAt(1) != '/') throw new DirectoryException(". must appear alone or followed by a /");
            parts.tail = path.substring(2);
            return parts;
        } else {
            int slash = path.indexOf(47);
            if (slash != -1) {
                parts.head = path.substring(0, slash);
                parts.directory = this.getSubdirectory(parts.head, create);
                parts.tail = path.substring(slash + 1);
                return parts;
            } else {
                parts.head = path;
            }
        }
        return parts;
    }

    protected IDirectory getSubdirectory(String name, boolean create) throws DirectoryException {
        Object object = this.get(name);
        if (object instanceof IDirectory) {
            return (IDirectory)object;
        }
        if (object != null) {
            throw new DirectoryException(name + " is not a directory");
        }
        return create ? this.newSubdirectory(name) : null;
    }

    public Enumeration findAll(ISelector selector) throws DirectoryException {
        Enumerations enumerations = new Enumerations();
        Vector<Object> selected = new Vector<Object>();
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = this.get(key);
            if (value instanceof IDirectory) {
                enumerations.add(((IDirectory)value).findAll(selector));
                continue;
            }
            if (!selector.selects(value)) continue;
            selected.addElement(value);
        }
        if (!selected.isEmpty()) {
            enumerations.add(selected.elements());
        }
        return enumerations;
    }

    public Object findFirst(ISelector selector) throws DirectoryException {
        Object selected = null;
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = this.get(key);
            if (value instanceof IDirectory) {
                selected = ((IDirectory)value).findFirst(selector);
            } else if (selector.selects(value)) {
                selected = value;
            }
            if (selected == null) continue;
            return selected;
        }
        return null;
    }
}

