/*
 * Decompiled with CFR 0.152.
 */
package electric.cluster.monitor;

import electric.cluster.IClusterConstants;
import electric.cluster.manager.IClusterManager;
import electric.cluster.server.AppServerInfo;
import electric.cluster.server.ApplicationServer;
import electric.cluster.server.IApplicationServer;
import electric.glue.IGLUELoggingConstants;
import electric.glue.context.ProxyContext;
import electric.registry.Registry;
import electric.util.Context;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.IMIMEConstants;
import electric.util.mime.MIMEData;
import electric.util.mime.MemoryDataHandler;
import electric.util.thread.Lock;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class ClusterMonitor
implements Runnable,
IClusterConstants,
IGLUELoggingConstants,
IMIMEConstants {
    private IClusterManager manager;
    private IApplicationServer server;
    private ProxyContext context;
    static /* synthetic */ Class class$electric$cluster$manager$IClusterManager;

    public ClusterMonitor(IApplicationServer server) {
        this.server = server;
        this.context = new ProxyContext();
        MemoryDataHandler dataHandler = new MemoryDataHandler();
        this.context.setProperty("*/* dataHandler", dataHandler);
    }

    public void run() {
        try {
            if (this.manager == null) {
                this.manager = (IClusterManager)Registry.bind(class$electric$cluster$manager$IClusterManager == null ? (class$electric$cluster$manager$IClusterManager = ClusterMonitor.class$("electric.cluster.manager.IClusterManager")) : class$electric$cluster$manager$IClusterManager, (Context)this.context);
            }
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception binding to master cluster node", exception);
            }
            return;
        }
        try {
            if (!this.manager.needUpdate(this.server.getApplicationSignature())) {
                return;
            }
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception invoking cluster manager", exception);
            }
            return;
        }
        if (Log.isLogging(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT)) {
            Log.log(IGLUELoggingConstants.CLUSTER_DEBUG_EVENT, (Object)"updating cluster node");
        }
        AppServerInfo serverInfo = this.manager.getServerSnapshot(this.server.getApplicationSignature());
        this.deleteApplications(serverInfo.getDeletedApplications());
        this.stopApplications(serverInfo.getOrphanedApplications());
        this.downloadApplications(serverInfo.getMissingApplications());
    }

    private void stopApplications(String[] orphanedApplications) {
        if (orphanedApplications != null && orphanedApplications.length > 0) {
            int i = 0;
            while (i < orphanedApplications.length) {
                this.stopLocalApplication(orphanedApplications[i]);
                ++i;
            }
        }
    }

    private void downloadApplications(String[] missingApplications) {
        if (missingApplications != null && missingApplications.length > 0) {
            int i = 0;
            while (i < missingApplications.length) {
                this.retrieveRemoteApplication(missingApplications[i]);
                ++i;
            }
        }
    }

    private void deleteApplications(String[] deletedApplications) {
        if (deletedApplications != null && deletedApplications.length > 0) {
            int i = 0;
            while (i < deletedApplications.length) {
                this.server.deleteApplication(new File(ApplicationServer.getApplicationsRoot() + deletedApplications[i]));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveRemoteApplication(String applicationName) {
        String applicationFile = applicationName + ".war";
        Lock lock = Lock.obtain(applicationFile);
        try {
            try {
                MIMEData newApplication = this.manager.downloadApplication(applicationName);
                FileOutputStream fileStream = new FileOutputStream(new File(ApplicationServer.getApplicationsRoot() + applicationFile));
                BufferedOutputStream outputStream = new BufferedOutputStream(fileStream);
                outputStream.write(newApplication.getBytes());
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException exception) {
                if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception retrieving remote application: " + applicationName, exception);
                }
                Object var8_9 = null;
                lock.release();
            }
            Object var8_8 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            lock.release();
            throw throwable;
        }
    }

    private void stopLocalApplication(String applicationName) {
        block2: {
            File file = new File(ApplicationServer.getApplicationsRoot() + applicationName);
            try {
                this.server.removeApplication(file, false);
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception stopping application: " + applicationName, exception);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

