/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web.classes;

import electric.application.Applications;
import electric.application.DeploymentException;
import electric.application.web.WebApplication;
import electric.application.web.classes.ClassMonitor;
import electric.application.web.classes.IClassConstants;
import electric.glue.IGLUELoggingConstants;
import electric.util.classpath.ClassPathSource;
import electric.util.classpath.IClassPathEventListener;
import electric.util.classpath.IClassPathSource;
import electric.util.directory.filters.ExtensionFilter;
import electric.util.file.FileUtil;
import electric.util.io.Streams;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.MIMEData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ClassManager
implements IGLUELoggingConstants,
IClassConstants {
    private WebApplication application;
    private ClassPathSource classPathSource;
    private ClassMonitor classPathMonitor;

    public ClassManager(WebApplication application) {
        this.application = application;
        this.classPathSource = ClassManager.newClassPathSource(application.getWebInfRoot());
        if (application.isHotDeployable() && !Applications.isHosted()) {
            IClassPathEventListener[] listeners = new IClassPathEventListener[]{this.classPathSource, application.getServiceManager(), application.getServletManager()};
            this.classPathMonitor = new ClassMonitor(application.getWebInfRoot(), listeners);
        }
    }

    public void start() {
        if (this.classPathMonitor != null) {
            this.classPathMonitor.start();
        }
    }

    public void stop() {
        if (this.classPathMonitor != null) {
            this.classPathMonitor.stop();
        }
    }

    public IClassPathSource getClassPathSource() {
        return this.classPathSource;
    }

    public static ClassPathSource newClassPathSource(String webInfRoot) {
        ClassPathSource classPathSource = new ClassPathSource();
        String classesPath = webInfRoot + "classes";
        classPathSource.addToClassPath(classesPath);
        classPathSource.addToIgnoreList(classesPath);
        ExtensionFilter classFilter = new ExtensionFilter(IClassConstants.CLASS_EXTENSIONS);
        File[] files1 = FileUtil.listFiles(new File(classesPath), true, classFilter);
        classPathSource.classesAdded(files1);
        String libPath = webInfRoot + "lib";
        ExtensionFilter libFilter = new ExtensionFilter(IClassConstants.LIB_EXTENSIONS);
        File[] files2 = FileUtil.listFiles(new File(libPath), true, libFilter);
        classPathSource.classesAdded(files2);
        return classPathSource;
    }

    public void addJar(String filename, MIMEData jar) throws DeploymentException {
        File outputFile = new File(this.application.getLibRoot(), filename);
        try {
            InputStream input = jar.getInputStream();
            FileOutputStream output = new FileOutputStream(outputFile);
            Streams.copy(input, (OutputStream)output, jar.getContentLength(), 10240);
            input.close();
            output.close();
            jar.dispose();
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": added jar " + outputFile));
            }
            if (this.classPathMonitor != null) {
                this.classPathMonitor.cycle();
            }
        }
        catch (IOException exception) {
            String message = this.getAppName() + ": could not add jar " + outputFile;
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, message, exception);
            }
            throw new DeploymentException(message + ": " + exception);
        }
    }

    public boolean removeJar(String filename) throws DeploymentException {
        File jarFile = new File(this.application.getLibRoot(), filename);
        if (!jarFile.exists()) {
            String message = this.getAppName() + ": could not remove jar " + filename;
            if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)message);
            }
            throw new DeploymentException(message);
        }
        boolean deleted = jarFile.delete();
        if (Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT)) {
            if (deleted) {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": removed jar " + filename));
            } else {
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT, (Object)(this.getAppName() + ": could not remove jar " + filename));
            }
        }
        return deleted;
    }

    private String getAppName() {
        return this.application.getAppName();
    }
}

