/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.util.Enumeration;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.startup.UserDatabase;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UserConfig
implements LifecycleListener {
    private static Log log = LogFactory.getLog((Class)UserConfig.class);
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private String directoryName = "public_html";
    private String homeBase = null;
    private Host host = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    private String userClass = "org.apache.catalina.startup.PasswdUserDatabase";

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public String getHomeBase() {
        return this.homeBase;
    }

    public void setHomeBase(String homeBase) {
        this.homeBase = homeBase;
    }

    public String getUserClass() {
        return this.userClass;
    }

    public void setUserClass(String userClass) {
        this.userClass = userClass;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.host = (Host)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            log.error((Object)sm.getString("hostConfig.cce", event.getLifecycle()), (Throwable)e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    private void deploy() {
        if (this.host.getLogger().isDebugEnabled()) {
            this.host.getLogger().debug((Object)sm.getString("userConfig.deploying"));
        }
        UserDatabase database = null;
        try {
            Class<?> clazz = Class.forName(this.userClass);
            database = (UserDatabase)clazz.newInstance();
            database.setUserConfig(this);
        }
        catch (Exception e) {
            this.host.getLogger().error((Object)sm.getString("userConfig.database"), (Throwable)e);
            return;
        }
        Enumeration users = database.getUsers();
        while (users.hasMoreElements()) {
            String user = (String)users.nextElement();
            String home = database.getHome(user);
            this.deploy(user, home);
        }
    }

    private void deploy(String user, String home) {
        String contextPath = "/~" + user;
        if (this.host.findChild(contextPath) != null) {
            return;
        }
        File app = new File(home, this.directoryName);
        if (!app.exists() || !app.isDirectory()) {
            return;
        }
        this.host.getLogger().info((Object)sm.getString("userConfig.deploy", user));
        try {
            Class<?> clazz = Class.forName(this.contextClass);
            Context context = (Context)clazz.newInstance();
            context.setPath(contextPath);
            context.setDocBase(app.toString());
            if (context instanceof Lifecycle) {
                clazz = Class.forName(this.configClass);
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)((Object)context)).addLifecycleListener(listener);
            }
            this.host.addChild(context);
        }
        catch (Exception e) {
            this.host.getLogger().error((Object)sm.getString("userConfig.error", user), (Throwable)e);
        }
    }

    private void start() {
        if (this.host.getLogger().isDebugEnabled()) {
            this.host.getLogger().debug((Object)sm.getString("userConfig.start"));
        }
        this.deploy();
    }

    private void stop() {
        if (this.host.getLogger().isDebugEnabled()) {
            this.host.getLogger().debug((Object)sm.getString("userConfig.stop"));
        }
    }
}

