/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsFile;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.output.HTMLOutput;
import net.sf.statcvs.output.HTMLPage;
import net.sf.statcvs.output.HTMLTagger;
import net.sf.statcvs.output.WebRepositoryIntegration;
import net.sf.statcvs.renderer.CommitLogRenderer;
import net.sf.statcvs.renderer.TableRenderer;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.reports.AuthorsForDirectoryTableReport;

public class ModulePage
extends HTMLPage {
    private Directory directory;
    private int locInModule = 0;
    private boolean locImageCreated;

    public ModulePage(CvsContent content, Directory directory, boolean locImageCreated) throws IOException {
        super(content);
        this.setFileName(HTMLOutput.getDirectoryPageFilename(directory));
        this.setPageName("Module " + directory.getPath());
        this.directory = directory;
        this.locImageCreated = locImageCreated;
        Iterator it = directory.getFiles().iterator();
        while (it.hasNext()) {
            CvsFile file = (CvsFile)it.next();
            this.locInModule += file.getCurrentLinesOfCode();
        }
        this.createPage();
    }

    protected void printBody() throws IOException {
        this.printBackLink();
        this.print(this.getModuleInfo());
        this.print(this.getWebRepositoryLink());
        this.printH2(Messages.getString("SUBTREE_TITLE"));
        this.printParagraph(this.getModuleLinks());
        this.print(this.getLOCImage());
        this.print(this.getCPUTable());
        this.print(this.getLastCommits());
    }

    private String getModuleInfo() {
        if (this.directory.getRevisions().isEmpty()) {
            return "";
        }
        CvsRevision firstRev = (CvsRevision)this.directory.getRevisions().first();
        CvsRevision lastRev = (CvsRevision)this.directory.getRevisions().last();
        return HTMLTagger.getSummaryPeriod(firstRev.getDate(), lastRev.getDate());
    }

    private String getWebRepositoryLink() {
        if (ConfigurationOptions.getWebRepository() == null) {
            return "";
        }
        WebRepositoryIntegration rep = ConfigurationOptions.getWebRepository();
        String text = Messages.getString("BROWSE_WEB_REPOSITORY") + " " + rep.getName();
        return this.p(this.a(rep.getDirectoryUrl(this.directory), text));
    }

    private String getModuleLinks() {
        Iterator it = this.directory.getSubdirectoriesRecursive().iterator();
        Directory current = (Directory)it.next();
        String result = this.getRootLinks(current) + "<br>";
        while (it.hasNext()) {
            Directory dir = (Directory)it.next();
            result = result + this.getFolderHtml(dir, this.directory.getDepth());
        }
        return result;
    }

    private String getLOCImage() {
        if (!this.locImageCreated) {
            return "";
        }
        String result = this.h2(Messages.getString("LOC_TITLE"));
        result = result + this.p(this.img(HTMLOutput.getDirectoryLocChartFilename(this.directory), 640, 480) + this.br() + this.strong("Total Lines Of Code: ") + this.locInModule + " (" + HTMLTagger.getDateAndTime(this.getContent().getLastDate()) + ")");
        return result;
    }

    private String getCPUTable() {
        if (this.directory.getRevisions().isEmpty()) {
            return "";
        }
        String result = this.h2(Messages.getString("CPU_TITLE"));
        AuthorsForDirectoryTableReport report = new AuthorsForDirectoryTableReport(this.getContent(), this.directory);
        report.calculate();
        Table table = report.getTable();
        result = result + new TableRenderer(table).getRenderedTable();
        return result;
    }

    private String getLastCommits() {
        ArrayList<Commit> dirCommits = new ArrayList<Commit>();
        Iterator it = this.directory.getRevisions().iterator();
        while (it.hasNext()) {
            CvsRevision rev = (CvsRevision)it.next();
            Commit commit = this.getCommit(rev);
            if (commit == null || dirCommits.contains(commit)) continue;
            dirCommits.add(commit);
        }
        int commitCount = dirCommits.size();
        if (commitCount == 0) {
            return "";
        }
        String result = this.h2(Messages.getString("MOST_RECENT_COMMITS"));
        CommitLogRenderer renderer = new CommitLogRenderer(dirCommits);
        result = result + renderer.renderMostRecentCommits(20);
        return result;
    }

    private String getRootLinks(Directory dir) {
        String result;
        String string = result = dir.isRoot() ? this.strong(Messages.getString("NAVIGATION_ROOT")) : this.strong(dir.getName());
        while (!dir.isRoot()) {
            Directory parent = dir.getParent();
            String caption = parent.isRoot() ? Messages.getString("NAVIGATION_ROOT") : parent.getName();
            String parentPageFilename = HTMLOutput.getDirectoryPageFilename(parent);
            result = this.a(parentPageFilename, caption) + "/" + result;
            dir = parent;
        }
        return result;
    }

    private Commit getCommit(CvsRevision rev) {
        Iterator it = this.getContent().getCommits().iterator();
        while (it.hasNext()) {
            Commit commit = (Commit)it.next();
            if (!commit.getRevisions().contains(rev)) continue;
            return commit;
        }
        return null;
    }
}

