/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.util.ArrayList;
import java.util.List;
import net.sf.statcvs.output.ConfigurationException;
import net.sf.statcvs.output.ConfigurationOptions;

public class CommandLineParser {
    private String[] argsArray;
    private List args = new ArrayList();
    private int argCount = 0;

    public CommandLineParser(String[] args) {
        this.argsArray = args;
    }

    public void parse() throws ConfigurationException {
        for (int i = 0; i < this.argsArray.length; ++i) {
            this.args.add(this.argsArray[i]);
        }
        while (!this.args.isEmpty()) {
            String currentArg = this.popNextArg();
            if (currentArg.startsWith("-")) {
                this.parseSwitch(currentArg.substring(1));
                continue;
            }
            this.parseArgument(currentArg);
        }
        this.checkForRequiredArgs();
    }

    private String popNextArg() {
        return (String)this.args.remove(0);
    }

    private void parseSwitch(String switchName) throws ConfigurationException {
        String s = switchName.toLowerCase();
        if (s.equals("css")) {
            if (this.args.isEmpty()) {
                throw new ConfigurationException("Missing argument for -css");
            }
            ConfigurationOptions.setCssFile(this.popNextArg());
        } else if (s.equals("output-dir")) {
            if (this.args.isEmpty()) {
                throw new ConfigurationException("Missing argument for -output-dir");
            }
            ConfigurationOptions.setOutputDir(this.popNextArg());
        } else if (s.equals("verbose")) {
            ConfigurationOptions.setVerboseLogging();
        } else if (s.equals("debug")) {
            ConfigurationOptions.setDebugLogging();
        } else if (s.equals("notes")) {
            if (this.args.isEmpty()) {
                throw new ConfigurationException("Missing argument for -notes");
            }
            ConfigurationOptions.setNotesFile(this.popNextArg());
        } else if (s.equals("viewcvs")) {
            if (this.args.isEmpty()) {
                throw new ConfigurationException("Missing argument for -viewcvs");
            }
            ConfigurationOptions.setViewCvsURL(this.popNextArg());
        } else if (s.equals("cvsweb")) {
            if (this.args.isEmpty()) {
                throw new ConfigurationException("Missing argument for -cvsweb");
            }
            ConfigurationOptions.setCvswebURL(this.popNextArg());
        } else if (s.equals("chora")) {
            if (this.args.isEmpty()) {
                throw new ConfigurationException("Missing argument for -chora");
            }
            ConfigurationOptions.setChoraURL(this.popNextArg());
        } else if (s.equals("include")) {
            if (this.args.isEmpty()) {
                throw new ConfigurationException("Missing argument for -include");
            }
            ConfigurationOptions.setIncludePattern(this.popNextArg());
        } else if (s.equals("exclude")) {
            if (this.args.isEmpty()) {
                throw new ConfigurationException("Missing argument for -exclude");
            }
            ConfigurationOptions.setExcludePattern(this.popNextArg());
        } else if (s.equals("title")) {
            if (this.args.isEmpty()) {
                throw new ConfigurationException("Missing argument for -title");
            }
            ConfigurationOptions.setProjectName(this.popNextArg());
        } else {
            throw new ConfigurationException("Unrecognized option -" + s);
        }
    }

    private void parseArgument(String arg) throws ConfigurationException {
        ++this.argCount;
        switch (this.argCount) {
            case 1: {
                ConfigurationOptions.setLogFileName(arg);
                break;
            }
            case 2: {
                ConfigurationOptions.setCheckedOutDirectory(arg);
                break;
            }
            default: {
                throw new ConfigurationException("Too many arguments");
            }
        }
    }

    private void checkForRequiredArgs() throws ConfigurationException {
        switch (this.argCount) {
            case 0: {
                throw new ConfigurationException("Not enough arguments - <logfile> is missing");
            }
            case 1: {
                throw new ConfigurationException("Not enough arguments - <directory> is missing");
            }
        }
    }
}

