/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.io.IOException;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.output.HTMLPage;
import net.sf.statcvs.renderer.TableRenderer;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.reports.AuthorsTableReport;

public class CPAPage
extends HTMLPage {
    private int sortType;
    private boolean withImage;

    public CPAPage(CvsContent content, int sortType, boolean withImage) throws IOException {
        super(content);
        this.sortType = sortType;
        if (sortType == 1) {
            this.setFileName("authors.html");
        } else {
            this.setFileName("authors2.html");
        }
        this.withImage = withImage;
        this.setPageName(Messages.getString("CPU_TITLE"));
        this.createPage();
    }

    protected void printBody() throws IOException {
        this.printBackLink();
        AuthorsTableReport report = new AuthorsTableReport(this.getContent(), this.sortType);
        report.calculate();
        Table table = report.getTable();
        this.print(new TableRenderer(table).getRenderedTable());
        if (this.sortType == 1) {
            this.printParagraph(Messages.getString("NAVIGATION_ORDER_BY") + ": " + this.strong(Messages.getString("ORDER_BY_LOC")) + " / " + this.a("authors2.html", Messages.getString("ORDER_BY_NAME")));
        } else {
            this.printParagraph(Messages.getString("NAVIGATION_ORDER_BY") + ": " + this.a("authors.html", Messages.getString("ORDER_BY_LOC")) + " / " + this.strong(Messages.getString("ORDER_BY_NAME")));
        }
        if (this.withImage) {
            this.printH2(Messages.getString("LOC_TITLE"));
            this.printParagraph(this.img("loc_per_author.png", 640, 480));
        }
        this.printH2(Messages.getString("ACTIVITY_TITLE"));
        this.printParagraph(this.img("activity_time.png", 500, 300));
        this.printParagraph(this.img("activity_day.png", 500, 300));
        this.print(this.getAuthorActivityChartSection());
    }

    private String getAuthorActivityChartSection() {
        String result = "";
        result = result + this.h2(Messages.getString("AUTHOR_ACTIVITY_TITLE"));
        result = result + this.p(this.img("commitscatterauthors.png"));
        result = result + this.p(this.img("activity.png"));
        return result;
    }
}

